/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SingleNamespaceSchema;
import com.saxonica.schema.TypeReference;
import com.saxonica.schema.UserSimpleType;
import com.saxonica.schema.sdoc.SchemaElement;
import com.saxonica.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.schema.sdoc.XSDRedefine;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;

public class XSDSimpleType
extends SchemaElement {
    private boolean isRedefinition;
    private SimpleTypeDefinition simpleTypeDef = null;
    boolean foundRestriction = false;
    private static final int[] state0terms = new int[]{602, 624, 616, 578};
    private static final int[] state0targets = new int[]{1, 1, 1, 2};
    private static final int[] state1terms = new int[0];
    private static final int[] state1targets = new int[0];
    private static final int[] state2terms = new int[]{602, 624, 616};
    private static final int[] state2targets = new int[]{1, 1, 1};
    private static final int[][] stateTerms = new int[][]{state0terms, state1terms, state2terms};
    private static final int[][] stateTargets = new int[][]{state0targets, state1targets, state2targets};

    public void prepareAttributes() throws SchemaException {
        String[] allowed;
        SingleNamespaceSchema schema = this.getSchema();
        this.isRedefinition = this.getParent() instanceof XSDRedefine;
        AttributeCollection atts = this.getAttributeList();
        if (this.isTopLevel()) {
            allowed = new String[]{"final", "id", "name"};
            this.allowAttributes(atts, allowed);
            this.requireAttribute(atts, "name");
        } else {
            allowed = new String[]{"id"};
            this.allowAttributes(atts, allowed);
        }
        String name = atts.getValue("", "name");
        this.simpleTypeDef = new SimpleTypeDefinition((EnterpriseConfiguration)this.getConfiguration());
        this.simpleTypeDef.setLocator(this);
        this.simpleTypeDef.setSchemaDocumentURI(this.getParent().getSystemId());
        this.processId();
        if (name != null) {
            int nc = -1;
            try {
                nc = this.getNameCode(name, 1);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
                name = "saxon-error-simpleType-name";
                nc = this.getNameCode(name, 1);
            }
            this.simpleTypeDef.setNameCode(nc);
            int fp = nc & 0xFFFFF;
            if (!this.isRedefinition && schema.getSchemaType(fp) != null && fp > 1023) {
                this.duplicate("type", name);
            }
        } else {
            int tc = this.allocateAnonymousTypeCode();
            this.simpleTypeDef.setNameCode(tc);
            schema.addType(this.simpleTypeDef);
        }
        String finalVal = atts.getValue("", "final");
        if (finalVal == null) {
            this.simpleTypeDef.setFinalProhibitions(this.getXSDSchema().getFinalDefault());
        } else {
            int f = this.parseFinalOrBlock("final", finalVal, 13);
            this.simpleTypeDef.setFinalProhibitions(f);
        }
    }

    public SimpleTypeDefinition getSimpleTypeDefinition() throws SchemaException {
        return this.simpleTypeDef;
    }

    public void validate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        this.checkContentModel(stateTerms, stateTargets, false);
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)iter.next()) != null) {
            switch (child.getFingerprint()) {
                case 616: {
                    this.foundRestriction = true;
                    this.simpleTypeDef.setDerivationMethod(1);
                    break;
                }
                case 602: {
                    this.simpleTypeDef.setDerivationMethod(8);
                    break;
                }
                case 624: {
                    this.simpleTypeDef.setDerivationMethod(4);
                }
            }
        }
    }

    protected boolean isFinalState(int state) {
        return state == 1;
    }

    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        if (this.isRedefinition) {
            SingleNamespaceSchema externalSchema = ((XSDRedefine)this.getParent()).getExternalSchema();
            SingleNamespaceSchema redefinedSchema = ((XSDRedefine)this.getParent()).getRedefinedSchema();
            if (externalSchema == null || redefinedSchema == null) {
                return;
            }
            if (!this.foundRestriction) {
                this.error("A redefined simple type must be a restriction");
                return;
            }
            if (this.simpleTypeDef.getBaseTypeFingerprint() != this.simpleTypeDef.getFingerprint()) {
                this.error("A redefined simple type must be based on the type with the same name");
                return;
            }
            SimpleType oldSType = externalSchema.getSimpleType(this.simpleTypeDef.getFingerprint());
            if (oldSType == null) {
                this.error("Cannot redefine the simple type " + this.simpleTypeDef.getDescription() + " because it is not present in the redefined schema");
                return;
            }
            if (!(oldSType instanceof UserSimpleType)) {
                this.error("Cannot redefine a built-in simple type (" + this.simpleTypeDef.getDescription() + ')');
                return;
            }
            if (!((XSDRedefine)this.getParent()).getExternalSchemaDocumentURI().equals(((UserSimpleType)oldSType).getSchemaDocumentURI())) {
                compiler.warning("The redefined simple type was found, but not in the schema document referenced by the schemaLocation attribute of the containing <xs:redefine> element. This is not allowed by the XSD specification. However, Saxon does not currently enforce this rule.", this);
            }
            this.simpleTypeDef.setRedefinitionLevel(oldSType.getRedefinitionLevel() + 1);
            UserSimpleType oldType = (UserSimpleType)oldSType;
            String uri = this.getXSDSchema().getTargetNamespace();
            NamePool pool = this.getNamePool();
            String localName = pool.getLocalName(this.simpleTypeDef.getFingerprint());
            String prefix = pool.getPrefix(this.simpleTypeDef.getNameCode());
            String newLocalName = localName + '_' + this.simpleTypeDef.hashCode();
            int newNameCode = pool.allocate(prefix, uri, newLocalName);
            oldType.setNameCode(newNameCode);
            TypeReference ref = new TypeReference(newNameCode & 0xFFFFF, this.simpleTypeDef.getConfiguration(), this);
            this.simpleTypeDef.setBaseTypeReference(ref);
            redefinedSchema.addType(oldType);
            redefinedSchema.addType(this.simpleTypeDef);
        } else {
            int fp = this.simpleTypeDef.getFingerprint();
            if (fp != -1 && fp == this.simpleTypeDef.getBaseTypeFingerprint()) {
                this.error("A simple type must not be based on itself");
            }
        }
    }
}

