/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.AttributeDecl;
import com.saxonica.schema.AttributeGroupDecl;
import com.saxonica.schema.AttributeGroupReference;
import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.ModelGroupDefinition;
import com.saxonica.schema.Notation;
import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SingleNamespaceSchema;
import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.Wildcard;
import com.saxonica.schema.sdoc.SchemaElement;
import com.saxonica.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.schema.sdoc.XSDAttribute;
import com.saxonica.schema.sdoc.XSDAttributeGroup;
import com.saxonica.schema.sdoc.XSDComplexType;
import com.saxonica.schema.sdoc.XSDDefaultOpenContent;
import com.saxonica.schema.sdoc.XSDElement;
import com.saxonica.schema.sdoc.XSDGroup;
import com.saxonica.schema.sdoc.XSDImport;
import com.saxonica.schema.sdoc.XSDInclude;
import com.saxonica.schema.sdoc.XSDNotation;
import com.saxonica.schema.sdoc.XSDOverride;
import com.saxonica.schema.sdoc.XSDRedefine;
import com.saxonica.schema.sdoc.XSDSimpleType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.SchemaException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDSchema
extends SchemaElement {
    private SingleNamespaceSchema schema = null;
    private SchemaCompiler compiler;
    private int errorCount = 0;
    private HashMap<StructuredQName, GlobalParam> params = new HashMap();
    private SchemaElement referrer;
    private String attributeFormDefault = null;
    private int blockDefault = 0;
    private String elementFormDefault = null;
    private int finalDefault = 0;
    private String targetNamespace;
    private boolean isChameleon = false;
    private Set importedNamespaces = null;
    private Wildcard openContentWildcard;
    private String openContentMode;
    private boolean openContentAppliesToEmpty = false;
    private String xpathDefaultNamespace = "##local";
    private int defaultAttributeGroup = -1;
    private AttributeGroupReference defaultAttributeGroupReference = null;
    private Set<String> saxonExtensionEnabled = new HashSet<String>();
    private static final int[] state0terms = new int[]{613, 597, 589, 621, 578, 585, 588, 598, 611, 591, 584, 596, 615};
    private static final int[] state0targets = new int[]{2, 2, 3, 1, 2, 1, 1, 2, 1, 1, 1, 1, 2};
    private static final int[] state1terms = new int[]{591, 596, 621, 588, 611, 585, 584, 578};
    private static final int[] state1targets = new int[]{1, 1, 1, 1, 1, 1, 1, 4};
    private static final int[] state2terms = new int[]{613, 597, 589, 621, 578, 585, 588, 598, 611, 591, 584, 596, 615};
    private static final int[] state2targets = new int[]{2, 2, 3, 1, 2, 1, 1, 2, 1, 1, 1, 1, 2};
    private static final int[] state3terms = new int[]{591, 596, 621, 588, 611, 585, 584, 578};
    private static final int[] state3targets = new int[]{1, 1, 1, 1, 1, 1, 1, 5};
    private static final int[] state4terms = new int[]{591, 596, 621, 588, 611, 585, 584, 578};
    private static final int[] state4targets = new int[]{1, 1, 1, 1, 1, 1, 1, 4};
    private static final int[] state5terms = new int[]{591, 596, 621, 588, 611, 585, 584, 578};
    private static final int[] state5targets = new int[]{1, 1, 1, 1, 1, 1, 1, 5};
    private static final int[][] stateTerms = new int[][]{state0terms, state1terms, state2terms, state3terms, state4terms, state5terms};
    private static final int[][] stateTargets = new int[][]{state0targets, state1targets, state2targets, state3targets, state4targets, state5targets};

    @Override
    public SingleNamespaceSchema getSchema() {
        return this.schema;
    }

    public Set<String> getAllowedExtensions() {
        return this.saxonExtensionEnabled;
    }

    public void setSchema(SingleNamespaceSchema schema) {
        this.schema = schema;
    }

    public void setSchemaCompiler(SchemaCompiler manager) {
        this.compiler = manager;
    }

    public SchemaCompiler getSchemaCompiler() {
        return this.compiler;
    }

    public void setReferrer(SchemaElement referrer) {
        this.referrer = referrer;
    }

    public boolean isChameleon() {
        return this.isChameleon;
    }

    @Override
    public void prepareAttributes() throws SchemaException {
        Configuration config = this.getDocumentRoot().getConfiguration();
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"attributeFormDefault", "blockDefault", "defaultAttributes", "elementFormDefault", "finalDefault", "id", "targetNamespace", "version", "xpathDefaultNamespace"};
        this.allowAttributes(atts, allowed);
        String nsURI = atts.getValue("", "targetNamespace");
        if (nsURI != null && nsURI.length() == 0) {
            this.error("The zero-length string is not a legal namespace URI");
            nsURI = null;
        }
        if (nsURI != null) {
            String includingNamespace;
            if ((this.referrer instanceof XSDInclude || this.referrer instanceof XSDRedefine) && !(includingNamespace = this.referrer.getXSDSchema().getTargetNamespace()).equals(nsURI)) {
                this.error("The target namespace of the included schema must be the same as the target namespace of the including schema");
                return;
            }
            this.schema.setTargetNamespace(nsURI);
            ((EnterpriseConfiguration)config).addSurrogateSchema(nsURI);
            this.targetNamespace = nsURI;
        } else if (this.referrer instanceof XSDInclude || this.referrer instanceof XSDRedefine || this.referrer instanceof XSDOverride) {
            this.targetNamespace = this.referrer.getXSDSchema().getTargetNamespace();
            this.isChameleon = true;
        } else {
            this.targetNamespace = "";
            ((EnterpriseConfiguration)config).addSurrogateSchema("");
        }
        String extensions = atts.getValue("http://saxon.sf.net/", "extensions");
        if (extensions != null) {
            StringTokenizer st = new StringTokenizer(extensions);
            while (st.hasMoreTokens()) {
                this.saxonExtensionEnabled.add(st.nextToken());
            }
        }
        this.processId();
        String attValue = atts.getValue("", "attributeFormDefault");
        if (attValue != null) {
            if (attValue.equals("qualified") || attValue.equals("unqualified")) {
                this.setAttributeFormDefault(attValue);
            } else {
                this.invalidAttributeValue("attributeFormDefault", attValue, "Must be 'qualified' or 'unqualified'");
            }
        }
        if ((attValue = atts.getValue("", "defaultAttributes")) != null) {
            try {
                this.defaultAttributeGroup = this.getNameCode(attValue, 3) & 0xFFFFF;
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
            }
        }
        if ((attValue = atts.getValue("", "elementFormDefault")) != null) {
            if (attValue.equals("qualified") || attValue.equals("unqualified")) {
                this.setElementFormDefault(attValue);
            } else {
                this.invalidAttributeValue("elementFormDefault", attValue, "Must be 'qualified' or 'unqualified'");
            }
        }
        if ((attValue = atts.getValue("", "blockDefault")) != null) {
            int v = this.parseFinalOrBlock("blockDefault", attValue, 19);
            this.setBlockDefault(v);
        }
        if ((attValue = atts.getValue("", "finalDefault")) != null) {
            int v = this.parseFinalOrBlock("finalDefault", attValue, 15);
            this.setFinalDefault(v);
        }
        if ((attValue = atts.getValue("", "xpathDefaultNamespace")) != null) {
            this.xpathDefaultNamespace = attValue;
        }
    }

    public boolean isImportedNamespace(String uri) {
        if (this.importedNamespaces == null) {
            NodeInfo child;
            this.importedNamespaces = new HashSet(10);
            AxisIterator kids = this.iterateAxis((byte)3);
            while ((child = (NodeInfo)kids.next()) != null) {
                if (!(child instanceof XSDImport)) continue;
                String targetNamespace = ((XSDImport)child).getTargetNamespace();
                this.importedNamespaces.add(targetNamespace);
            }
        }
        return this.importedNamespaces.contains(uri);
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        if (this.getParent().getNodeKind() != 9) {
            this.error(Err.wrap(this.getDisplayName(), 1) + " must be the outermost element in a schema document");
            return;
        }
        if (compiler.getLanguageVersion() == 10) {
            if (!this.xpathDefaultNamespace.equals("##local")) {
                this.error("The xpathDefaultNamespace attribute requires XSD 1.1 to be enabled");
            }
            if (this.defaultAttributeGroup != -1) {
                this.error("The defaultAttributes attribute requires XSD 1.1 to be enabled");
            }
        }
        this.checkContentModel(stateTerms, stateTargets, false);
        if (this.defaultAttributeGroup != -1) {
            String attValue = this.getAttributeValue("", "defaultAttributes");
            try {
                this.defaultAttributeGroup = this.getNameCode(attValue, 0) & 0xFFFFF;
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
            }
        }
    }

    @Override
    protected void validateChildren(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (!(child instanceof XSDDefaultOpenContent)) continue;
            ((SchemaElement)child).validateSubtree(compiler);
        }
        kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (!(child instanceof SchemaElement) || child instanceof XSDDefaultOpenContent) continue;
            ((SchemaElement)child).validateSubtree(compiler);
        }
    }

    @Override
    protected boolean isFinalState(int state) {
        return state == 0 || state == 1 || state == 2 || state == 3 || state == 4 || state == 5;
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)iter.next()) != null) {
            int childfp = child.getFingerprint();
            switch (childfp) {
                case 584: {
                    AttributeDecl att = ((XSDAttribute)child).getAttributeDeclaration();
                    if (att == null) break;
                    if (this.schema.getAttributeDecl(att.getFingerprint()) != null) {
                        this.duplicate("attribute declaration", att.getDisplayName());
                    }
                    this.schema.addAttributeDecl(att);
                    break;
                }
                case 585: {
                    AttributeGroupDecl ag = ((XSDAttributeGroup)child).getAttributeGroupDecl();
                    if (ag == null) break;
                    int fp = ag.getFingerprint();
                    if (this.schema.getAttributeGroup(fp) != null) {
                        this.duplicate("attribute group", ag.getDisplayName());
                        break;
                    }
                    this.schema.addAttributeGroup(ag);
                    break;
                }
                case 588: {
                    UserComplexType complexType = ((XSDComplexType)child).getComplexType();
                    int fpt = complexType.getFingerprint();
                    if (this.schema.getSchemaType(fpt) != null && fpt > 1023) {
                        this.duplicate("complex type", complexType.getName());
                        break;
                    }
                    this.schema.addType(complexType);
                    break;
                }
                case 589: {
                    break;
                }
                case 621: {
                    SimpleTypeDefinition typeDef;
                    try {
                        typeDef = ((XSDSimpleType)child).getSimpleTypeDefinition();
                    }
                    catch (SchemaException e) {
                        this.error(e.getMessage());
                        return;
                    }
                    int fingerprint = typeDef.getFingerprint();
                    if (this.schema.getSchemaType(fingerprint) != null && fingerprint > 1023) {
                        this.duplicate("simple type", this.getNamePool().getDisplayName(fingerprint));
                        break;
                    }
                    this.schema.addType(typeDef);
                    break;
                }
                case 591: {
                    ElementDecl element = ((XSDElement)child).getElementDeclaration();
                    String elname = element.getName();
                    if (this.schema.getElementDecl(element.getFingerprint()) != null) {
                        this.duplicate("element declaration", elname);
                    }
                    this.schema.addElementDecl(element);
                    break;
                }
                case 596: {
                    ModelGroupDefinition group = ((XSDGroup)child).getGroupDeclaration();
                    String groupName = group.getName();
                    if (groupName == null) break;
                    if (this.schema.getGroup(group.getFingerprint()) != null) {
                        this.duplicate("group", groupName);
                        break;
                    }
                    this.schema.addGroup(group);
                    break;
                }
                case 611: {
                    Notation n = ((XSDNotation)child).getNotation();
                    if (this.schema.getNotation(n.getFingerprint()) != null) {
                        this.duplicate("notation", this.getNamePool().getDisplayName(n.getFingerprint()));
                        break;
                    }
                    this.schema.addNotation(n);
                    break;
                }
                case 598: {
                    PreparedSchema includedSchema = ((XSDInclude)child).getIncludedSchema();
                    if (includedSchema == null) break;
                    if (compiler.getErrorCount() > 0) {
                        ((XSDInclude)child).error("Errors were found in the included schema document");
                        break;
                    }
                    includedSchema.copyTo(this.schema, compiler);
                    if (compiler.getErrorCount() <= 0) break;
                    ((XSDInclude)child).error("The included schema document resulted in conflicting components");
                    break;
                }
                case 597: {
                    PreparedSchema importedSchema = ((XSDImport)child).getImportedSchema();
                    if (importedSchema == null) break;
                    importedSchema.copyTo(this.schema, compiler);
                    if (compiler.getErrorCount() <= 0) break;
                    ((XSDImport)child).error("The imported schema document resulted in conflicting components");
                    break;
                }
                case 615: {
                    SingleNamespaceSchema redefinedSchema = ((XSDRedefine)child).getRedefinedSchema();
                    if (redefinedSchema == null) break;
                    redefinedSchema.copyTo(this.schema, compiler);
                    if (compiler.getErrorCount() <= 0) break;
                    ((XSDRedefine)child).error("The redefined schema document resulted in conflicting components");
                }
            }
        }
    }

    public String getTargetNamespace() {
        if (this.targetNamespace == null) {
            this.targetNamespace = "";
        }
        return this.targetNamespace;
    }

    public String getAttributeFormDefault() {
        return this.attributeFormDefault;
    }

    public int getBlockDefault() {
        return this.blockDefault;
    }

    public String getElementFormDefault() {
        return this.elementFormDefault;
    }

    public int getFinalDefault() {
        return this.finalDefault;
    }

    public Wildcard getDefaultOpenContentWildcard() {
        return this.openContentWildcard;
    }

    public String getDefaultOpenContentMode() {
        return this.openContentMode;
    }

    public boolean defaultOpenContentAppliesToEmpty() {
        return this.openContentAppliesToEmpty;
    }

    public void setAttributeFormDefault(String attributeFormDefault) {
        this.attributeFormDefault = attributeFormDefault;
    }

    public void setBlockDefault(int value) {
        this.blockDefault = value;
    }

    public void setElementFormDefault(String elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
    }

    public void setFinalDefault(int value) {
        this.finalDefault = value;
    }

    public void setDefaultOpenContent(Wildcard wildcard, String mode, boolean appliesToEmpty) {
        this.openContentWildcard = wildcard;
        this.openContentMode = mode;
        this.openContentAppliesToEmpty = appliesToEmpty;
    }

    public String getXPathDefaultNamespace() {
        return this.xpathDefaultNamespace;
    }

    public AttributeGroupReference getDefaultAttributeGroupReference() {
        if (this.defaultAttributeGroupReference != null) {
            return this.defaultAttributeGroupReference;
        }
        if (this.defaultAttributeGroup == -1) {
            return null;
        }
        this.defaultAttributeGroupReference = new AttributeGroupReference((EnterpriseConfiguration)this.getConfiguration(), this.defaultAttributeGroup);
        return this.defaultAttributeGroupReference;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void incrementErrorCount() {
        ++this.errorCount;
    }

    public void addGlobalParam(GlobalParam param) throws SchemaException {
        GlobalParam prev = this.params.put(param.getVariableQName(), param);
        if (prev != null) {
            this.error("Duplicate declaration of parameter " + param.getVariableQName().getClarkName());
        }
    }

    public GlobalParam getGlobalParam(StructuredQName name) {
        return this.params.get(name);
    }

    public Collection<GlobalParam> getGlobalParams() {
        return this.params.values();
    }
}

