/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.AttributeDecl;
import com.saxonica.schema.AttributeGroupDecl;
import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.ModelGroupDefinition;
import com.saxonica.schema.Notation;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SingleNamespaceSchema;
import com.saxonica.schema.UserDefinedType;
import com.saxonica.schema.sdoc.SchemaDocument;
import com.saxonica.schema.sdoc.SchemaElement;
import com.saxonica.schema.sdoc.SchemaReader;
import com.saxonica.schema.sdoc.XSDAttribute;
import com.saxonica.schema.sdoc.XSDAttributeGroup;
import com.saxonica.schema.sdoc.XSDComplexType;
import com.saxonica.schema.sdoc.XSDElement;
import com.saxonica.schema.sdoc.XSDGroup;
import com.saxonica.schema.sdoc.XSDNotation;
import com.saxonica.schema.sdoc.XSDSimpleType;
import java.io.IOException;
import java.util.HashSet;
import javax.xml.transform.Source;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;

public class XSDOverride
extends SchemaElement {
    private SingleNamespaceSchema externalSchema;
    private SingleNamespaceSchema redefinedSchema;

    public void prepareAttributes() throws SchemaException {
        Source source;
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"id", "schemaLocation"};
        this.allowAttributes(atts, allowed);
        this.processId();
        String schemaLocation = atts.getValue("", "schemaLocation");
        if (schemaLocation == null) {
            this.missingAttribute("schemaLocation");
            this.error("Processing abandoned");
        }
        String documentBase = this.getBaseURI();
        PipelineConfiguration pipe = this.getSchemaNodeFactory().getPipelineConfiguration();
        SchemaCompiler manager = this.getXSDSchema().getSchemaCompiler();
        if (manager.isBeingRead((source = SchemaReader.getSource(documentBase, schemaLocation, pipe, null)).getSystemId())) {
            this.error("The schema document " + source.getSystemId() + " includes or overrides itself recursively");
            return;
        }
        if (manager.getExistingSchemaDocument(schemaLocation, this.getXSDSchema().getTargetNamespace()) != null) {
            this.error("Saxon can't handle overriding of a schema document that has already been loaded by a different route");
            return;
        }
        try {
            SchemaCompiler compiler = this.getSchemaNodeFactory().getSchemaCompiler();
            SchemaDocument schemaDoc = SchemaReader.read(source, compiler, pipe, this);
            this.externalSchema = schemaDoc.getXSDSchema().getSchema();
            if (!this.getSchema().getTargetNamespace().equals(this.externalSchema.getTargetNamespace()) && !this.externalSchema.getTargetNamespace().equals("")) {
                this.error("The targetNamespace of the overridden schema document differs from that of the overriding schema document");
                this.externalSchema = null;
            }
        }
        catch (SchemaException e) {
            Throwable cause = e.getException();
            if (cause instanceof IOException) {
                this.warning("Failed to locate overridden schema document " + schemaLocation);
                this.externalSchema = new SingleNamespaceSchema((EnterpriseConfiguration)this.getConfiguration(), "");
            }
            throw e;
        }
    }

    public SingleNamespaceSchema getRedefinedSchema() {
        return this.redefinedSchema;
    }

    public SingleNamespaceSchema getExternalSchema() {
        return this.externalSchema;
    }

    public void validate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        if (compiler.getLanguageVersion() == 10) {
            this.error("xs:override requires XML Schema 1.1 to be enabled");
            return;
        }
        if (this.externalSchema == null) {
            return;
        }
        HashSet<String> redefinedTypes = new HashSet<String>();
        HashSet<String> redefinedAttributeGroups = new HashSet<String>();
        HashSet<String> redefinedModelGroups = new HashSet<String>();
        HashSet<String> redefinedElements = new HashSet<String>();
        HashSet<String> redefinedAttributes = new HashSet<String>();
        HashSet<String> redefinedNotations = new HashSet<String>();
        int nameFP = this.getNamePool().allocate("", "", "name");
        AxisIterator iter = this.iterateAxis((byte)3);
        block9: while ((child = (NodeInfo)iter.next()) != null) {
            int fp = child.getFingerprint();
            switch (fp) {
                case 578: {
                    continue block9;
                }
                case 584: {
                    String attributeName = child.getAttributeValue(nameFP);
                    if (attributeName == null || redefinedAttributes.add(attributeName)) continue block9;
                    this.error("Attempting to override the same attribute declaration more than once");
                    continue block9;
                }
                case 591: {
                    String elementName = child.getAttributeValue(nameFP);
                    if (elementName == null || redefinedElements.add(elementName)) continue block9;
                    this.error("Attempting to override the same element declaration more than once");
                    continue block9;
                }
                case 585: {
                    String attributeGroupName = child.getAttributeValue(nameFP);
                    if (attributeGroupName == null || redefinedAttributeGroups.add(attributeGroupName)) continue block9;
                    this.error("Attempting to override the same attribute group more than once");
                    continue block9;
                }
                case 588: 
                case 621: {
                    String typeName = child.getAttributeValue(nameFP);
                    if (typeName == null || redefinedTypes.add(typeName)) continue block9;
                    this.error("Attempting to override the same type more than once");
                    continue block9;
                }
                case 596: {
                    String modelGroupName = child.getAttributeValue(nameFP);
                    if (modelGroupName == null || redefinedModelGroups.add(modelGroupName)) continue block9;
                    this.error("Attempting to override the same named model group more than once");
                    continue block9;
                }
                case 611: {
                    String notationName = child.getAttributeValue(nameFP);
                    if (notationName == null || redefinedNotations.add(notationName)) continue block9;
                    this.error("Attempting to override the same notation declaration more than once");
                    continue block9;
                }
            }
            this.illegalElement(child);
        }
        this.redefinedSchema = new SingleNamespaceSchema(this.externalSchema.getConfiguration(), this.externalSchema.getTargetNamespace());
        this.externalSchema.copyTo(this.redefinedSchema, compiler);
    }

    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        NodeInfo child;
        if (this.externalSchema == null) {
            return;
        }
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)iter.next()) != null) {
            int childfp = child.getFingerprint();
            switch (childfp) {
                case 584: {
                    AttributeDecl attribute = ((XSDAttribute)child).getAttributeDeclaration();
                    if (attribute == null) break;
                    AttributeDecl existing = this.externalSchema.getAttributeDecl(attribute.getFingerprint());
                    if (existing != null) {
                        attribute.setRedefinitionLevel(existing.getRedefinitionLevel() + 1);
                    } else {
                        this.warning("The attribute declaration " + attribute.getName() + " does not override anything in the target schema");
                    }
                    this.redefinedSchema.addAttributeDecl(attribute);
                    break;
                }
                case 585: {
                    AttributeGroupDecl ag = ((XSDAttributeGroup)child).getAttributeGroupDecl();
                    if (ag == null) break;
                    AttributeGroupDecl existing = this.externalSchema.getAttributeGroup(ag.getFingerprint());
                    if (existing != null) {
                        ag.setRedefinitionLevel(existing.getRedefinitionLevel() + 1);
                    } else {
                        this.warning("The attribute group " + ag.getName() + " does not override anything in the target schema");
                    }
                    this.redefinedSchema.addAttributeGroup(ag);
                    break;
                }
                case 588: {
                    UserDefinedType typeDef;
                    try {
                        typeDef = ((XSDComplexType)child).getComplexType();
                    }
                    catch (SchemaException e) {
                        this.error(e.getMessage());
                        return;
                    }
                    if (typeDef == null) break;
                    int fingerprint = typeDef.getFingerprint();
                    SchemaType existing = this.externalSchema.getType(fingerprint);
                    if (existing == null) {
                        this.warning("The complex type " + typeDef.getName() + " does not override anything in the target schema");
                    } else if (existing.isSimpleType()) {
                        this.error("A complex type cannot override a simple type");
                    } else {
                        typeDef.setRedefinitionLevel(existing.getRedefinitionLevel() + 1);
                    }
                    this.redefinedSchema.addType(typeDef);
                    break;
                }
                case 621: {
                    UserDefinedType typeDef;
                    try {
                        typeDef = ((XSDSimpleType)child).getSimpleTypeDefinition();
                    }
                    catch (SchemaException e) {
                        this.error(e.getMessage());
                        return;
                    }
                    if (typeDef == null) break;
                    int fingerprint = typeDef.getFingerprint();
                    SchemaType existing = this.externalSchema.getSimpleType(fingerprint);
                    if (existing == null) {
                        if (this.externalSchema.getType(fingerprint) != null) {
                            this.error("The simple type " + typeDef.getName() + " cannot override a complex type");
                            break;
                        }
                        this.warning("The simple type " + typeDef.getName() + " does not override anything in the target schema");
                    } else if (existing.isBuiltInType()) {
                        this.error("Cannot override a built-in type");
                    } else {
                        typeDef.setRedefinitionLevel(existing.getRedefinitionLevel() + 1);
                    }
                    this.redefinedSchema.addType(typeDef);
                    break;
                }
                case 591: {
                    ElementDecl element = ((XSDElement)child).getElementDeclaration();
                    if (element == null) break;
                    ElementDecl existing = this.externalSchema.getElementDecl(element.getFingerprint());
                    if (existing != null) {
                        element.setRedefinitionLevel(existing.getRedefinitionLevel() + 1);
                    } else {
                        this.warning("The element declaration " + element.getName() + " does not override anything in the target schema");
                    }
                    this.redefinedSchema.addElementDecl(element);
                    break;
                }
                case 596: {
                    ModelGroupDefinition group = ((XSDGroup)child).getGroupDeclaration();
                    if (group == null) break;
                    ModelGroupDefinition existing = this.externalSchema.getGroup(group.getFingerprint());
                    if (existing != null) {
                        group.setRedefinitionLevel(existing.getRedefinitionLevel() + 1);
                    } else {
                        this.warning("The model group definition " + group.getName() + " does not override anything in the target schema");
                    }
                    this.redefinedSchema.addGroup(group);
                    break;
                }
                case 611: {
                    Notation n = ((XSDNotation)child).getNotation();
                    if (n == null) break;
                    Notation existing = this.externalSchema.getNotation(n.getFingerprint());
                    if (existing != null) {
                        n.setRedefinitionLevel(existing.getRedefinitionLevel() + 1);
                    } else {
                        this.warning("The notation declaration " + n.getName() + " does not override anything in the target schema");
                    }
                    this.redefinedSchema.addNotation(n);
                    break;
                }
            }
        }
        if (this.redefinedSchema != null) {
            this.redefinedSchema.copyTo(this.getSchema(), compiler);
        }
    }
}

