/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.schema.Notation;
import com.saxonica.schema.sdoc.AnnotationParent;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.type.SchemaException;

public class XSDNotation
extends AnnotationParent {
    private Notation notation;

    public void prepareAttributes() throws SchemaException {
        String systemAtt;
        String publicAtt;
        this.notation = new Notation(this.getSchema().getConfiguration(), this);
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"id", "name", "public", "system"};
        this.allowAttributes(atts, allowed);
        this.processId();
        String name = atts.getValue("", "name");
        if (name == null) {
            this.missingAttribute("name");
            name = "unnamed-notation-" + this.hashCode();
        }
        if (name != null) {
            int nc;
            try {
                nc = this.getNameCode(name, 1);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
                nc = 574;
            }
            this.notation.setNameCode(nc);
        }
        if ((publicAtt = atts.getValue("", "public")) != null) {
            this.notation.setNotationPublicId(publicAtt);
        }
        if ((systemAtt = atts.getValue("", "system")) != null) {
            this.notation.setNotationSystemId(systemAtt);
        }
        if (publicAtt == null && systemAtt == null) {
            this.error("A notation must have either a public identifier or a system identifier");
        }
        if (publicAtt != null && systemAtt != null) {
            this.warning("For compatibility, a notation should not have both a public identifier and a system identifier");
        }
    }

    public Notation getNotation() {
        return this.notation;
    }
}

