/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SingleNamespaceSchema;
import com.saxonica.schema.sdoc.AnnotationParent;
import com.saxonica.schema.sdoc.FnNamespaceSchema;
import com.saxonica.schema.sdoc.SchemaDocument;
import com.saxonica.schema.sdoc.SchemaReader;
import com.saxonica.schema.sdoc.XMLNamespaceSchema;
import com.saxonica.schema.sdoc.XSDSchema;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.type.SchemaException;

public class XSDImport
extends AnnotationParent {
    private PreparedSchema importedSchema;

    public void prepareAttributes() throws SchemaException {
        int status;
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"id", "namespace", "schemaLocation"};
        this.allowAttributes(atts, allowed);
        this.processId();
        String schemaLocation = atts.getValue("", "schemaLocation");
        String namespace = atts.getValue("", "namespace");
        if (schemaLocation == null && namespace == null) {
            return;
        }
        XSDSchema thisSchemaDocument = this.getXSDSchema();
        EnterpriseConfiguration config = (EnterpriseConfiguration)this.getConfiguration();
        SchemaCompiler manager = thisSchemaDocument.getSchemaCompiler();
        if (namespace == null) {
            namespace = "";
        }
        String documentBase = this.getBaseURI();
        Source source = null;
        if (schemaLocation != null) {
            source = SchemaReader.getSource(documentBase, schemaLocation, manager.getPipelineConfiguration(), namespace);
        }
        if (namespace.equals(thisSchemaDocument.getTargetNamespace())) {
            this.error("The 'namespace' attribute in the 'import' element cannot be the same as the 'targetNamespace' of the containing schema");
            return;
        }
        if (source != null) {
            if (manager.isBeingRead(source.getSystemId())) {
                return;
            }
            XSDSchema existing = manager.getExistingSchemaDocument(source.getSystemId(), namespace);
            if (existing != null) {
                this.importedSchema = existing.getSchema();
            }
        }
        if ((status = config.getNamespaceStatus(namespace)) == 2) {
            return;
        }
        if (status != 1) {
            return;
        }
        if (schemaLocation == null) {
            if (namespace.equals("http://www.w3.org/XML/1998/namespace")) {
                this.importedSchema = XMLNamespaceSchema.buildSchema(config);
                config.addSchema(this.importedSchema);
                return;
            }
            if (namespace.equals("http://www.w3.org/2005/xpath-functions")) {
                this.importedSchema = FnNamespaceSchema.buildSchema(config);
                config.addSchema(this.importedSchema);
                return;
            }
            this.warning("Cannot locate a schema for namespace " + namespace);
            this.importedSchema = new SingleNamespaceSchema((EnterpriseConfiguration)this.getConfiguration(), namespace);
            return;
        }
        SchemaDocument importee = null;
        int errors = 0;
        try {
            PipelineConfiguration pipe = this.getSchemaNodeFactory().getPipelineConfiguration();
            SchemaCompiler compiler = this.getSchemaNodeFactory().getSchemaCompiler();
            importee = SchemaReader.read(source, compiler, pipe, null);
            XSDSchema s = importee.getXSDSchema();
            errors = importee.getXSDSchema().getErrorCount();
            this.importedSchema = s.getSchema();
        }
        catch (SchemaException e) {
            Throwable cause = e.getException();
            if (cause instanceof IOException) {
                this.warning("Imported schema document " + schemaLocation + " cannot be located: " + cause.getClass().getName() + " (" + cause.getMessage() + ")");
            } else {
                this.error("Failed to process imported schema document: " + e.getMessage());
            }
            this.importedSchema = new SingleNamespaceSchema((EnterpriseConfiguration)this.getConfiguration(), namespace);
            errors = 0;
            return;
        }
        boolean valid = errors == 0;
        config.removeSchema(namespace);
        if (!valid) {
            throw new SchemaException("Imported schema is invalid");
        }
        String importedNamespace = importee.getTargetNamespace();
        if (thisSchemaDocument.getTargetNamespace().equals(importedNamespace)) {
            this.error("The targetNamespace of the imported schema must not be the same as the targetNamespace of the importing schema");
        }
        if (!namespace.equals(importedNamespace)) {
            this.error("The namespace attribute in xs:import differs from the targetNamespace of the imported schema");
        }
        try {
            config.addSchema(this.importedSchema);
        }
        catch (TransformerConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public PreparedSchema getImportedSchema() {
        return this.importedSchema;
    }

    public String getTargetNamespace() {
        String uri = this.getAttributeList().getValue("", "namespace");
        if (uri == null) {
            return "";
        }
        return uri;
    }
}

