/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.schema.IdentityField;
import com.saxonica.schema.IdentitySelector;
import com.saxonica.schema.SchemaStructure;
import com.saxonica.schema.sdoc.AnnotationParent;
import com.saxonica.schema.sdoc.SchemaElement;
import com.saxonica.schema.sdoc.SelectionParser;
import com.saxonica.stream.StreamingPatternMaker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.EmptySequence;

public class XSDFieldOrSelector
extends AnnotationParent {
    private SchemaStructure fieldOrSelector = null;

    public void prepareAttributes() throws SchemaException {
        Pattern selector;
        Expression exp;
        boolean isField = this.getLocalPart().equals("field");
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"id", "xpath", "xpathDefaultNamespace"};
        this.allowAttributes(atts, allowed);
        String defaultNS = atts.getValue("", "xpathDefaultNamespace");
        if (defaultNS == null) {
            defaultNS = this.getXSDSchema().getXPathDefaultNamespace();
        }
        if (defaultNS != null) {
            if (defaultNS.equals("##defaultNamespace")) {
                defaultNS = this.getURIForPrefix("", true);
            } else if (defaultNS.equals("##targetNamespace")) {
                defaultNS = this.getXSDSchema().getTargetNamespace();
            } else if (defaultNS.equals("##local")) {
                defaultNS = "";
            }
        } else {
            defaultNS = "";
        }
        String xpath = atts.getValue("", "xpath");
        if (xpath == null) {
            this.missingAttribute("xpath");
            xpath = ".";
        }
        SchemaElement.XPathStaticContext env = new SchemaElement.XPathStaticContext(this.getConfiguration());
        env.setDefaultElementNamespace(defaultNS);
        try {
            exp = new ExpressionParser().parse(xpath, 0, 0, 0, env);
            boolean allowExtensions = this.getXSDSchema().getAllowedExtensions().contains("id-xpath-syntax");
            selector = allowExtensions ? StreamingPatternMaker.fromExpression(exp, this.getConfiguration()) : new SelectionParser().parseSelector(xpath, env, isField);
        }
        catch (XPathException err) {
            this.error(err.getMessage());
            selector = new NodeTestPattern(EmptySequenceTest.getInstance());
            exp = new Literal(EmptySequence.getInstance());
        }
        this.processId();
        if (isField) {
            this.fieldOrSelector = new IdentityField(xpath);
            this.fieldOrSelector.setLocator(this);
            ((IdentityField)this.fieldOrSelector).setSelection(selector);
            ((IdentityField)this.fieldOrSelector).setEquivalentExpression(exp);
            ((IdentityField)this.fieldOrSelector).setNamespaceContext(this.makeNamespaceContext());
            ((IdentityField)this.fieldOrSelector).setXPathDefaultNamespace(defaultNS);
        } else {
            this.fieldOrSelector = new IdentitySelector(xpath);
            this.fieldOrSelector.setLocator(this);
            ((IdentitySelector)this.fieldOrSelector).setSelection(selector);
            ((IdentitySelector)this.fieldOrSelector).setNamespaceContext(this.makeNamespaceContext());
            ((IdentitySelector)this.fieldOrSelector).setXPathDefaultNamespace(defaultNS);
        }
    }

    public IdentityField getIdentityField() {
        if (this.fieldOrSelector instanceof IdentityField) {
            return (IdentityField)this.fieldOrSelector;
        }
        return null;
    }

    public IdentitySelector getIdentitySelector() {
        if (this.fieldOrSelector instanceof IdentitySelector) {
            return (IdentitySelector)this.fieldOrSelector;
        }
        return null;
    }
}

