/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.sdoc.SchemaElement;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.StringValue;

public class XSDDocumentation
extends SchemaElement {
    public void processAllAttributes() throws SchemaException {
        this.prepareAttributes();
        if (this.getFingerprint() == 581) {
            NodeInfo child;
            AxisIterator kids = this.iterateAxis((byte)3);
            while ((child = (NodeInfo)kids.next()) != null) {
            }
            return;
        }
    }

    public void prepareAttributes() throws SchemaException {
        ConversionResult val;
        String lang;
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"source"};
        this.allowAttributes(atts, allowed);
        String source = atts.getValue("", "source");
        if (source != null && !StandardURIChecker.getInstance().isValidURI(source)) {
            this.error("Value of source attribute must be a valid anyURI value");
        }
        if ((lang = atts.getValue("http://www.w3.org/XML/1998/namespace", "lang")) != null && (val = StringValue.convertStringToBuiltInType(lang, BuiltInAtomicType.LANGUAGE, this.getConfiguration().getConversionRules())) instanceof ValidationFailure) {
            this.error("Value of xml:lang attribute is not a valid language code");
        }
    }

    public void validateSubtree(SchemaCompiler compiler) {
    }

    public void validate(SchemaCompiler compiler) {
    }
}

