/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.schema.Facet;
import com.saxonica.schema.SchemaCompiler;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.DecimalValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionControlFilter
extends ProxyReceiver {
    private StartTagBuffer startTag;
    private SchemaCompiler compiler;
    private int minVersionCode;
    private int maxVersionCode;
    private int typeAvailableCode;
    private int typeUnavailableCode;
    private int facetAvailableCode;
    private int facetUnavailableCode;
    private int depthOfHole = 0;
    private boolean emptySchemaElement = false;
    private NameChecker nameChecker;
    private DecimalValue thisVersion;
    private boolean isXSD11;
    private boolean foundErrors;

    public VersionControlFilter(StartTagBuffer startTag, SchemaCompiler compiler) {
        this.startTag = startTag;
        this.compiler = compiler;
        int xsdVersion = compiler.getLanguageVersion();
        this.thisVersion = new DecimalValue(new BigDecimal(xsdVersion == 10 ? "1.0" : "1.1"));
        this.isXSD11 = xsdVersion == 11;
    }

    @Override
    public void open() throws XPathException {
        NamePool pool = this.getNamePool();
        this.minVersionCode = pool.allocate("", "http://www.w3.org/2007/XMLSchema-versioning", "minVersion");
        this.maxVersionCode = pool.allocate("", "http://www.w3.org/2007/XMLSchema-versioning", "maxVersion");
        this.typeAvailableCode = pool.allocate("", "http://www.w3.org/2007/XMLSchema-versioning", "typeAvailable");
        this.typeUnavailableCode = pool.allocate("", "http://www.w3.org/2007/XMLSchema-versioning", "typeUnavailable");
        this.facetAvailableCode = pool.allocate("", "http://www.w3.org/2007/XMLSchema-versioning", "facetAvailable");
        this.facetUnavailableCode = pool.allocate("", "http://www.w3.org/2007/XMLSchema-versioning", "facetUnavailable");
        this.nameChecker = this.getConfiguration().getNameChecker();
        this.nextReceiver.open();
    }

    @Override
    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        if (this.emptySchemaElement) {
            ++this.depthOfHole;
            return;
        }
        if (this.depthOfHole == 0) {
            boolean ignore = false;
            AttributeCollection atts = this.startTag.getAllAttributes();
            int numberOfAttributes = atts.getLength();
            block4: for (int a = 0; a < numberOfAttributes; ++a) {
                if (!"http://www.w3.org/2007/XMLSchema-versioning".equals(atts.getURI(a))) continue;
                int fp = atts.getNameCode(a) & 0xFFFFF;
                try {
                    DecimalValue dv;
                    if (fp == this.minVersionCode) {
                        dv = this.parseDecimalValue(atts.getValue(a));
                        if (this.thisVersion.compareTo(dv) >= 0) continue;
                        ignore = true;
                        break;
                    }
                    if (fp == this.maxVersionCode) {
                        dv = this.parseDecimalValue(atts.getValue(a));
                        if (this.thisVersion.compareTo(dv) < 0) continue;
                        ignore = true;
                        break;
                    }
                    if (fp == this.typeAvailableCode) {
                        Set<StructuredQName> typesAvailable = this.parseListOfQNames(atts.getValue(a), this.nameChecker, this.startTag);
                        for (StructuredQName name : typesAvailable) {
                            if (this.isAutomaticallyKnownTypeName(name)) continue;
                            ignore = true;
                            break block4;
                        }
                        continue;
                    }
                    if (fp == this.typeUnavailableCode) {
                        Set<StructuredQName> typesUnavailable = this.parseListOfQNames(atts.getValue(a), this.nameChecker, this.startTag);
                        ignore = true;
                        for (StructuredQName name : typesUnavailable) {
                            if (this.isAutomaticallyKnownTypeName(name)) continue;
                            ignore = false;
                            break block4;
                        }
                        continue;
                    }
                    if (fp == this.facetAvailableCode) {
                        Set<StructuredQName> facetsAvailable = this.parseListOfQNames(atts.getValue(a), this.nameChecker, this.startTag);
                        for (StructuredQName name : facetsAvailable) {
                            if (this.isKnownFacetName(name)) continue;
                            ignore = true;
                            break block4;
                        }
                        continue;
                    }
                    if (fp == this.facetUnavailableCode) {
                        Set<StructuredQName> facetsUnavailable = this.parseListOfQNames(atts.getValue(a), this.nameChecker, this.startTag);
                        ignore = true;
                        for (StructuredQName name : facetsUnavailable) {
                            if (this.isKnownFacetName(name)) continue;
                            ignore = false;
                            break block4;
                        }
                        continue;
                    }
                    ExpressionLocation loc = new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), locationId);
                    this.compiler.warning("Unrecognized attribute name " + atts.getQName(a), loc);
                    continue;
                }
                catch (XPathException e) {
                    ExpressionLocation loc = new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), locationId);
                    try {
                        this.compiler.error("Invalid value for attribute " + atts.getQName(a) + ": " + e.getMessage(), loc);
                        this.foundErrors = true;
                        continue;
                    }
                    catch (SchemaException e1) {
                        // empty catch block
                    }
                }
            }
            if (ignore) {
                int fp = nameCode & 0xFFFFF;
                if (fp == 617) {
                    this.emptySchemaElement = true;
                } else {
                    this.depthOfHole = 1;
                    return;
                }
            }
            this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
        } else {
            ++this.depthOfHole;
        }
    }

    @Override
    public void namespace(int namespaceCode, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.namespace(namespaceCode, properties);
        }
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
        }
    }

    @Override
    public void startContent() throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.startContent();
        }
    }

    @Override
    public void endElement() throws XPathException {
        if (this.depthOfHole > 0) {
            --this.depthOfHole;
        } else {
            this.nextReceiver.endElement();
        }
    }

    @Override
    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.characters(chars, locationId, properties);
        }
    }

    @Override
    public void processingInstruction(String target, CharSequence data, int locationId, int properties) {
    }

    @Override
    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
    }

    @Override
    public void endDocument() throws XPathException {
        super.endDocument();
        if (this.foundErrors) {
            throw new XPathException("One or more errors were found in the content of schema versioning attributes");
        }
    }

    private DecimalValue parseDecimalValue(String value) throws ValidationException {
        return (DecimalValue)DecimalValue.makeDecimalValue(value, true).asAtomic();
    }

    private Set<StructuredQName> parseListOfQNames(String value, NameChecker checker, NamespaceResolver resolver) throws XPathException {
        HashSet<StructuredQName> result = new HashSet<StructuredQName>(4);
        StringTokenizer tokenizer = new StringTokenizer(value, " \t\n\r", false);
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            StructuredQName val = StructuredQName.fromLexicalQName(tok, true, checker, resolver);
            result.add(val);
        }
        return result;
    }

    private boolean isKnownFacetName(StructuredQName name) {
        String localName = name.getLocalName();
        return "http://www.w3.org/2001/XMLSchema".equals(name.getNamespaceURI()) && Facet.isFacetName(localName, this.isXSD11 ? 11 : 10);
    }

    private boolean isAutomaticallyKnownTypeName(StructuredQName name) {
        int fp = StandardNames.getFingerprint(name.getNamespaceURI(), name.getLocalName());
        return fp != -1 && BuiltInType.getSchemaType(fp) != null && (this.isXSD11 || fp != 575);
    }
}

