/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.stream.StreamingPatternMaker;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.om.Axis;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DecimalValue;

public class SelectionParser
extends ExpressionParser {
    boolean isFieldSubset;

    public Pattern parseSelector(String expression, StaticContext env, boolean isField) throws XPathException {
        this.setLanguage(0, DecimalValue.TWO);
        this.env = env;
        this.nameChecker = env.getConfiguration().getNameChecker();
        this.isFieldSubset = isField;
        this.t = new Tokenizer();
        try {
            this.t.tokenize(expression, 0, -1, 1);
        }
        catch (XPathException err) {
            this.grumble(err.getMessage());
        }
        Expression exp = this.parseUnionExpression();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of expression");
        }
        ExpressionVisitor visitor = ExpressionVisitor.make(env, null);
        exp = exp.simplify(visitor).typeCheck(visitor, AnyNodeTest.getInstance());
        return StreamingPatternMaker.fromExpression(exp, env.getConfiguration());
    }

    protected Expression parseUnionExpression() throws XPathException {
        Expression exp = this.parseRelativePath();
        while (this.t.currentToken == 1) {
            if (this.t.currentTokenValue.equals("union")) {
                this.grumble("Union operator in the selector/field XPath subset must be written as '|'");
            }
            this.nextToken();
            exp = new VennExpression(exp, 1, this.parseRelativePath());
            this.setLocation(exp);
        }
        return exp;
    }

    protected Expression parseRelativePath() throws XPathException {
        boolean first = true;
        Expression exp = this.parseStepExpression();
        while (this.t.currentToken == 2 || this.t.currentToken == 8) {
            if (!(this.t.currentToken != 8 || first && exp instanceof ContextItemExpression)) {
                this.grumble("The // operator can be used only at the start of the path, preceded by '.'");
            }
            first = false;
            int op = this.t.currentToken;
            this.nextToken();
            Expression next = this.parseStepExpression();
            if (op == 2) {
                exp = new SlashExpression(exp, next);
            } else {
                AxisExpression ae = new AxisExpression(5, null);
                this.setLocation(ae);
                SlashExpression se = new SlashExpression(ae, next);
                this.setLocation(se);
                exp = new SlashExpression(exp, se);
            }
            this.setLocation(exp);
        }
        return exp;
    }

    protected Expression parseStepExpression() throws XPathException {
        switch (this.t.currentToken) {
            case 205: {
                this.nextToken();
                return new ContextItemExpression();
            }
            case 201: 
            case 207: 
            case 208: {
                return new AxisExpression(3, this.parseNodeTest((short)1));
            }
            case 3: {
                if (!this.isFieldSubset) {
                    this.grumble("The attribute axis cannot be used in a selector XPath");
                }
                this.nextToken();
                switch (this.t.currentToken) {
                    case 201: 
                    case 207: 
                    case 208: {
                        return new AxisExpression(2, this.parseNodeTest((short)2));
                    }
                }
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " after axis name");
            }
            case 35: {
                byte axis = Axis.getAxisNumber(this.t.currentTokenValue);
                if (axis != 3 && axis != 2) {
                    this.grumble("Only the child and attribute axes are permitted");
                }
                if (axis == 2 && !this.isFieldSubset) {
                    this.grumble("The attribute axis cannot be used in a selector XPath");
                }
                short principalNodeType = Axis.principalNodeType[axis];
                this.nextToken();
                switch (this.t.currentToken) {
                    case 201: 
                    case 207: 
                    case 208: {
                        return new AxisExpression(axis, this.parseNodeTest(principalNodeType));
                    }
                }
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " after axis name");
            }
        }
        this.grumble("Unexpected token " + this.currentTokenDisplay() + " in path expression");
        return null;
    }
}

