/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.config.StandardSchemaResolver;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.sdoc.SchemaDocument;
import com.saxonica.schema.sdoc.SchemaElement;
import com.saxonica.schema.sdoc.SchemaNodeFactory;
import com.saxonica.schema.sdoc.VersionControlFilter;
import com.saxonica.schema.sdoc.XSDSchema;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.AllElementStripper;
import net.sf.saxon.event.CommentStripper;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.type.SchemaException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public abstract class SchemaReader {
    private SchemaReader() {
    }

    public static Source getSource(String baseURI, String relativeURI, PipelineConfiguration pipe, String targetNamespace) throws SchemaException {
        try {
            String[] locations = new String[]{relativeURI};
            Source[] sources = pipe.getSchemaURIResolver().resolve(targetNamespace, baseURI, locations);
            if (sources == null) {
                StandardSchemaResolver r = new StandardSchemaResolver((EnterpriseConfiguration)pipe.getConfiguration());
                sources = r.resolve(targetNamespace, baseURI, locations);
            }
            if (sources.length == 0) {
                return null;
            }
            if (sources.length == 1) {
                return sources[0];
            }
            throw new UnsupportedOperationException("SchemaURIResolver is currently restricted to return one source for each schemaLocation");
        }
        catch (XPathException e) {
            throw new SchemaException(e);
        }
    }

    public static Source[] getSources(String baseURI, String[] relativeURIs, PipelineConfiguration pipe, String targetNamespace) throws SchemaException {
        try {
            Source[] sources = pipe.getSchemaURIResolver().resolve(targetNamespace, baseURI, relativeURIs);
            if (sources == null) {
                StandardSchemaResolver r = new StandardSchemaResolver((EnterpriseConfiguration)pipe.getConfiguration());
                sources = r.resolve(targetNamespace, baseURI, relativeURIs);
            }
            return sources;
        }
        catch (XPathException e) {
            throw new SchemaException(e);
        }
    }

    public static SchemaDocument read(Source source, SchemaCompiler compiler, PipelineConfiguration pipe, SchemaElement referrer) throws SchemaException {
        SchemaDocument schemaDocument;
        AxisIterator children;
        NodeInfo top;
        boolean tracing = pipe.getConfiguration().isTiming();
        if (tracing) {
            pipe.getConfiguration().getStandardErrorOutput().println("Loading schema document " + source.getSystemId());
        }
        if (!((top = (NodeInfo)(children = (schemaDocument = SchemaReader.processModule(source, compiler, pipe, referrer)).getDocument().iterateAxis((byte)3, NodeKindTest.makeNodeKindTest(1))).next()) instanceof XSDSchema)) {
            SchemaException err = new SchemaException("Outermost element of schema document must be xs:schema");
            ExpressionLocation loc = new ExpressionLocation();
            loc.setSystemId(source.getSystemId());
            loc.setLineNumber(top.getLineNumber());
            err.setLocator(loc);
            try {
                pipe.getErrorListener().fatalError(err);
            }
            catch (TransformerException e) {
                // empty catch block
            }
            throw err;
        }
        compiler.setPipelineConfiguration(pipe);
        compiler.setBeingRead(source.getSystemId());
        ((XSDSchema)top).processAllAttributes();
        ((XSDSchema)top).validateSubtree(compiler);
        compiler.markAsRead(source.getSystemId(), (XSDSchema)top);
        int errors = ((XSDSchema)top).getErrorCount();
        if (errors > 0) {
            String msg = errors == 1 ? "One error was" : errors + " errors were";
            throw new SchemaException(msg + " found while processing the schema");
        }
        if (tracing) {
            pipe.getConfiguration().getStandardErrorOutput().println("Finished loading schema document " + source.getSystemId());
        }
        return schemaDocument;
    }

    private static SchemaDocument processModule(Source source, SchemaCompiler compiler, PipelineConfiguration pipe, SchemaElement referrer) throws SchemaException {
        DocumentImpl doc;
        AllElementStripper stripper = new AllElementStripper();
        SchemaNodeFactory nodeFactory = new SchemaNodeFactory(compiler, pipe, referrer);
        LinkedTreeBuilder schemaBuilder = new LinkedTreeBuilder();
        schemaBuilder.setPipelineConfiguration(pipe);
        schemaBuilder.setSystemId(source.getSystemId());
        schemaBuilder.setNodeFactory(nodeFactory);
        schemaBuilder.setLineNumbering(true);
        stripper.setUnderlyingReceiver(schemaBuilder);
        StartTagBuffer startTagBuffer = new StartTagBuffer();
        startTagBuffer.setPipelineConfiguration(pipe);
        VersionControlFilter vcFilter = new VersionControlFilter(startTagBuffer, compiler);
        vcFilter.setPipelineConfiguration(pipe);
        vcFilter.setUnderlyingReceiver(stripper);
        startTagBuffer.setUnderlyingReceiver(vcFilter);
        CommentStripper commentStripper = new CommentStripper();
        commentStripper.setUnderlyingReceiver(startTagBuffer);
        CommentStripper out = commentStripper;
        if (source instanceof NodeInfo) {
            String base = ((NodeInfo)source).getBaseURI();
            if (!base.equals(source.getSystemId())) {
                schemaBuilder.setSystemId(base);
            }
            LocationCopier copier = new LocationCopier((NodeInfo)source instanceof DocumentInfo);
            pipe.setLocationProvider(copier);
            pipe.setCopyInformee(copier);
            schemaBuilder.setPipelineConfiguration(pipe);
        }
        Configuration config = pipe.getConfiguration();
        ParseOptions options = new ParseOptions();
        options.setSchemaValidationMode(3);
        try {
            out.setPipelineConfiguration(pipe);
            if (Configuration.getPlatform().isJava() && options.getXMLReader() == null && !(source instanceof NodeInfo) && !(source instanceof DOMSource)) {
                XMLReader parser = config.getStyleParser();
                options.setXMLReader(parser);
                if (options.getEntityResolver() != null) {
                    parser.setEntityResolver(options.getEntityResolver());
                }
                options.setDTDValidationMode(4);
                Sender.send(source, out, options);
                config.reuseStyleParser(parser);
            } else {
                Sender.send(source, out, options);
            }
            doc = (DocumentImpl)schemaBuilder.getCurrentRoot();
            schemaBuilder.reset();
        }
        catch (XPathException err) {
            Throwable cause = err.getException();
            if (cause != null) {
                if (cause instanceof SAXParseException) {
                    SAXParseException spe = (SAXParseException)cause;
                    if ((cause = spe.getException()) != null) {
                        if (cause instanceof SchemaException) {
                            throw (SchemaException)cause;
                        }
                        if (cause instanceof RuntimeException) {
                            cause.printStackTrace();
                        }
                        throw new SchemaException(cause);
                    }
                    throw new SchemaException("Failed to parse schema document");
                }
                if (cause instanceof TransformerConfigurationException) {
                    throw (SchemaException)cause;
                }
                throw new SchemaException(cause);
            }
            throw new SchemaException(err);
        }
        finally {
            if (options.isPleaseCloseAfterUse()) {
                ParseOptions.close(source);
            }
        }
        if (doc.getDocumentElement() == null) {
            throw new SchemaException("Schema document is empty or absent");
        }
        return new SchemaDocument(doc);
    }
}

