/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SingleNamespaceSchema;
import com.saxonica.schema.sdoc.SaxonPreprocess;
import com.saxonica.schema.sdoc.SchemaElement;
import com.saxonica.schema.sdoc.UnknownElement;
import com.saxonica.schema.sdoc.XSDAlternative;
import com.saxonica.schema.sdoc.XSDAnnotation;
import com.saxonica.schema.sdoc.XSDAny;
import com.saxonica.schema.sdoc.XSDAnyAttribute;
import com.saxonica.schema.sdoc.XSDAssert;
import com.saxonica.schema.sdoc.XSDAttribute;
import com.saxonica.schema.sdoc.XSDAttributeGroup;
import com.saxonica.schema.sdoc.XSDComplexContent;
import com.saxonica.schema.sdoc.XSDComplexContentRestriction;
import com.saxonica.schema.sdoc.XSDComplexType;
import com.saxonica.schema.sdoc.XSDCompositor;
import com.saxonica.schema.sdoc.XSDDefaultOpenContent;
import com.saxonica.schema.sdoc.XSDDocumentation;
import com.saxonica.schema.sdoc.XSDElement;
import com.saxonica.schema.sdoc.XSDExtension;
import com.saxonica.schema.sdoc.XSDFacet;
import com.saxonica.schema.sdoc.XSDFieldOrSelector;
import com.saxonica.schema.sdoc.XSDGroup;
import com.saxonica.schema.sdoc.XSDIdentityConstraint;
import com.saxonica.schema.sdoc.XSDImport;
import com.saxonica.schema.sdoc.XSDInclude;
import com.saxonica.schema.sdoc.XSDList;
import com.saxonica.schema.sdoc.XSDNotation;
import com.saxonica.schema.sdoc.XSDOpenContent;
import com.saxonica.schema.sdoc.XSDOverride;
import com.saxonica.schema.sdoc.XSDRedefine;
import com.saxonica.schema.sdoc.XSDSchema;
import com.saxonica.schema.sdoc.XSDSimpleContent;
import com.saxonica.schema.sdoc.XSDSimpleContentRestriction;
import com.saxonica.schema.sdoc.XSDSimpleType;
import com.saxonica.schema.sdoc.XSDSimpleTypeRestriction;
import com.saxonica.schema.sdoc.XSDUnion;
import java.util.HashMap;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.Err;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.NodeFactory;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.SchemaException;

public class SchemaNodeFactory
implements NodeFactory {
    private PipelineConfiguration pipe;
    private SchemaCompiler compiler;
    private EnterpriseConfiguration config;
    private HashMap<String, SchemaElement> idTable = new HashMap(32);
    private SchemaElement referrer;

    public SchemaNodeFactory(SchemaCompiler compiler, PipelineConfiguration pipe, SchemaElement referrer) {
        this.compiler = compiler;
        this.pipe = pipe;
        this.config = (EnterpriseConfiguration)pipe.getConfiguration();
        this.referrer = referrer;
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public SchemaCompiler getSchemaCompiler() {
        return this.compiler;
    }

    public ElementImpl makeElementNode(NodeInfo parent, int nameCode, int typeCode, AttributeCollectionImpl attlist, int[] namespaces, int namespacesUsed, PipelineConfiguration pipe, int locationId, int sequence) {
        String baseURI = null;
        int lineNumber = -1;
        int columnNumber = -1;
        LocationProvider locator = pipe.getLocationProvider();
        if (locator != null) {
            baseURI = locator.getSystemId(locationId);
            lineNumber = locator.getLineNumber(locationId);
            columnNumber = locator.getColumnNumber(locationId);
        }
        int f = nameCode & 0xFFFFF;
        SchemaElement e = this.makeXSDElement(f, parent.getFingerprint());
        e.setSchemaNodeFactory(this);
        e.setNamespaceDeclarations(namespaces, namespacesUsed);
        e.initialise(nameCode, typeCode, attlist, parent, sequence);
        e.setLocation(baseURI, lineNumber, columnNumber);
        return e;
    }

    private SchemaElement makeXSDElement(int f, int parent) {
        switch (f) {
            case 577: {
                return new XSDAlternative();
            }
            case 578: {
                return new XSDAnnotation();
            }
            case 582: {
                return new XSDAssert();
            }
            case 583: {
                return new XSDAssert();
            }
            case 584: {
                return new XSDAttribute();
            }
            case 576: {
                return new XSDCompositor();
            }
            case 579: {
                return new XSDAny();
            }
            case 580: {
                return new XSDAnyAttribute();
            }
            case 585: {
                return new XSDAttributeGroup();
            }
            case 586: {
                return new XSDCompositor();
            }
            case 587: {
                return new XSDComplexContent();
            }
            case 588: {
                return new XSDComplexType();
            }
            case 589: {
                return new XSDDefaultOpenContent();
            }
            case 591: {
                return new XSDElement();
            }
            case 593: {
                return new XSDExtension();
            }
            case 596: {
                return new XSDGroup();
            }
            case 597: {
                return new XSDImport();
            }
            case 598: {
                return new XSDInclude();
            }
            case 599: {
                return new XSDIdentityConstraint();
            }
            case 600: {
                return new XSDIdentityConstraint();
            }
            case 602: {
                return new XSDList();
            }
            case 611: {
                return new XSDNotation();
            }
            case 612: {
                return new XSDOpenContent();
            }
            case 613: {
                return new XSDOverride();
            }
            case 615: {
                return new XSDRedefine();
            }
            case 616: {
                if (parent == 621) {
                    return new XSDSimpleTypeRestriction();
                }
                if (parent == 620) {
                    return new XSDSimpleContentRestriction();
                }
                return new XSDComplexContentRestriction();
            }
            case 617: {
                XSDSchema s = new XSDSchema();
                SingleNamespaceSchema preparedSchema = new SingleNamespaceSchema(this.config, "");
                s.setSchema(preparedSchema);
                s.setSchemaCompiler(this.compiler);
                s.setReferrer(this.referrer);
                return s;
            }
            case 619: {
                return new XSDCompositor();
            }
            case 620: {
                return new XSDSimpleContent();
            }
            case 621: {
                return new XSDSimpleType();
            }
            case 625: {
                return new XSDIdentityConstraint();
            }
            case 624: {
                return new XSDUnion();
            }
            case 581: 
            case 590: {
                return new XSDDocumentation();
            }
            case 594: 
            case 618: {
                return new XSDFieldOrSelector();
            }
            case 531: 
            case 592: 
            case 595: 
            case 601: 
            case 603: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 608: 
            case 609: 
            case 610: 
            case 614: 
            case 622: 
            case 623: 
            case 626: {
                return new XSDFacet();
            }
            case 277: {
                return new SaxonPreprocess();
            }
        }
        return new UnknownElement();
    }

    public SchemaException registerId(String id, SchemaElement element) {
        if (!element.getConfiguration().getNameChecker().isValidNCName(id)) {
            return new SchemaException("Invalid id value " + Err.wrap(id));
        }
        SchemaElement e = this.idTable.get(id);
        if (e != null) {
            return new SchemaException("Non-unique id value " + Err.wrap(id));
        }
        this.idTable.put(id, element);
        return null;
    }
}

