/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema.fsa;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.Particle;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.Term;
import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.Wildcard;
import com.saxonica.schema.fsa.Edge;
import com.saxonica.schema.fsa.FiniteStateMachine;
import com.saxonica.schema.fsa.State;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutomatonState
implements State {
    int stateNumber;
    private Object specificTransitions = null;
    protected Edge[] wildcardEdges;
    private Edge maxTransition;
    private boolean isFinalState = false;
    private int min = -1;
    private int max = -1;
    public static final Edge[] EMPTY_EDGE_ARRAY = new Edge[0];

    public AutomatonState(FiniteStateMachine machine) {
        machine.allocateStateNumber(this);
    }

    @Override
    public boolean isFinalState() {
        return this.isFinalState && this.min < 1;
    }

    public boolean isConditionallyFinalState() {
        return this.isFinalState;
    }

    public void setFinalState(boolean finalState) {
        this.isFinalState = finalState;
    }

    public int getStateNumber() {
        return this.stateNumber;
    }

    public void addSpecificTransition(Edge edge, SchemaCompiler compiler) throws SchemaException {
        List<Edge> list;
        ElementDecl decl = (ElementDecl)edge.getTerm();
        int key = decl.getFingerprint();
        Edge existing = this.getSpecificTransition(key);
        if (existing != null) {
            if (existing.getTerm() == decl) {
                if (existing.getParticle() != null && edge.getParticle() != null && existing.getParticle() != edge.getParticle()) {
                    String two;
                    String message = "Ambiguous content model: element particle " + Err.wrap(decl.getDisplayName(), 1) + " appears in more than one place in the content model";
                    String one = this.termParticleMessage(decl, existing.getParticle());
                    if (!one.equals(two = this.termParticleMessage(decl, edge.getParticle()))) {
                        message = message + ", once " + one + ", and once " + two;
                    }
                    throw new SchemaException(message);
                }
            } else {
                throw new SchemaException("Ambiguous content model, element " + Err.wrap(decl.getDisplayName(), 1) + " appears more than once");
            }
        }
        if (this.wildcardEdges != null && compiler.getLanguageVersion() == 10) {
            String uri = decl.getTargetNamespace();
            for (int e = 0; e < this.wildcardEdges.length; ++e) {
                Edge wedge = this.wildcardEdges[e];
                if (!((Wildcard)wedge.getTerm()).matches(uri)) continue;
                throw new SchemaException("Ambiguous content model, element " + Err.wrap(decl.getDisplayName(), 1) + " appears in its own right, and also matches an <xs:any> wildcard");
            }
        }
        if (this.specificTransitions == null) {
            this.specificTransitions = edge;
        } else if (this.specificTransitions instanceof Edge) {
            list = new ArrayList<Object>(4);
            list.add((Edge)this.specificTransitions);
            list.add(edge);
            this.specificTransitions = list;
        } else if (this.specificTransitions instanceof List) {
            list = (List)this.specificTransitions;
            if (list.size() < 8) {
                list.add(edge);
            } else {
                IntHashMap<Edge> map = new IntHashMap<Edge>(8);
                for (int i = 0; i < list.size(); ++i) {
                    Edge existingEdge = (Edge)list.get(i);
                    ElementDecl elem = (ElementDecl)existingEdge.getTerm();
                    map.put(elem.getFingerprint(), existingEdge);
                }
                map.put(key, edge);
                this.specificTransitions = map;
            }
        } else {
            ((IntHashMap)this.specificTransitions).put(key, edge);
        }
    }

    private String termParticleMessage(ElementDecl term, Particle particle) {
        if (((ElementDecl)particle.getTerm()).getFingerprint() == term.getFingerprint()) {
            return "in its own right";
        }
        return "as a member of the substitution group of element " + Err.wrap(((ElementDecl)particle.getTerm()).getDisplayName(), 1);
    }

    public void addWildcardTransition(SchemaCompiler compiler, Edge transition) throws SchemaException {
        Edge other;
        Wildcard thiscard;
        if (this.wildcardEdges == null) {
            this.wildcardEdges = EMPTY_EDGE_ARRAY;
        } else {
            thiscard = (Wildcard)transition.getTerm();
            for (int e = 0; e < this.wildcardEdges.length; ++e) {
                other = this.wildcardEdges[e];
                if (!thiscard.overlaps((Wildcard)other.getTerm())) continue;
                throw new SchemaException("Ambiguous content model, there are two <xs:any> wildcards that match overlapping sets of namespaces");
            }
        }
        thiscard = (Wildcard)transition.getTerm();
        if (this.specificTransitions != null && compiler.getLanguageVersion() == 10) {
            Iterator iter2 = this.iterateSpecificTransitions();
            while (iter2.hasNext()) {
                other = (Edge)iter2.next();
                if (!thiscard.matches(((ElementDecl)other.getTerm()).getTargetNamespace())) continue;
                throw new SchemaException("Ambiguous content model, element " + Err.wrap(((ElementDecl)other.getTerm()).getDisplayName(), 1) + " appears in its own right, and also matches an <xs:any> wildcard");
            }
        }
        Edge[] w2 = new Edge[this.wildcardEdges.length + 1];
        System.arraycopy(this.wildcardEdges, 0, w2, 0, this.wildcardEdges.length);
        w2[w2.length - 1] = transition;
        this.wildcardEdges = w2;
    }

    public void setLimits(int min, int max) {
        this.min = min;
        this.max = max;
    }

    int getMinOccurs() {
        return this.min;
    }

    int getMaxOccurs() {
        return this.max;
    }

    public boolean requiresCounter() {
        return this.min != -1;
    }

    @Override
    public Edge getTransition(int token, UserComplexType type) {
        Edge sedge = this.getSpecificTransition(token);
        if (sedge != null) {
            return sedge;
        }
        EnterpriseConfiguration config = type.getConfiguration();
        if (this.wildcardEdges != null) {
            for (int i = 0; i < this.wildcardEdges.length; ++i) {
                Edge wedge = this.wildcardEdges[i];
                if (!((Wildcard)wedge.getTerm()).matches(token, true, config, type)) continue;
                return wedge;
            }
        }
        return null;
    }

    private Edge getSpecificTransition(int token) {
        if (this.specificTransitions != null) {
            if (this.specificTransitions instanceof Edge) {
                if (((ElementDecl)((Edge)this.specificTransitions).getTerm()).getFingerprint() == token) {
                    return (Edge)this.specificTransitions;
                }
            } else if (this.specificTransitions instanceof List) {
                List list = (List)this.specificTransitions;
                for (int i = 0; i < list.size(); ++i) {
                    if (((ElementDecl)((Edge)list.get(i)).getTerm()).getFingerprint() != token) continue;
                    return (Edge)list.get(i);
                }
            } else {
                Edge edge = (Edge)((IntHashMap)this.specificTransitions).get(token);
                if (edge != null) {
                    return edge;
                }
            }
        }
        return null;
    }

    Edge getEdge(Term t) {
        if (t instanceof ElementDecl && this.specificTransitions != null) {
            Edge e = this.getSpecificTransition(((ElementDecl)t).getFingerprint());
            if (e != null && e.getTerm() == t) {
                return e;
            }
            return null;
        }
        if (t instanceof Wildcard && this.wildcardEdges != null) {
            for (int e = 0; e < this.wildcardEdges.length; ++e) {
                if (this.wildcardEdges[e].getTerm() != t) continue;
                return this.wildcardEdges[e];
            }
        }
        return null;
    }

    void addEdge(SchemaCompiler compiler, Term t, Particle p, AutomatonState s) throws SchemaException {
        Edge e = new Edge();
        e.setTerm(t);
        e.setParticle(p);
        e.setTargetState(s);
        if (t instanceof ElementDecl) {
            this.addSpecificTransition(e, compiler);
        } else if (t instanceof Wildcard) {
            this.addWildcardTransition(compiler, e);
        } else if (t instanceof Edge.MaxOccursTerm) {
            this.setMaxTransition(e);
        } else {
            throw new IllegalArgumentException("Term must be an ElementDecl or Wildcard");
        }
    }

    @Override
    public CharSequence listAllowedElements() {
        ArrayList allowed = new ArrayList(10);
        this.getAllowedElements(allowed);
        if (allowed.isEmpty()) {
            return "No further elements are allowed at this position";
        }
        StringBuffer sb = new StringBuffer(allowed.size() * 30);
        sb.append("Expected");
        if (allowed.size() > 1) {
            sb.append(" one of");
        }
        sb.append(": ");
        Iterator iter = allowed.iterator();
        while (iter.hasNext()) {
            String s = (String)iter.next();
            sb.append(s);
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        return sb;
    }

    private void getAllowedElements(List list) {
        if (this.specificTransitions != null) {
            Iterator iter = this.iterateSpecificTransitions();
            while (iter.hasNext()) {
                Edge edge = (Edge)iter.next();
                ElementDecl decl = (ElementDecl)edge.getTerm();
                String name = decl.getConfiguration().getNamePool().getClarkName(decl.getFingerprint());
                list.add(name);
            }
        }
        if (this.wildcardEdges != null) {
            for (int e = 0; e < this.wildcardEdges.length; ++e) {
                Wildcard w = (Wildcard)this.wildcardEdges[e].getTerm();
                list.add(w.toString());
            }
        }
    }

    private Iterator iterateSpecificTransitions() {
        if (this.specificTransitions == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (this.specificTransitions instanceof Edge) {
            return new MonoIterator(this.specificTransitions);
        }
        if (this.specificTransitions instanceof List) {
            return ((List)this.specificTransitions).iterator();
        }
        return ((IntHashMap)this.specificTransitions).valueIterator();
    }

    @Override
    public Edge[] getWildcardEdges() {
        return this.wildcardEdges == null ? EMPTY_EDGE_ARRAY : this.wildcardEdges;
    }

    @Override
    public Iterator<Edge> getEdges() {
        if (this.specificTransitions == null) {
            if (this.wildcardEdges == null) {
                return Collections.EMPTY_LIST.iterator();
            }
            return Arrays.asList(this.wildcardEdges).iterator();
        }
        if (this.wildcardEdges == null) {
            return this.iterateSpecificTransitions();
        }
        return new EdgeIterator(this.iterateSpecificTransitions(), Arrays.asList(this.wildcardEdges).iterator());
    }

    public void display(HashMap map) {
        if (map.isEmpty()) {
            System.err.println("====== FINITE STATE MACHINE ======");
        }
        int key = map.size();
        map.put(this, key);
        Iterator<Edge> iter = this.getEdges();
        while (iter.hasNext()) {
            String symbol;
            Edge edge = iter.next();
            if (edge.getTerm() instanceof ElementDecl) {
                ElementDecl decl = (ElementDecl)edge.getTerm();
                symbol = decl.getConfiguration().getNamePool().getDisplayName(decl.getFingerprint());
            } else {
                Wildcard card = (Wildcard)edge.getTerm();
                symbol = card.toString();
            }
            AutomatonState target = edge.getTargetState();
            Integer endKey = (Integer)map.get(target);
            if (endKey == null) {
                endKey = map.size();
                System.err.println(key + " " + symbol + " -> " + endKey + AutomatonState.finalMarker(target));
                target.display(map);
                continue;
            }
            System.err.println(key + " " + symbol + " -> " + endKey + AutomatonState.finalMarker(target));
        }
    }

    private static String finalMarker(AutomatonState state) {
        String finalFlag = "";
        if (state.isFinalState()) {
            finalFlag = "(F)";
        } else if (state.isConditionallyFinalState()) {
            finalFlag = "(F?)";
        }
        return finalFlag;
    }

    public void displayState(PrintStream err) {
        err.println("State " + this.stateNumber + AutomatonState.finalMarker(this));
        this.displayLambdaTransitions();
        Iterator<Edge> iter = this.getEdges();
        while (iter.hasNext()) {
            String symbol;
            Edge edge = iter.next();
            if (edge.getTerm() instanceof ElementDecl) {
                ElementDecl decl = (ElementDecl)edge.getTerm();
                symbol = decl.getConfiguration().getNamePool().getDisplayName(decl.getFingerprint());
            } else {
                Wildcard card = (Wildcard)edge.getTerm();
                symbol = card.toString();
            }
            AutomatonState target = edge.getTargetState();
            String counting = this.requiresCounter() && target == this ? " (min=" + this.getMinOccurs() + ", max=" + this.getMaxOccurs() + ")" : "";
            err.println("    " + symbol + counting + " -> " + target.stateNumber + AutomatonState.finalMarker(target));
        }
        if (this.maxTransition != null) {
            AutomatonState target = this.maxTransition.getTargetState();
            err.println("    onMax -> " + target.getStateNumber() + AutomatonState.finalMarker(target));
        }
    }

    public void displayLambdaTransitions() {
    }

    public void setMaxTransition(Edge edge) {
        this.maxTransition = edge;
    }

    public Edge getMaxTransition() {
        return this.maxTransition;
    }

    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement("state");
        serializer.emitAttribute("nr", this.stateNumber + "");
        if (this.isFinalState) {
            serializer.emitAttribute("final", "true");
        }
        if (this.requiresCounter()) {
            serializer.emitAttribute("minOccurs", "" + this.getMinOccurs());
            serializer.emitAttribute("maxOccurs", this.getMaxOccurs() == -1 ? "unbounded" : "" + this.getMaxOccurs());
            if (this.maxTransition != null) {
                serializer.emitAttribute("afterMax", this.maxTransition.getTargetState().getStateNumber() + "");
            }
        }
        Iterator iter = this.iterateSpecificTransitions();
        while (iter.hasNext()) {
            Edge edge = (Edge)iter.next();
            edge.serialize(serializer);
        }
        if (this.wildcardEdges != null) {
            for (int i = 0; i < this.wildcardEdges.length; ++i) {
                Edge edge = this.wildcardEdges[i];
                edge.serialize(serializer);
            }
        }
        serializer.endElement();
    }

    private static class EdgeIterator
    implements Iterator {
        Iterator[] iter;
        int which;

        public EdgeIterator(Iterator specific, Iterator wild) {
            this.iter = new Iterator[]{specific, wild};
            this.which = 0;
        }

        public boolean hasNext() {
            do {
                if (this.iter[this.which].hasNext()) {
                    return true;
                }
                ++this.which;
            } while (this.which < this.iter.length);
            return false;
        }

        public Object next() {
            return this.iter[this.which].next();
        }

        public void remove() {
            throw new UnsupportedOperationException("remove() not supported on EdgeIterator");
        }
    }
}

