/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.Facet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.UserAtomicType;
import com.saxonica.schema.UserSimpleType;
import java.math.BigInteger;
import net.sf.saxon.Configuration;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;

public abstract class ValueRangeFacet
extends Facet {
    boolean isConverted = false;
    AtomicValue requiredValue;

    public String getValue() {
        return this.requiredValue.getStringValue();
    }

    public void setValue(String value) throws SchemaException {
        this.requiredValue = StringValue.makeStringValue(value);
    }

    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
        boolean OK;
        int primitive;
        if (!base.isAtomicType()) {
            throw new SchemaException("The " + this.getName() + " facet is not available on the non-atomic type " + base.getDescription());
        }
        if (base instanceof UserAtomicType) {
            primitive = ((UserAtomicType)base).getPrimitiveType();
        } else if (base instanceof BuiltInAtomicType) {
            primitive = ((BuiltInAtomicType)base).getPrimitiveType();
        } else {
            throw new IllegalStateException("Unknown atomic type representation: " + base.getClass());
        }
        boolean bl = OK = primitive == 533 || primitive == 517 || primitive == 516 || primitive == 515 || primitive == 532 || primitive == 518 || primitive == 521 || primitive == 519 || primitive == 520 || primitive == 523 || primitive == 522 || primitive == 526 || primitive == 524 || primitive == 525 || primitive == 634 || primitive == 633;
        if (!OK) {
            throw new SchemaException("The " + this.getName() + " facet is not allowed on the unordered type " + base.getDescription());
        }
        EnterpriseConfiguration config = type.getConfiguration();
        this.convertToTargetType(base, config);
        if (base instanceof UserSimpleType) {
            int relation;
            UserSimpleType ubase = (UserSimpleType)base;
            Facet baseFacet = ubase.getFacet(this.getClass());
            if (baseFacet != null && baseFacet.isFixed() && (relation = this.requiredValue.getSchemaComparable().compareTo(((ValueRangeFacet)baseFacet).requiredValue.getSchemaComparable())) != 0) {
                throw new SchemaException("The " + this.getName() + " facet is fixed in the base type and cannot be varied");
            }
            ValidationFailure err = ubase.checkAgainstFacets(this.requiredValue, null, ubase.getFacets());
            if (err != null) {
                if (this.getName().endsWith("Exclusive") && baseFacet != null) {
                    ((ValueRangeFacet)baseFacet).convertToTargetType(base, config);
                    int relation2 = this.requiredValue.getSchemaComparable().compareTo(((ValueRangeFacet)baseFacet).requiredValue.getSchemaComparable());
                    if (relation2 == 0) {
                        err = null;
                    }
                }
                if (err != null) {
                    throw new SchemaException("In a type derived by restriction, the " + this.getName() + " facet is not a valid value of the base type");
                }
            }
        } else {
            BuiltInAtomicType bbase = (BuiltInAtomicType)base;
            boolean ok = true;
            if (this.requiredValue instanceof Int64Value) {
                long v = ((Int64Value)this.requiredValue).longValue();
                ok = IntegerValue.checkRange(v, bbase);
            } else if (this.requiredValue instanceof BigIntegerValue) {
                BigInteger v = ((BigIntegerValue)this.requiredValue).asBigInteger();
                ok = IntegerValue.checkBigRange(v, bbase);
            }
            if (!ok) {
                throw new SchemaException("The value of the " + this.getName() + " facet is out of range for the base type");
            }
        }
    }

    protected void convertToTargetType(SimpleType base, Configuration config) throws SchemaException {
        if (!this.isConverted) {
            ItemType prim = ((AtomicType)base).getPrimitiveItemType();
            ConversionResult v = this.requiredValue.convert((AtomicType)prim, true, config.getConversionRules());
            if (v instanceof ValidationFailure) {
                String s = Err.wrap(this.requiredValue.getStringValue(), 4);
                throw new SchemaException("The value " + s + " of the " + this.getName() + " facet is not valid for the type " + base.getDescription() + ". " + ((ValidationFailure)v).getMessage());
            }
            this.requiredValue = (AtomicValue)v;
            this.isConverted = true;
        }
    }

    public boolean testAtomicValue(AtomicValue value) {
        if (!this.isConverted) {
            throw new AssertionError((Object)"Value used in facet has not been converted to required type");
        }
        Comparable supplied = value.getSchemaComparable();
        Comparable req = this.requiredValue.getSchemaComparable();
        if (supplied == null || req == null) {
            return false;
        }
        int c = supplied.compareTo(req);
        return c != Integer.MIN_VALUE && this.testComparisonOK(c);
    }

    protected abstract boolean testComparisonOK(int var1);
}

