/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.AllModelGroup;
import com.saxonica.schema.Assertion;
import com.saxonica.schema.AttributeDecl;
import com.saxonica.schema.AttributeGroupDecl;
import com.saxonica.schema.AttributeGroupReference;
import com.saxonica.schema.AttributeUse;
import com.saxonica.schema.AttributeWildcard;
import com.saxonica.schema.ChoiceModelGroup;
import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.ElementWildcard;
import com.saxonica.schema.IdentityConstraint;
import com.saxonica.schema.IdentityConstraintReference;
import com.saxonica.schema.Key;
import com.saxonica.schema.KeyRef;
import com.saxonica.schema.ModelGroup;
import com.saxonica.schema.ModelGroupParticle;
import com.saxonica.schema.Particle;
import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.SchemaStructure;
import com.saxonica.schema.SequenceModelGroup;
import com.saxonica.schema.SerializableSchemaComponent;
import com.saxonica.schema.TypeReference;
import com.saxonica.schema.Unique;
import com.saxonica.schema.UserDefinedType;
import com.saxonica.schema.UserSchemaComponent;
import com.saxonica.schema.UserSimpleType;
import com.saxonica.schema.Wildcard;
import com.saxonica.schema.fsa.AutomatonState;
import com.saxonica.schema.fsa.CountingState;
import com.saxonica.schema.fsa.Edge;
import com.saxonica.schema.fsa.FiniteStateMachine;
import com.saxonica.schema.fsa.NonDeterminizedState;
import com.saxonica.schema.fsa.State;
import com.saxonica.schema.fsa.SuffixState;
import com.saxonica.schema.sdoc.SimpleTypeDefinition;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.FixedAttribute;
import net.sf.saxon.expr.instruct.FixedElement;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.expr.sort.IntHashSet;
import net.sf.saxon.expr.sort.IntIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserComplexType
extends UserDefinedType
implements ComplexType,
UserSchemaComponent,
SerializableSchemaComponent {
    private boolean debug = false;
    private int variety;
    private boolean isAbstract = false;
    private boolean allContent = false;
    private AttributeGroupDecl attributes = null;
    private AttributeGroupDecl extendedAttributes = null;
    private int block = 0;
    private TypeReference simpleContentTypeRef = null;
    private Particle particle;
    private Particle extendedParticle = null;
    private boolean restricted = false;
    private FiniteStateMachine machine = new FiniteStateMachine(this, false);
    private boolean compiled = false;
    private Set assertions;
    private Wildcard openContentWildcard;
    private int openContentMode = 0;
    private boolean openContentAppliesToEmpty;
    private IntHashMap<SchemaType> contextDeterminedTypesForElements;
    private IntHashMap<SimpleType> contextDeterminedTypesForAttributes;
    private int xsdVersion = 10;

    public UserComplexType(EnterpriseConfiguration config, SourceLocator locator) {
        this.setConfiguration(config);
        this.setLocator(locator);
        this.attributes = new AttributeGroupDecl(config);
        this.attributes.setLocator(locator);
    }

    @Override
    public int getVariety() {
        return this.variety;
    }

    public void setSaxonDebug(boolean debug) {
        this.debug = debug;
    }

    public int getLanguageVersion() {
        return this.xsdVersion;
    }

    public void setFiniteStateMachine(FiniteStateMachine machine) {
        this.machine = machine;
    }

    public void addAttributeUse(AttributeUse use) {
        this.attributes.addAttributeUse(use);
    }

    public void setEmptyCombinedAttributeGroup() {
        this.extendedAttributes = new AttributeGroupDecl(this.getConfiguration());
    }

    public void addNonInheritedAttributeUse(AttributeUse use) {
        this.attributes.addAttributeUse(use);
        this.extendedAttributes.addAttributeUse(use);
    }

    public void addAttributeGroupReference(AttributeGroupReference attrGroupRef) {
        this.attributes.addAttributeGroupReference(attrGroupRef);
    }

    public AttributeGroupDecl getAttributeGroup() {
        return this.attributes;
    }

    public AttributeGroupDecl getCombinedAttributeGroup() {
        if (this.extendedAttributes == null) {
            throw new IllegalStateException("Extended attribute group has not been computed");
        }
        return this.extendedAttributes;
    }

    private boolean makeCombinedAttributeGroup(SchemaCompiler compiler) throws SchemaException {
        boolean result;
        if (this.extendedAttributes != null) {
            return true;
        }
        if (this.getDerivationMethod() == 2) {
            boolean result2;
            if (compiler != null && !(result2 = this.attributes.validate(compiler))) {
                return false;
            }
            SchemaType base = this.getBaseType();
            if (base == null) {
                this.extendedAttributes = this.attributes;
                return true;
            }
            if (base.isSimpleType()) {
                this.extendedAttributes = this.attributes;
                return true;
            }
            if (base instanceof UserComplexType) {
                result2 = ((UserComplexType)base).makeCombinedAttributeGroup(compiler);
                if (!result2) {
                    return false;
                }
                this.extendedAttributes = new AttributeGroupDecl(this.getConfiguration());
                this.extendedAttributes.setLocator(this);
                Iterator<AttributeUse> iter = this.getAttributeGroup().getAttributeUses();
                while (iter.hasNext()) {
                    AttributeUse att = iter.next();
                    this.extendedAttributes.addAttributeUse(att);
                }
                AttributeGroupDecl baseAtts = ((UserComplexType)base).getCombinedAttributeGroup();
                iter = baseAtts.getAttributeUses();
                while (iter.hasNext()) {
                    AttributeUse att = iter.next();
                    this.extendedAttributes.addAttributeUse(att);
                }
                AttributeWildcard baseWild = baseAtts.getAttributeWildcard(compiler);
                AttributeWildcard thisWild = this.attributes.getAttributeWildcard(compiler);
                if (baseWild != null) {
                    if (thisWild != null) {
                        Wildcard union = Wildcard.makeUnion(thisWild.getWildcard(), baseWild.getWildcard(), this.getNamePool());
                        AttributeWildcard newawc = union.isInexpressible() ? thisWild : new AttributeWildcard(union);
                        this.extendedAttributes.setAnyAttribute(newawc);
                    } else {
                        this.extendedAttributes.setAnyAttribute(baseWild);
                    }
                } else {
                    this.extendedAttributes.setAnyAttribute(thisWild);
                }
            } else {
                this.extendedAttributes = this.attributes;
            }
            return true;
        }
        if (compiler != null && !(result = this.attributes.validate(compiler))) {
            return false;
        }
        SchemaType base = this.getBaseType();
        if (base == null) {
            this.extendedAttributes = this.attributes;
            return true;
        }
        this.extendedAttributes = new AttributeGroupDecl(this.getConfiguration());
        this.extendedAttributes.setLocator(this);
        IntHashMap<AttributeUse> map = new IntHashMap<AttributeUse>(20);
        if (base instanceof UserComplexType) {
            AttributeUse att;
            ((UserComplexType)base).makeCombinedAttributeGroup(compiler);
            AttributeGroupDecl baseAtts = ((UserComplexType)base).getCombinedAttributeGroup();
            Iterator<AttributeUse> iter = baseAtts.getAttributeUses();
            while (iter.hasNext()) {
                att = iter.next();
                if (att.isProhibited()) continue;
                map.put(att.getFingerprint(), att);
            }
            iter = this.getAttributeGroup().getAttributeUses();
            while (iter.hasNext()) {
                att = iter.next();
                int key = att.getFingerprint();
                AttributeUse old = (AttributeUse)map.get(key);
                if (old != null) {
                    if (att.isProhibited()) {
                        map.remove(key);
                        continue;
                    }
                    map.put(key, att);
                    continue;
                }
                map.put(key, att);
            }
            Iterator iter2 = map.valueIterator();
            while (iter2.hasNext()) {
                this.extendedAttributes.addAttributeUse((AttributeUse)iter2.next());
            }
            AttributeWildcard wat = this.getAttributeGroup().getAttributeWildcard(compiler);
            if (wat != null) {
                this.extendedAttributes.setAnyAttribute(wat);
            }
        } else {
            this.extendedAttributes = this.attributes;
        }
        return true;
    }

    @Override
    public int getBlock() {
        return this.block;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isComplexContent() {
        return this.variety != 1;
    }

    @Override
    public boolean isSimpleContent() {
        return this.variety == 1;
    }

    @Override
    public boolean isAllContent() {
        return this.allContent;
    }

    public boolean computeIsAllContent() throws SchemaException {
        if (this.isSimpleContent()) {
            return false;
        }
        if (this.particle instanceof ModelGroupParticle && ((ModelGroupParticle)this.particle).getGroup().containsAll(true)) {
            this.allContent = true;
            return true;
        }
        if (this.particle == null && this.getDerivationMethod() == 2 && this.getBaseType() instanceof ComplexType && ((ComplexType)this.getBaseType()).isAllContent()) {
            this.allContent = true;
            return true;
        }
        this.allContent = false;
        return false;
    }

    public ModelGroupParticle getAllCompositor() {
        if (this.extendedParticle instanceof ModelGroupParticle) {
            ModelGroup group = ((ModelGroupParticle)this.extendedParticle).getGroup();
            if (group instanceof AllModelGroup) {
                return (ModelGroupParticle)this.extendedParticle;
            }
            if (group.containsAll(true)) {
                block6: {
                    Particle part;
                    ModelGroupParticle gpref = (ModelGroupParticle)this.extendedParticle;
                    do {
                        Iterator<Particle> iter;
                        if (!(iter = group.iterateParticles()).hasNext()) {
                            throw new IllegalStateException("Empty group");
                        }
                        part = iter.next();
                        if (!(part instanceof ModelGroupParticle)) break block6;
                        if (part != gpref) continue;
                        throw new IllegalStateException("Circular group");
                    } while (!((group = (gpref = (ModelGroupParticle)part).getGroup()) instanceof AllModelGroup));
                    return gpref;
                }
                throw new IllegalStateException("Failure finding xs:all model group");
            }
            return null;
        }
        if (this.extendedParticle == null && this.getDerivationMethod() == 2 && this.getBaseType() instanceof ComplexType && ((ComplexType)this.getBaseType()).isAllContent()) {
            return ((UserComplexType)this.getBaseType()).getAllCompositor();
        }
        return null;
    }

    public void setSimpleContentTypeReference(TypeReference ref) {
        this.simpleContentTypeRef = ref;
    }

    public TypeReference getSimpleContentTypeReference() {
        if (this.simpleContentTypeRef == null && this.isSimpleContent()) {
            SchemaType base = this.getBaseType();
            if (base.isSimpleType()) {
                this.simpleContentTypeRef = this.getBaseTypeReference();
            } else if (base instanceof UserComplexType) {
                this.simpleContentTypeRef = ((UserComplexType)base).getSimpleContentTypeReference();
            }
        }
        return this.simpleContentTypeRef;
    }

    @Override
    public SimpleType getSimpleContentType() {
        TypeReference ref = this.getSimpleContentTypeReference();
        if (ref == null) {
            return null;
        }
        SimpleType simpleContentType = (SimpleType)ref.getTarget();
        if (simpleContentType instanceof SimpleTypeDefinition) {
            simpleContentType = ((SimpleTypeDefinition)simpleContentType).getSimpleType();
        }
        return simpleContentType;
    }

    @Override
    public boolean isRestricted() {
        return this.restricted;
    }

    @Override
    public boolean isEmptyContent() {
        return this.variety == 0;
    }

    @Override
    public boolean isMixedContent() {
        return this.variety == 3;
    }

    @Override
    public boolean isSimpleType() {
        return false;
    }

    @Override
    public boolean isAtomicType() {
        return false;
    }

    @Override
    public boolean isIdType() {
        return this.isSimpleContent() && this.getSimpleContentType().isIdType();
    }

    @Override
    public boolean isIdRefType() {
        return this.isSimpleContent() && this.getSimpleContentType().isIdRefType();
    }

    public Wildcard getOpenContentWildcard() {
        return this.openContentWildcard;
    }

    public int getOpenContentMode() {
        return this.openContentMode;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setAnyAttribute(AttributeWildcard wildcard) {
        this.attributes.setAnyAttribute(wildcard);
    }

    public void setNonInheritedAnyAttribute(AttributeWildcard wildcard) {
        this.attributes.setAnyAttribute(wildcard);
        this.extendedAttributes.setAnyAttribute(wildcard);
    }

    public void setBlock(int block) {
        this.block = block;
    }

    public void setVariety(int variety) {
        this.variety = variety;
    }

    public void setRestriction(boolean restricted) {
        this.restricted = restricted;
    }

    public void setParticle(Particle particle) throws SchemaException {
        this.particle = particle;
    }

    public void setOpenContentWildcard(Wildcard wildcard, String mode, boolean appliesToEmpty) {
        this.openContentWildcard = wildcard;
        if ("interleave".equals(mode)) {
            this.openContentMode = 2;
        } else if ("suffix".equals(mode)) {
            this.openContentMode = 3;
        } else if ("none".equals(mode)) {
            this.openContentMode = 1;
        } else {
            throw new IllegalArgumentException("Invalid value of open content mode - " + mode);
        }
        this.openContentAppliesToEmpty = appliesToEmpty;
    }

    public void addAssertion(Assertion assertion) {
        if (this.assertions == null) {
            this.assertions = new HashSet(4);
        }
        this.assertions.add(assertion);
    }

    public boolean hasAssertions() {
        return this.assertions != null && !this.assertions.isEmpty();
    }

    public Iterator iterateAssertions() {
        if (this.assertions == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.assertions.iterator();
    }

    public Set getAssertions() {
        if (this.assertions == null) {
            return Collections.EMPTY_SET;
        }
        return this.assertions;
    }

    @Override
    public void lookForCycles(Stack references, SchemaCompiler compiler) throws SchemaException, UnresolvedReferenceException {
        SchemaType base;
        for (int i = 0; i < references.size(); ++i) {
            if (!((SchemaType)references.get(i)).isSameType(this)) continue;
            compiler.error("The definition of the complex type " + this.getDescription() + " is circular", this);
            throw new SchemaException("Circular definition found");
        }
        references.push(this);
        this.getBaseTypeReference().tryToResolve(compiler);
        if (this.getBaseTypeReference().isResolved() && (base = (SchemaType)this.getBaseTypeReference().getTarget()) instanceof UserSchemaComponent) {
            ((UserSchemaComponent)((Object)base)).lookForCycles(references, compiler);
        }
        references.pop();
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        if (this.getFixupStatus() == 0) {
            boolean ok;
            this.setFixupStatus(2);
            if (this.attributes != null && !(ok = this.attributes.fixup(compiler))) {
                this.setFixupStatus(4);
                return false;
            }
            if (this.simpleContentTypeRef != null) {
                boolean ok2;
                SchemaType type = (SchemaType)PreparedSchema.validateReference(this.simpleContentTypeRef, compiler);
                if (type == null) {
                    this.setFixupStatus(4);
                    return false;
                }
                if (type instanceof UserSchemaComponent && !(ok2 = ((UserSchemaComponent)((Object)type)).fixup(compiler))) {
                    this.setFixupStatus(4);
                    return false;
                }
            }
            if (this.getBaseTypeReference() != null) {
                SchemaType type = (SchemaType)PreparedSchema.validateReference(this.getBaseTypeReference(), compiler);
                if (type == null) {
                    this.setFixupStatus(4);
                    return false;
                }
                if (type instanceof UserSchemaComponent) {
                    ((UserSchemaComponent)((Object)type)).fixup(compiler);
                }
            }
            if (this.particle != null) {
                this.particle.fixup(compiler);
            }
        }
        this.setFixupStatus(3);
        return true;
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        SchemaType base;
        boolean result = true;
        if (this.getFixupStatus() == 4) {
            return false;
        }
        switch (this.getValidationStatus()) {
            case 3: 
            case 4: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        this.setValidationStatus(2);
        this.xsdVersion = compiler.getLanguageVersion();
        if (this.particle != null && !(result &= this.particle.validate(compiler))) {
            this.setValidationStatus(4);
            return false;
        }
        if (this.getBaseTypeReference() != null) {
            PreparedSchema.validateReference(this.getBaseTypeReference(), compiler);
            if (!this.getBaseTypeReference().isResolved()) {
                this.setValidationStatus(4);
                return false;
            }
        }
        if ((base = this.getBaseType()) instanceof UserComplexType) {
            this.lookForCycles(new Stack(), compiler);
            result &= ((UserComplexType)base).validate(compiler);
            Iterator iter = ((UserComplexType)base).iterateAssertions();
            while (iter.hasNext()) {
                Assertion a = (Assertion)iter.next();
                this.addAssertion(a);
            }
        }
        if (result & this.isSimpleContent()) {
            result &= this.validateSimpleContent(compiler, base);
        }
        if (result) {
            result &= this.makeCombinedAttributeGroup(compiler);
        }
        if (result) {
            result &= this.extendedAttributes.validate(compiler);
        }
        if (this.getDerivationMethod() == 2) {
            result &= this.validateExtension(compiler, base);
        }
        if (this.getDerivationMethod() == 1) {
            result &= this.validateRestriction(compiler, base);
        }
        this.allContent = this.computeIsAllContent();
        if (result) {
            this.compile(compiler);
        }
        this.setValidationStatus(result ? 3 : 4);
        return result;
    }

    private boolean validateSimpleContent(SchemaCompiler compiler, SchemaType base) throws SchemaException {
        SimpleType content;
        if (this.simpleContentTypeRef == null) {
            if (base.isSimpleType()) {
                this.simpleContentTypeRef = this.getBaseTypeReference();
            } else if (base.isComplexType() && ((ComplexType)base).isSimpleContent()) {
                this.simpleContentTypeRef = ((UserComplexType)base).getSimpleContentTypeReference();
            } else {
                String err = "The complex type " + this.getDescription();
                err = err + " has simple content but its base type has complex content";
                compiler.error(err, this);
                this.setValidationStatus(4);
                return false;
            }
        }
        if ((content = (SimpleType)PreparedSchema.validateReference(this.getSimpleContentTypeReference(), compiler)).isIdType()) {
            compiler.warning("A complex type with simple xs:ID content does not impose any uniqueness constraints", this);
        }
        if (content.isIdRefType()) {
            compiler.warning("A complex type with simple xs:IDREF content does not impose any referential constraints", this);
        }
        if (content instanceof SimpleTypeDefinition) {
            int fp = content.getFingerprint();
            SchemaType type = compiler.getPreparedSchema().getSchemaType(fp);
            if (type != null) {
                if (type.isSimpleType()) {
                    if (type instanceof SimpleTypeDefinition) {
                        type = ((SimpleTypeDefinition)type).getSimpleType();
                    }
                    this.getSimpleContentTypeReference().setTarget(type);
                } else {
                    String err = "The complex type " + this.getDescription();
                    err = err + " has simple content that references a complex type";
                    compiler.error(err, this);
                    this.setValidationStatus(4);
                    return false;
                }
            }
            if (this.getSimpleContentType() instanceof UserSimpleType) {
                return ((UserSimpleType)this.getSimpleContentType()).validate(compiler);
            }
        }
        return true;
    }

    private boolean validateExtension(SchemaCompiler compiler, SchemaType base) throws SchemaException {
        String err;
        EnterpriseConfiguration config = this.getConfiguration();
        if (config.isSealedNamespace(config.getNamePool().getURI(base.getNameCode()))) {
            String err2 = "It is not possible to extend type " + base.getDescription() + " because that type has already been used for validating instance documents" + " or for compiling queries or stylesheets";
            compiler.error(err2, this);
            this.setValidationStatus(4);
            return false;
        }
        if (!base.allowsDerivation(2)) {
            String err3 = "The complex type " + this.getDescription() + " is derived by extension, but the base type prohibits extension";
            compiler.error(err3, this);
            this.setValidationStatus(4);
            return false;
        }
        if (this.variety == 2 && this.isLocallyEmpty() && this.isEmptyContent(base)) {
            this.variety = 0;
            this.particle = null;
        }
        if (this.isComplexContent() && base.isSimpleType()) {
            String err4 = "The type " + this.getDescription() + " has complex content so it " + "cannot be based on the simple type " + base.getDescription();
            compiler.error(err4, this);
            this.setValidationStatus(4);
            return false;
        }
        if (compiler.getLanguageVersion() == 10) {
            if (UserComplexType.isAllParticle(this.particle) && !this.isEmptyContent(base)) {
                String err5 = "The type " + this.getDescription() + " is defined with xs:all so (in XSD 1.0) it " + "cannot be derived by extension from a non-empty type";
                compiler.error(err5, this);
                this.setValidationStatus(4);
                return false;
            }
            if (!this.isLocallyEmpty() && base instanceof UserComplexType && UserComplexType.isAllParticle(((UserComplexType)base).particle)) {
                String err6 = "In XSD 1.0, a type cannot be derived by extension from a type defined using xs:all unless the extension is empty";
                compiler.error(err6, this);
                this.setValidationStatus(4);
                return false;
            }
        } else {
            if (UserComplexType.isAllParticle(this.particle) && base instanceof UserComplexType) {
                if (UserComplexType.isAllParticle(((UserComplexType)base).particle)) {
                    AllModelGroup amg = (AllModelGroup)((ModelGroupParticle)((UserComplexType)base).particle).getGroup();
                    if (amg.getSimplifiedContentModel().isEmpty() && ((UserComplexType)base).isMixedContent()) {
                        String err7 = "The type " + this.getDescription() + " defined with xs:all cannot " + "be derived by extension from a base type that is defined using xs:all with mixed " + "content but no element content. This is because the base type " + "is treated as if the compositor were xs:sequence rather than xs:all";
                        compiler.error(err7, this);
                        this.setValidationStatus(4);
                        return false;
                    }
                    Particle p = this.makeExtendedParticle(compiler);
                    boolean b = p.validate(compiler);
                    if (!b) {
                        this.setValidationStatus(4);
                        return false;
                    }
                } else if (!((UserComplexType)base).isEmptyContent()) {
                    String err8 = "The type " + this.getDescription() + " is defined with xs:all so it " + "cannot be derived by extension unless the base type is empty or is itself defined with xs:all";
                    compiler.error(err8, this);
                    this.setValidationStatus(4);
                    return false;
                }
            }
            if (!this.isLocallyEmpty() && !UserComplexType.isAllParticle(this.particle) && base instanceof UserComplexType && UserComplexType.isAllParticle(((UserComplexType)base).particle)) {
                err = "A type cannot be derived by extension from a type defined using xs:all unless the extension is empty or the extension is itself defined using xs:all";
                compiler.error(err, this);
                this.setValidationStatus(4);
                return false;
            }
        }
        if (this.isComplexContent() && base instanceof UserComplexType && ((UserComplexType)base).isSimpleContent()) {
            if (this.isLocallyEmpty() && compiler.getLanguageVersion() == 10) {
                this.setVariety(1);
                this.setValidationStatus(0);
                return this.validate(compiler);
            }
            err = "The type " + this.getDescription() + " has complex content so it " + "cannot be derived by extension from the complex type " + base.getDescription() + " which has simple content";
            compiler.error(err, this);
            this.setValidationStatus(4);
            return false;
        }
        if (this.isSimpleContent() && !base.isSimpleType()) {
            if (base instanceof AnyType) {
                err = "The type " + this.getDescription() + " has simple content so it " + "cannot be derived by extension from xs:anyType";
                compiler.error(err, this);
                this.setValidationStatus(4);
                return false;
            }
            if (!((ComplexType)base).isSimpleContent()) {
                err = "The type " + this.getDescription() + " has simple content so it " + "cannot be derived by extension from the type " + base.getDescription() + " which has complex content";
                compiler.error(err, this);
                this.setValidationStatus(4);
                return false;
            }
        }
        if (base.isComplexType()) {
            SchemaType derived;
            SchemaType original;
            String err9;
            ComplexType cbase = (ComplexType)base;
            if (this.isMixedContent()) {
                if (!(base instanceof AnyType || cbase.isMixedContent() || cbase.isEmptyContent())) {
                    err9 = "The type " + this.getDescription() + " has mixed content, " + "so its base type must have mixed or empty content";
                    compiler.error(err9, this);
                    this.setValidationStatus(4);
                    return false;
                }
            } else if (this.particle != null) {
                if (base instanceof ComplexType && cbase.isMixedContent()) {
                    err9 = "The type " + this.getDescription() + " has element-only content, " + "so it cannot be derived by extension from a type with mixed content";
                    compiler.error(err9, this);
                    this.setValidationStatus(4);
                    return false;
                }
            } else if (this.isLocallyEmpty() && base instanceof ComplexType && cbase.isMixedContent()) {
                this.setVariety(3);
            }
            if (!this.openContentAppliesToEmpty && this.isLocallyEmpty()) {
                this.openContentWildcard = null;
            }
            if (base instanceof UserComplexType) {
                if (this.openContentWildcard == null && this.openContentMode != 1) {
                    this.openContentWildcard = ((UserComplexType)base).getOpenContentWildcard();
                    this.openContentMode = ((UserComplexType)base).getOpenContentMode();
                } else {
                    boolean baseOpenWildcardInterleaved;
                    Wildcard baseOpenWildcard = ((UserComplexType)base).getOpenContentWildcard();
                    boolean bl = baseOpenWildcardInterleaved = ((UserComplexType)base).getOpenContentMode() == 2;
                    if (baseOpenWildcard != null) {
                        if (this.openContentWildcard != null && baseOpenWildcardInterleaved && this.openContentMode != 2) {
                            String err10 = "Invalid extension. The type " + this.getDescription() + " has interleaved open content," + " but its base type has suffix open content";
                            compiler.error(err10, this);
                            this.setValidationStatus(4);
                            return false;
                        }
                        if (this.openContentWildcard == null) {
                            String err11 = "Invalid extension. The base type of type " + this.getDescription() + " allows open content, but this type does not";
                            compiler.error(err11, this);
                            this.setValidationStatus(4);
                            return false;
                        }
                    }
                }
            }
            Iterator<AttributeUse> ea = this.attributes.getAttributeUses();
            while (ea.hasNext()) {
                AttributeUse au = ea.next();
                int fp = au.getFingerprint();
                if (!(base instanceof UserComplexType)) continue;
                SchemaType b = base;
                while (b instanceof UserComplexType) {
                    AttributeUse baseAttributeUse;
                    int derivation = b.getDerivationMethod();
                    SchemaType g = b.getBaseType();
                    if (g != null && g instanceof UserComplexType && derivation == 1 && (baseAttributeUse = ((UserComplexType)g).getCombinedAttributeGroup().getAttributeUse(fp)) != null && (original = baseAttributeUse.getAttributeDeclaration().getType()) != null) {
                        derived = au.getAttributeDeclaration().getType();
                        try {
                            derived.checkTypeDerivationIsOK(original, 0);
                        }
                        catch (SchemaException se) {
                            String err12 = "The type " + this.getDescription() + " is derived by extension, and reintroduces" + " attribute " + compiler.getNamePool().getClarkName(fp) + " which was defined in the content model of the ancestor type " + g.getDescription() + " with an incompatible type. " + se.getMessage();
                            compiler.error(err12, this);
                            this.setValidationStatus(4);
                            return false;
                        }
                    }
                    b = g;
                }
            }
            if (this.particle != null) {
                IntHashSet extensionElements = new IntHashSet(10);
                this.particle.gatherAllPermittedElements(extensionElements, true);
                IntIterator ei = extensionElements.iterator();
                while (ei.hasNext()) {
                    int fp = ei.next();
                    if (!(base instanceof UserComplexType)) continue;
                    SchemaType b = base;
                    while (b instanceof UserComplexType) {
                        int derivation = b.getDerivationMethod();
                        SchemaType g = b.getBaseType();
                        if (g instanceof UserComplexType && derivation == 1 && (original = ((UserComplexType)g).getElementParticleType(fp, false)) != null) {
                            derived = this.particle.getElementParticleType(fp);
                            try {
                                derived.checkTypeDerivationIsOK(original, 0);
                            }
                            catch (SchemaException se) {
                                String err13 = "The type " + this.getDescription() + " is derived by extension, and reintroduces" + " element " + compiler.getNamePool().getClarkName(fp) + " which was defined in the content model of the ancestor type " + g.getDescription() + " with an incompatible type. " + se.getMessage();
                                compiler.error(err13, this);
                                this.setValidationStatus(4);
                                return false;
                            }
                        }
                        b = g;
                    }
                }
            }
        }
        SchemaType b = base;
        while (true) {
            if (b instanceof UserDefinedType) {
                if (b instanceof SimpleTypeDefinition) {
                    b = ((SimpleTypeDefinition)b).getSimpleType();
                }
                ((UserDefinedType)b).registerExtensionType(this);
                b = b.getBaseType();
                continue;
            }
            if (!(b instanceof SimpleType) || !((SimpleType)b).isBuiltInType()) break;
            compiler.getPreparedSchema().registerExtensionOfBuiltInType(b.getFingerprint(), this);
            b = b.getBaseType();
        }
        return true;
    }

    private boolean validateRestriction(SchemaCompiler compiler, SchemaType base) throws SchemaException {
        if (!base.allowsDerivation(1)) {
            String err = "The complex type " + this.getDescription() + " is derived by restriction, but the base type prohibits restriction";
            compiler.error(err, this);
            this.setValidationStatus(4);
            return false;
        }
        if (this.variety == 2 && (this.openContentWildcard == null || !this.openContentAppliesToEmpty) && this.isLocallyEmpty()) {
            this.variety = 0;
            this.particle = null;
        }
        if (base.isSimpleType()) {
            String err = "The complex type " + this.getDescription();
            err = err + " is defined as a restriction of the simple type ";
            err = err + base.getDescription();
            compiler.error(err, this);
            this.setValidationStatus(4);
            return false;
        }
        if (base.isComplexType()) {
            String err;
            ComplexType cbase = (ComplexType)base;
            boolean OK = false;
            if (this.isSimpleContent()) {
                if (cbase.isSimpleContent()) {
                    SimpleType thisContent = this.getSimpleContentType();
                    SimpleType baseContent = cbase.getSimpleContentType();
                    String reason = thisContent == null || baseContent == null ? "Cannot establish the simple content type" : UserSimpleType.isTypeDerivationOK(thisContent, baseContent, 0);
                    if (reason == null) {
                        OK = true;
                    } else {
                        String err2 = "The complex type " + this.getDescription() + " has simple content of a type that is not validly derived from that " + "of the base type. " + reason;
                        compiler.error(err2, this);
                        this.setValidationStatus(4);
                        return false;
                    }
                }
                if (!OK) {
                    if (!cbase.isMixedContent()) {
                        err = "The complex type " + this.getDescription();
                        err = err + " has simple content so its base type, if complex, must have mixed content";
                        compiler.error(err, this);
                        this.setValidationStatus(4);
                        return false;
                    }
                    if (!((ComplexType)base).isEmptiable()) {
                        err = "The complex type " + this.getDescription() + " has simple content so its base type, if complex, must allow empty content";
                        compiler.error(err, this);
                        this.setValidationStatus(4);
                        return false;
                    }
                    SchemaType simpleContentBase = this.getSimpleContentType().getBaseType();
                    if (simpleContentBase == null || simpleContentBase instanceof AnySimpleType) {
                        String err3 = "The complex type " + this.getDescription() + " has simple content and its base type is a mixed complex type," + " so it must specify a simpleType";
                        compiler.error(err3, this);
                        this.setValidationStatus(4);
                        return false;
                    }
                }
            } else if (cbase.isSimpleContent()) {
                String err4 = "The complex type " + this.getDescription() + " has complex content, but is derived by restriction from a base type that has simple content";
                compiler.error(err4, this);
                this.setValidationStatus(4);
                return false;
            }
            if (this.isMixedContent() && !((ComplexType)base).isMixedContent()) {
                err = "The complex type " + this.getDescription() + " has mixed content so its base type must also have mixed content";
                compiler.error(err, this);
                this.setValidationStatus(4);
                return false;
            }
            if (this.particle != null) {
                if (this.particle.isPointless(null)) {
                    ModelGroup group = ((ModelGroupParticle)this.particle).getGroup();
                    List<Particle> contentModel = group.getListOfParticles(true);
                    if (this.variety == 2 && contentModel.isEmpty() && (this.openContentWildcard == null || !this.openContentAppliesToEmpty)) {
                        this.particle = null;
                        this.variety = 0;
                    } else if (contentModel.size() == 1 && !(group instanceof AllModelGroup)) {
                        this.particle = contentModel.get(0);
                    }
                } else if (this.particle instanceof ModelGroupParticle && this.particle.getMinOccurs() == 1 && this.particle.getMaxOccurs() == 1) {
                    ((ModelGroupParticle)this.particle).getGroup().getSimplifiedContentModel();
                }
            }
            return this.isValidRestriction(base, compiler);
        }
        return true;
    }

    private static boolean isAllParticle(Particle particle) {
        return particle instanceof ModelGroupParticle && ((ModelGroupParticle)particle).getGroup() instanceof AllModelGroup;
    }

    private boolean isLocallyEmpty() {
        if (this.isSimpleContent()) {
            return false;
        }
        if (this.particle == null || this.particle.getMaxOccurs() == 0) {
            return true;
        }
        if (this.particle instanceof ModelGroupParticle) {
            ModelGroup group = ((ModelGroupParticle)this.particle).getGroup();
            return group.isEmpty() && (group instanceof AllModelGroup || group instanceof SequenceModelGroup || group instanceof ChoiceModelGroup && this.particle.getMinOccurs() == 0);
        }
        return false;
    }

    private boolean isEmptyContent(SchemaType type) {
        return type instanceof ComplexType && ((ComplexType)type).isEmptyContent();
    }

    public boolean isValidRestriction(SchemaType base, SchemaCompiler compiler) throws SchemaException {
        String subsumeError;
        if (base instanceof AnyType) {
            return true;
        }
        if (this == base) {
            return true;
        }
        if (this.getValidationStatus() == 4 || base.getValidationStatus() == 4) {
            return false;
        }
        ComplexType cbase = (ComplexType)base;
        this.makeCombinedAttributeGroup(compiler);
        if (cbase instanceof UserComplexType) {
            UserComplexType ucbase = (UserComplexType)cbase;
            ucbase.makeCombinedAttributeGroup(compiler);
            if (!ucbase.compiled) {
                ucbase.compile(compiler);
            }
        }
        if (cbase instanceof UserComplexType && !this.getCombinedAttributeGroup().isValidRestriction(((UserComplexType)cbase).getCombinedAttributeGroup(), compiler)) {
            compiler.error("The attributes of complex type " + this.getDescription() + " are not a restricted subset of the attributes of the type " + base.getDescription(), this);
            return false;
        }
        if (!this.compiled) {
            this.compile(compiler);
        }
        if ((subsumeError = this.isSubsumedBy(cbase, compiler)) != null) {
            if (subsumeError.startsWith("?")) {
                compiler.error("Saxon is unable to determine whether or not the content model of the complex type " + this.getDescription() + " is a valid restriction of the content model of the type " + base.getDescription() + ". " + subsumeError.substring(1), this);
            } else {
                compiler.error("The content model of the complex type " + this.getDescription() + " is not a valid restriction of the content model of the type " + base.getDescription() + ". " + subsumeError, this);
            }
            return false;
        }
        return true;
    }

    public void compile(SchemaCompiler compiler) throws SchemaException {
        if (this.compiled) {
            return;
        }
        if (this.debug) {
            PrintStream err = compiler.getConfiguration().getStandardErrorOutput();
            err.println("==== Compiling complex type " + this.getDescription());
            err.println("  simple content: " + this.isSimpleContent());
            err.println("  complex content: " + this.isComplexContent());
            err.println("  all content: " + this.isAllContent());
            err.println("  empty content: " + this.isEmptyContent());
            err.println("  emptiable: " + this.isEmptiable());
            err.println("  mixed content: " + this.isMixedContent());
            err.println("  base type: " + this.getBaseType().getDescription());
        }
        this.compiled = true;
        if (this.isSimpleContent() || this.isEmptyContent()) {
            this.machine.getInitialState().setFinalState(true);
        } else if (this.isAllContent()) {
            this.makeExtendedParticle(compiler);
        } else {
            Particle extended = this.makeExtendedParticle(compiler);
            if (extended == null) {
                this.machine.getInitialState().setFinalState(true);
                return;
            }
            NonDeterminizedState finalState = new NonDeterminizedState(this.machine);
            finalState.setFinalState(true);
            try {
                PrintStream err;
                NonDeterminizedState state = FiniteStateMachine.compileParticle(compiler, extended, finalState, this, this.machine);
                this.machine.setInitialState(state);
                if (this.debug) {
                    err = compiler.getConfiguration().getStandardErrorOutput();
                    err.println("==== NFSA for complex type " + this.getDescription());
                    this.machine.display(err);
                }
                this.machine = FiniteStateMachine.determinize(compiler, this.machine);
                if (this.debug) {
                    err = compiler.getConfiguration().getStandardErrorOutput();
                    err.println("==== DFSA for complex type " + this.getDescription());
                    this.machine.display(err);
                }
                this.machine.setOpenContentWildcard(this.openContentWildcard, this.openContentMode == 2);
            }
            catch (SchemaException err) {
                compiler.error("Error in complex type " + this.getDescription() + ": " + err.getMessage(), this);
                throw err;
            }
            if (this.particle != null) {
                this.particle.compile(compiler);
            }
        }
        this.makeCombinedAttributeGroup(compiler);
        this.makeContextDeterminedTypeMapForAttributes();
        this.makeContextDeterminedTypeMapForElements();
    }

    public void recompile(SchemaCompiler compiler) throws SchemaException {
        if (this.debug) {
            this.getConfiguration().getStandardErrorOutput().println("Recompiling type " + this.getDescription());
        }
        this.compiled = false;
        this.compile(compiler);
    }

    public void cancelValidation() {
        this.setValidationStatus(0);
        this.compiled = false;
    }

    public FiniteStateMachine getFiniteStateMachine() {
        return this.machine;
    }

    public State getInitialState() {
        AutomatonState as = this.machine.getInitialState();
        if (as.requiresCounter()) {
            return new CountingState(as, 0);
        }
        return as;
    }

    public Particle makeExtendedParticle(SchemaCompiler compiler) throws SchemaException {
        ModelGroup group;
        if (this.extendedParticle != null) {
            return this.extendedParticle;
        }
        if (compiler != null) {
            this.lookForCycles(new Stack(), compiler);
        }
        if (this.getDerivationMethod() == 2) {
            ComplexType cbase = (ComplexType)this.getBaseType();
            if (this.isAllContent() || cbase.isAllContent()) {
                if (cbase.isEmptyContent()) {
                    this.extendedParticle = this.particle;
                } else if (this.isLocallyEmpty()) {
                    this.extendedParticle = ((UserComplexType)cbase).getParticle();
                } else {
                    AllModelGroup all = new AllModelGroup();
                    all.setLocator(this);
                    ModelGroupParticle base = (ModelGroupParticle)((UserComplexType)cbase).makeExtendedParticle(compiler);
                    Iterator<Particle> i1 = base.getGroup().iterateParticles();
                    while (i1.hasNext()) {
                        ((ModelGroup)all).addParticle(i1.next());
                    }
                    Iterator<Particle> i2 = ((ModelGroupParticle)this.particle).getGroup().iterateParticles();
                    while (i2.hasNext()) {
                        ((ModelGroup)all).addParticle(i2.next());
                    }
                    ((SchemaStructure)all).elaborate(compiler);
                    ModelGroupParticle mgp = new ModelGroupParticle(this.getConfiguration(), this);
                    mgp.setTarget(all);
                    mgp.setLocator(this);
                    this.extendedParticle = mgp;
                    this.variety = this.variety == 3 ? 3 : 2;
                }
                return this.extendedParticle;
            }
            if (cbase instanceof UserComplexType) {
                SequenceModelGroup seq = new SequenceModelGroup();
                Particle base = ((UserComplexType)cbase).makeExtendedParticle(compiler);
                if (base != null) {
                    seq.addParticle(base);
                }
                if (this.particle != null) {
                    seq.addParticle(this.particle);
                }
                if (((ModelGroup)seq).isPointless(null)) {
                    List<Particle> contentModel = seq.getSimplifiedContentModel();
                    if (contentModel.isEmpty()) {
                        this.extendedParticle = null;
                        if (this.variety == 2) {
                            this.variety = 0;
                        }
                    } else if (contentModel.size() == 1) {
                        this.extendedParticle = contentModel.get(0);
                    } else {
                        ModelGroupParticle mgp = new ModelGroupParticle(this.getConfiguration(), this);
                        mgp.setTarget(seq);
                        this.extendedParticle = mgp;
                    }
                } else {
                    ModelGroupParticle mgp = new ModelGroupParticle(this.getConfiguration(), this);
                    mgp.setTarget(seq);
                    this.extendedParticle = mgp;
                }
                if (this.extendedParticle != null) {
                    this.extendedParticle.markVulnerableSubParticles();
                }
                return this.extendedParticle;
            }
            if (cbase instanceof AnyType) {
                if (this.isLocallyEmpty()) {
                    ElementWildcard any = new ElementWildcard(this.getConfiguration());
                    any.setMinOccurs(0);
                    any.setMaxOccurs(-1);
                    any.getWildcard().setProcessContents("lax");
                    this.extendedParticle = any;
                    return this.extendedParticle;
                }
                this.setValidationStatus(4);
                String err = "xs:anyType cannot be extended, because any non-empty extension creates an ambiguity";
                if (compiler == null) {
                    throw new IllegalStateException(err);
                }
                compiler.error(err, this);
                this.extendedParticle = this.particle;
                return this.particle;
            }
            throw new IllegalStateException("Unknown implementation of ComplexType: " + cbase.getClass());
        }
        if (this.particle == null) {
            this.extendedParticle = null;
            return this.extendedParticle;
        }
        Particle p = this.particle;
        if (p instanceof ModelGroupParticle && p.getMinOccurs() == 1 && p.getMaxOccurs() == 1 && (group = ((ModelGroupParticle)p).getGroup()).getSimplifiedContentModel().size() == 1 && !(group instanceof AllModelGroup)) {
            p = group.getSimplifiedContentModel().get(0);
        }
        if (p.isPointless(null) && p instanceof ModelGroupParticle) {
            List<Particle> contentModel = ((ModelGroupParticle)p).getGroup().getSimplifiedContentModel();
            if (this.variety == 2 && contentModel.isEmpty() && (this.openContentWildcard == null || !this.openContentAppliesToEmpty)) {
                this.extendedParticle = null;
                this.variety = 0;
            } else {
                this.extendedParticle = contentModel.size() == 1 ? contentModel.get(0) : p;
            }
        } else {
            this.extendedParticle = p;
        }
        if (this.extendedParticle != null) {
            this.extendedParticle.markVulnerableSubParticles();
        }
        return this.extendedParticle;
    }

    public Particle getParticle() {
        return this.extendedParticle;
    }

    @Override
    public boolean isEmptiable() {
        Particle p = this.getParticle();
        return p == null || p.isEmptiable();
    }

    @Override
    public SchemaType getElementParticleType(int fingerprint, boolean considerExtensions) {
        SchemaType child;
        Particle p = this.getParticle();
        SchemaType schemaType = child = p == null ? null : p.getElementParticleType(fingerprint);
        if (child != null) {
            return child;
        }
        if (considerExtensions) {
            if (this.openContentWildcard != null && this.openContentWildcard.matches(fingerprint, true, this.getConfiguration(), this)) {
                return AnyType.getInstance();
            }
            Iterator iter = this.iterateExtensionTypes();
            while (iter.hasNext()) {
                UserComplexType ext = (UserComplexType)iter.next();
                SchemaType st = ext.getElementParticleType(fingerprint, false);
                if (st == null) continue;
                if (child == null) {
                    child = st;
                    continue;
                }
                if (child == st) continue;
                return AnyType.getInstance();
            }
            return child;
        }
        return null;
    }

    @Override
    public int getElementParticleCardinality(int fingerprint, boolean considerExtensions) {
        Particle p = this.getParticle();
        int baseCardinality = p == null ? 8192 : p.getElementParticleCardinality(fingerprint);
        if (this.openContentWildcard != null && this.openContentWildcard.matches(fingerprint, true, this.getConfiguration(), this)) {
            return 57344;
        }
        if (considerExtensions) {
            Iterator iter = this.iterateExtensionTypes();
            while (iter.hasNext()) {
                if (baseCardinality == 57344) {
                    return baseCardinality;
                }
                UserComplexType ext = (UserComplexType)iter.next();
                int extCardinality = ext.getElementParticleCardinality(fingerprint, false);
                baseCardinality = Cardinality.union(baseCardinality, extCardinality);
            }
        }
        return baseCardinality;
    }

    @Override
    public SimpleType getAttributeUseType(int fingerprint) throws SchemaException {
        AttributeGroupDecl ag = this.getCombinedAttributeGroup();
        AttributeUse use = ag.getAttributeUse(fingerprint);
        if (use != null && !use.isProhibited()) {
            return ((AttributeDecl)use.getTarget()).getType();
        }
        SimpleType attType = null;
        Iterator iter = this.iterateExtensionTypes();
        while (iter.hasNext()) {
            UserComplexType ext = (UserComplexType)iter.next();
            SimpleType st = ext.getAttributeUseType(fingerprint);
            if (st == null) continue;
            if (attType == null) {
                attType = st;
                continue;
            }
            if (attType == st) continue;
            return AnySimpleType.getInstance();
        }
        if (attType != null) {
            return attType;
        }
        AttributeWildcard awild = ag.getAttributeWildcard(null);
        if (awild == null) {
            return null;
        }
        Wildcard wild = awild.getWildcard();
        if (wild.matches(fingerprint, false, this.getConfiguration(), null)) {
            if (wild.getProcessContents().equals("skip")) {
                return AnySimpleType.getInstance();
            }
            if (wild.getProcessContents().equals("strict")) {
                AttributeDecl decl = this.getConfiguration().getSuperSchema().getAttributeDecl(fingerprint);
                if (decl != null) {
                    return decl.getType();
                }
                return null;
            }
            AttributeDecl decl = this.getConfiguration().getSuperSchema().getAttributeDecl(fingerprint);
            if (decl != null) {
                return decl.getType();
            }
            return AnySimpleType.getInstance();
        }
        return null;
    }

    @Override
    public int getAttributeUseCardinality(int fingerprint) throws SchemaException {
        AttributeGroupDecl ag = this.getCombinedAttributeGroup();
        AttributeUse use = ag.getAttributeUse(fingerprint);
        if (use != null) {
            return use.getCardinality();
        }
        Object attType = null;
        Iterator iter = this.iterateExtensionTypes();
        while (iter.hasNext()) {
            UserComplexType ext = (UserComplexType)iter.next();
            int c = ext.getAttributeUseCardinality(fingerprint);
            if (c == 8192) continue;
            return c;
        }
        AttributeWildcard awild = ag.getAttributeWildcard(null);
        if (awild == null) {
            return 8192;
        }
        Wildcard wild = awild.getWildcard();
        if (wild.matches(fingerprint, false, this.getConfiguration(), null)) {
            return 24576;
        }
        return 8192;
    }

    @Override
    public boolean allowsAttributes() {
        AttributeGroupDecl ag = this.getCombinedAttributeGroup();
        if (ag.getAttributeUses().hasNext()) {
            return true;
        }
        if (ag.getAttributeWildcard(null) != null) {
            return true;
        }
        Iterator iter = this.iterateExtensionTypes();
        while (iter.hasNext()) {
            UserComplexType ext = (UserComplexType)iter.next();
            if (!ext.allowsAttributes()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsElementWildcard() {
        if (this.extendedParticle.containsElementWildcard()) {
            return true;
        }
        Iterator iter = this.iterateExtensionTypes();
        while (iter.hasNext()) {
            UserComplexType ext = (UserComplexType)iter.next();
            if (!ext.containsElementWildcard()) continue;
            return true;
        }
        return false;
    }

    public void makeContextDeterminedTypeMapForElements() throws SchemaException {
        if (this.contextDeterminedTypesForElements != null) {
            return;
        }
        this.contextDeterminedTypesForElements = new IntHashMap();
        this.gatherContextDeterminedTypesForElements(this.contextDeterminedTypesForElements);
    }

    private void gatherContextDeterminedTypesForElements(IntHashMap<SchemaType> map) throws SchemaException {
        Particle p;
        SchemaType base = this.getBaseType();
        if (base instanceof UserComplexType) {
            ((UserComplexType)base).gatherContextDeterminedTypesForElements(map);
        }
        if ((p = this.getParticle()) != null) {
            IntHashSet children = new IntHashSet();
            p.gatherAllPermittedElements(children, true);
            IntIterator it = children.iterator();
            while (it.hasNext()) {
                int fp = it.next();
                SchemaType type = this.getElementParticleType(fp, false);
                map.put(fp, type);
            }
        }
    }

    public SchemaType getContextDeterminedTypeForElement(int fp) {
        if (this.contextDeterminedTypesForElements == null) {
            return null;
        }
        return this.contextDeterminedTypesForElements.get(fp);
    }

    public void makeContextDeterminedTypeMapForAttributes() throws SchemaException {
        if (this.contextDeterminedTypesForAttributes != null) {
            return;
        }
        this.contextDeterminedTypesForAttributes = new IntHashMap();
        this.gatherContextDeterminedTypesForAttributes(this.contextDeterminedTypesForAttributes);
    }

    private void gatherContextDeterminedTypesForAttributes(IntHashMap<SimpleType> map) throws SchemaException {
        SchemaType base = this.getBaseType();
        if (base instanceof UserComplexType) {
            ((UserComplexType)base).gatherContextDeterminedTypesForAttributes(map);
        }
        Iterator<AttributeUse> it = this.getAttributeGroup().getAttributeUses();
        while (it.hasNext()) {
            AttributeUse use = it.next();
            if (use.isProhibited()) continue;
            int fp = use.getFingerprint();
            SimpleType type = this.getAttributeUseType(fp);
            map.put(fp, type);
        }
    }

    public SimpleType getContextDeterminedTypeForAttribute(int fp) {
        if (this.contextDeterminedTypesForAttributes == null) {
            return null;
        }
        return this.contextDeterminedTypesForAttributes.get(fp);
    }

    @Override
    public void gatherAllPermittedChildren(IntHashSet children, boolean ignoreWildcards) throws SchemaException {
        Particle p = this.getParticle();
        if (p == null) {
            return;
        }
        p.gatherAllPermittedElements(children, ignoreWildcards);
        if (this.extendedTypes != null) {
            for (UserComplexType uct : this.extendedTypes) {
                uct.gatherAllPermittedChildren(children, ignoreWildcards);
            }
        }
    }

    @Override
    public void gatherAllPermittedDescendants(IntHashSet descendants) throws SchemaException {
        Particle p = this.getParticle();
        if (p == null) {
            return;
        }
        IntHashSet permittedChildren = new IntHashSet(16);
        this.gatherAllPermittedChildren(permittedChildren, false);
        if (permittedChildren.contains(-1)) {
            descendants.add(-1);
            return;
        }
        IntIterator child = permittedChildren.iterator();
        while (child.hasNext()) {
            int c = child.next();
            if (!descendants.add(c)) continue;
            SchemaType childType = this.getElementParticleType(c, true);
            if (childType == null) {
                throw new AssertionError((Object)("Child particle " + c + " not found"));
            }
            if (!(childType instanceof ComplexType)) continue;
            if (childType instanceof UserComplexType) {
                ((UserComplexType)childType).gatherAllPermittedDescendants(descendants);
                continue;
            }
            descendants.add(-1);
            return;
        }
    }

    @Override
    public SchemaType getDescendantElementType(int fingerprint) throws SchemaException {
        Iterator iter;
        HashSet<SchemaType> parentsConsidered = new HashSet<SchemaType>();
        HashSet<SchemaType> foundTypes = new HashSet<SchemaType>();
        this.getDescendantElementTypes(fingerprint, parentsConsidered, foundTypes);
        if (foundTypes.isEmpty()) {
            return null;
        }
        if (foundTypes.size() == 1 && (iter = foundTypes.iterator()).hasNext()) {
            return (SchemaType)iter.next();
        }
        return AnyType.getInstance();
    }

    private void getDescendantElementTypes(int fingerprint, Set<SchemaType> parentsConsidered, Set<SchemaType> foundTypes) throws SchemaException {
        Particle p = this.getParticle();
        if (p == null) {
            return;
        }
        SchemaType targetType = this.getElementParticleType(fingerprint, true);
        if (targetType != null) {
            foundTypes.add(targetType);
            if (targetType == AnyType.getInstance()) {
                return;
            }
        }
        IntHashSet permittedChildren = new IntHashSet(16);
        this.gatherAllPermittedChildren(permittedChildren, false);
        if (permittedChildren.contains(-1)) {
            foundTypes.add(AnyType.getInstance());
            return;
        }
        IntIterator child = permittedChildren.iterator();
        while (child.hasNext()) {
            int c = child.next();
            SchemaType childType = this.getElementParticleType(c, true);
            if (childType == null) {
                throw new AssertionError((Object)("Child particle " + c + " not found"));
            }
            if (parentsConsidered.contains(childType)) continue;
            parentsConsidered.add(childType);
            if (!(childType instanceof ComplexType)) continue;
            if (childType instanceof UserComplexType) {
                ((UserComplexType)childType).getDescendantElementTypes(fingerprint, parentsConsidered, foundTypes);
                continue;
            }
            foundTypes.add(childType);
        }
    }

    @Override
    public int getDescendantElementCardinality(int fingerprint) throws SchemaException {
        int cardinality = 8192;
        IntHashSet children = new IntHashSet();
        this.gatherAllPermittedChildren(children, false);
        IntIterator kids = children.iterator();
        while (kids.hasNext()) {
            int child = kids.next();
            int childCard = this.getElementParticleCardinality(child, true);
            if (child == fingerprint && (cardinality = Cardinality.sum(cardinality, childCard)) == 57344) {
                return cardinality;
            }
            SchemaType childType = this.getElementParticleType(child, true);
            if (!childType.isComplexType()) continue;
            IntHashSet childDescendants = new IntHashSet();
            ((ComplexType)childType).gatherAllPermittedDescendants(childDescendants);
            if (!childDescendants.contains(fingerprint) || (cardinality = Cardinality.sum(cardinality, Cardinality.multiply(childCard, ((ComplexType)childType).getDescendantElementCardinality(fingerprint)))) != 57344) continue;
            return cardinality;
        }
        return cardinality;
    }

    public String isSubsumedBy(ComplexType base, SchemaCompiler compiler) throws SchemaException {
        if (base instanceof AnyType) {
            return null;
        }
        if (base instanceof Untyped) {
            return "Untyped does not subsume any other type";
        }
        UserComplexType cbase = (UserComplexType)base;
        Wildcard bw = cbase.getOpenContentWildcard();
        Wildcard rw = this.getOpenContentWildcard();
        if (bw == null) {
            if (rw != null) {
                Particle bp = cbase.getParticle();
                if (bp instanceof ElementWildcard && bp.getMinOccurs() == 0 && bp.getMaxOccurs() == -1 && (this.isEmptyContent() || ((ModelGroup)this.getParticle().getTarget()).getContentModelSize() == 0) && rw.isSubset(((ElementWildcard)bp).getWildcard(), this.getNamePool())) {
                    return null;
                }
                return "Restricted type has open content; base type does not";
            }
        } else if (rw != null) {
            if (!rw.isSubset(bw, compiler.getNamePool())) {
                return "Restricted type has an open content wildcard that matches names which are not matched by the open content of the base type";
            }
            if (bw.compareStrength(rw) > 0) {
                return "The processContents on the open content wildcard of the restricted type is weaker than that on the open content wildcard of the base type";
            }
            if (!this.isLocallyEmpty()) {
                boolean rInterleaved;
                boolean bInterleaved = cbase.getOpenContentMode() == 2;
                boolean bl = rInterleaved = this.getOpenContentMode() == 2;
                if (rInterleaved && !bInterleaved) {
                    return "Restricted type allows interleaved open content, but base type only allows suffixed open content";
                }
            }
        }
        return cbase.subsumes(this, compiler);
    }

    private String subsumes(UserComplexType sub, SchemaCompiler compiler) throws SchemaException {
        this.computeIsAllContent();
        if (!sub.getAssertions().containsAll(this.getAssertions())) {
            return "The assertions defined on complex type " + this.getDescription() + " are not a subset of the assertions defined on the type " + sub.getDescription();
        }
        sub.computeIsAllContent();
        if (this.isAllContent()) {
            return AllModelGroup.allSubsumes(this, sub, compiler);
        }
        if (sub.isAllContent()) {
            return this.subsumesAll(sub, compiler);
        }
        if (sub.isEmptyContent()) {
            if (this.isEmptiable()) {
                return null;
            }
            return "Derived type has empty content model, but base type does not allow empty content";
        }
        return FiniteStateMachine.subsumesMachine(this.machine, sub.machine, compiler);
    }

    protected static String elementParticleMatches(ElementDecl base, ElementDecl sub, SchemaCompiler compiler) {
        SchemaType baseType = base.getType();
        SchemaType subType = sub.getType();
        if (sub.isNillable() && !base.isNillable()) {
            return "Element " + UserComplexType.eName(sub) + " in derived type is nillable but element " + UserComplexType.eName(base) + " in base type is not";
        }
        if (base.getFixedValue() != null) {
            if (sub.getFixedValue() == null) {
                return "Element " + UserComplexType.eName(base) + " in base type has a fixed value, but element " + UserComplexType.eName(sub) + " in derived type does not";
            }
            if (!sub.getFixedValue().getSchemaComparable().equals(base.getFixedValue().getSchemaComparable())) {
                return "Element " + UserComplexType.eName(sub) + " in derived type has a different fixed value from element " + UserComplexType.eName(base) + " in base type";
            }
        }
        boolean elementTypeOK = true;
        String reason = null;
        if (subType.isSimpleType()) {
            reason = UserSimpleType.isTypeDerivationOK((SimpleType)subType, baseType, 0);
            elementTypeOK = reason == null;
        } else {
            while (!baseType.isSameType(subType)) {
                if (subType.getDerivationMethod() != 1) {
                    elementTypeOK = false;
                    break;
                }
                if ((subType = subType.getBaseType()) != null) continue;
                elementTypeOK = false;
                break;
            }
        }
        if (!elementTypeOK) {
            return "Type of element " + UserComplexType.eName(sub) + " in restricted content model is not validly derived from the " + "type of the corresponding element " + UserComplexType.eName(sub) + " in base content model" + (reason == null ? "" : ". " + reason);
        }
        if (base.getFixedValue() != null && !base.getFixedValue().getSchemaComparable().equals(sub.getFixedValue().getSchemaComparable())) {
            return "Fixed value of element " + UserComplexType.eName(sub) + " in base content model is not reflected in the corresponding " + "element " + UserComplexType.eName(sub) + " of the restricted content model";
        }
        HashSet<IdentityConstraint> baseUniqueSet = new HashSet<IdentityConstraint>(4);
        HashSet<IdentityConstraint> baseKeySet = new HashSet<IdentityConstraint>(4);
        HashSet<IdentityConstraint> baseKeyRefSet = new HashSet<IdentityConstraint>(4);
        Iterator<IdentityConstraintReference> baseConstraints = base.getIdentityConstraints();
        while (baseConstraints.hasNext()) {
            IdentityConstraint ic = (IdentityConstraint)((Object)baseConstraints.next());
            if (ic instanceof Unique) {
                baseUniqueSet.add(ic);
                continue;
            }
            if (ic instanceof Key) {
                baseKeySet.add(ic);
                continue;
            }
            if (!(ic instanceof KeyRef)) continue;
            baseKeyRefSet.add(ic);
        }
        HashSet<IdentityConstraint> subUniqueSet = new HashSet<IdentityConstraint>(4);
        HashSet<IdentityConstraint> subKeySet = new HashSet<IdentityConstraint>(4);
        HashSet<IdentityConstraint> subKeyRefSet = new HashSet<IdentityConstraint>(4);
        Iterator<IdentityConstraintReference> subConstraints = sub.getIdentityConstraints();
        while (subConstraints.hasNext()) {
            IdentityConstraint ic = (IdentityConstraint)((Object)subConstraints.next());
            if (ic instanceof Unique) {
                subUniqueSet.add(ic);
                continue;
            }
            if (ic instanceof Key) {
                subKeySet.add(ic);
                continue;
            }
            if (!(ic instanceof KeyRef)) continue;
            subKeyRefSet.add(ic);
        }
        if (baseUniqueSet.size() > subUniqueSet.size()) {
            return "Element " + UserComplexType.eName(base) + "in the base type has an xs:unique constraint that " + "is not present in the restricted type";
        }
        if (baseKeySet.size() > subKeySet.size()) {
            return "Element " + UserComplexType.eName(sub) + " in the base type has an xs:key constraint that is not present " + "in the restricted type";
        }
        if (baseKeyRefSet.size() > subKeyRefSet.size()) {
            return "Element " + UserComplexType.eName(sub) + " in the base type has an xs:keyref constraint that is not present " + "in the restricted type";
        }
        if (baseUniqueSet.size() + baseKeySet.size() + baseKeyRefSet.size() > 0) {
            compiler.warning("Saxon is not able to verify that the identity constraints in element " + UserComplexType.eName(sub) + " are compatible with those in the the base type", sub);
        }
        if ((base.getBlock() & ~sub.getBlock()) != 0) {
            return "Disallowed substitutions of element " + UserComplexType.eName(sub) + "in restricted content model (@block) must be " + "a superset of those in the base content model";
        }
        return null;
    }

    private static String eName(ElementDecl e) {
        return Err.wrap(e.getDisplayName(), 1);
    }

    public String subsumesAll(UserComplexType sub, SchemaCompiler compiler) throws SchemaException {
        AllModelGroup subAll = (AllModelGroup)sub.getAllCompositor().getGroup();
        Particle base = this.makeExtendedParticle(compiler);
        EnterpriseConfiguration config = this.getConfiguration();
        if (base instanceof ElementWildcard) {
            int min = 0;
            int max = 0;
            Iterator<Particle> iter = subAll.iterateParticles();
            while (iter.hasNext()) {
                Particle p = iter.next();
                min += p.getMinOccurs();
                max += p.getMaxOccurs();
                if (((ElementWildcard)base).getWildcard().matches(p.getFingerprint(), true, config, this)) continue;
                String uri = compiler.getNamePool().getURI(p.getFingerprint());
                return "The base type does not allow elements in " + ("".equals(uri) ? "no namespace" : "namespace " + uri);
            }
            if (min < base.getMinOccurs()) {
                return "The derived type allows fewer elements to appear than the base type requires in its minOccurs";
            }
            if (base.getMaxOccurs() >= 0 && max > base.getMaxOccurs()) {
                return "The derived type allows more elements to appear than the base type permits in its maxOccurs";
            }
            return null;
        }
        return "A type using xs:all cannot be validly derived from this base type";
    }

    @Override
    public void analyzeContentExpression(Expression expression, int kind, StaticContext env) throws XPathException {
        Configuration config = env.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        Iterator<AttributeUse> iter = this.getAttributeGroup().getAttributeUses();
        while (iter.hasNext()) {
            AttributeUse use = iter.next();
            if (!use.isRequired()) continue;
            if (th.relationship(expression.getItemType(th), NodeKindTest.ATTRIBUTE) == 4) {
                XPathException err = new XPathException("Type " + this.getDescription() + " defines a mandatory attribute " + config.getNamePool().getDisplayName(use.getFingerprint()) + ", but there is no instruction to create such an attribute");
                err.setLocator(expression);
                err.setIsStaticError(true);
                throw err;
            }
            if (!(expression instanceof Block)) continue;
            Expression[] children = ((Block)expression).getChildren();
            boolean foundPossible = false;
            if (children != null) {
                for (int c = 0; c < children.length; ++c) {
                    if (children[c] instanceof FixedAttribute) {
                        if ((((FixedAttribute)children[c]).getAttributeNameCode() & 0xFFFFF) != use.getFingerprint()) continue;
                        foundPossible = true;
                        break;
                    }
                    if (th.relationship(children[c].getItemType(th), NodeKindTest.ATTRIBUTE) == 4) continue;
                    foundPossible = true;
                    break;
                }
            }
            if (foundPossible) continue;
            XPathException err = new XPathException("Type " + this.getDescription() + " defines a mandatory attribute " + config.getNamePool().getDisplayName(use.getFingerprint()) + ", but there is no instruction to create such an attribute");
            err.setLocator(expression);
            err.setIsStaticError(true);
            throw err;
        }
        if (expression instanceof Block) {
            Expression[] children = ((Block)expression).getChildren();
            if (children == null) {
                return;
            }
            for (int c = 0; c < children.length; ++c) {
                children[c].checkPermittedContents(this, env, false);
            }
            if (this.getFiniteStateMachine() != null && !this.isAllContent()) {
                State state = this.getInitialState();
                for (int c = 0; c < children.length; ++c) {
                    if (children[c] instanceof FixedElement) {
                        int fingerprint = ((FixedElement)children[c]).getNameCode(null, null) & 0xFFFFF;
                        Edge edge = state.getTransition(fingerprint, this);
                        if (edge == null) {
                            FiniteStateMachine machine = this.getFiniteStateMachine();
                            Wildcard openContentWildcard = machine.getOpenContentWildcard();
                            if (openContentWildcard != null && openContentWildcard.matches(fingerprint, true, this.getConfiguration(), this)) {
                                if (machine.isOpenContentInterleaved()) continue;
                                if (state.isFinalState()) {
                                    state = SuffixState.getInstance();
                                    continue;
                                }
                            }
                            if (state.isFinalState() && this.iterateExtensionTypes().hasNext()) break;
                            CharSequence sb = state.listAllowedElements();
                            String message = state instanceof SuffixState ? "The content model does not allow element " + Err.wrap(this.getNamePool().getDisplayName(fingerprint), 1) + " to appear after an element that matches the suffix open content wildcard. " : "The content model does not allow element " + Err.wrap(this.getNamePool().getDisplayName(fingerprint), 1) + " to appear here" + (openContentWildcard == null ? "" : " (it does not match the open content wildcard)") + ". " + ((Object)sb).toString();
                            XPathException ve = new XPathException(message);
                            ve.setErrorCode("XPTY0004");
                            ve.setLocator(children[c]);
                            throw ve;
                        }
                        try {
                            state = edge.makeTransition(state);
                            continue;
                        }
                        catch (ValidationException e) {
                            XPathException ve = new XPathException(e.getMessage());
                            ve.setErrorCode("XPTY0004");
                            ve.setLocator(expression);
                            throw ve;
                        }
                    }
                    ItemType t = children[c].getItemType(th);
                    if (th.relationship(t, NodeKindTest.ELEMENT) == 4) continue;
                    return;
                }
                if (!state.isFinalState()) {
                    int len = children.length;
                    if (len == 0) {
                        XPathException ve = new XPathException("The generated content is empty: the schema requires at least one child element");
                        ve.setErrorCode("XPTY0004");
                        ve.setLocator(expression);
                        throw ve;
                    }
                    XPathException ve = new XPathException("The generated content is incomplete: the schema requires further child elements");
                    ve.setErrorCode("XPTY0004");
                    ve.setLocator(children[len - 1]);
                    throw ve;
                }
            }
        } else {
            expression.checkPermittedContents(this, env, true);
        }
    }

    @Override
    public SequenceIterator getTypedValue(NodeInfo node) throws XPathException {
        if (this.isSimpleContent()) {
            try {
                return this.getSimpleContentType().getTypedValue(node);
            }
            catch (UnresolvedReferenceException e) {
                throw new XPathException("Can't get typed value; node is annotated with an incomplete type definition");
            }
        }
        if (this.isMixedContent()) {
            return SingletonIterator.makeIterator(new UntypedAtomicValue(node.getStringValueCS()));
        }
        if (this.isEmptyContent()) {
            return EmptyIterator.getInstance();
        }
        XPathException err = new XPathException("Cannot get the typed value of an element with element-only content");
        err.setErrorCode("FOTY0012");
        err.setIsTypeError(true);
        throw err;
    }

    @Override
    public Value atomize(NodeInfo node) throws XPathException {
        if (this.isSimpleContent()) {
            try {
                return this.getSimpleContentType().atomize(node);
            }
            catch (UnresolvedReferenceException e) {
                throw new XPathException("Can't get typed value; node is annotated with an incomplete type definition");
            }
        }
        if (this.isMixedContent()) {
            return new UntypedAtomicValue(node.getStringValueCS());
        }
        if (this.isEmptyContent()) {
            return EmptySequence.getInstance();
        }
        XPathException err = new XPathException("Cannot get the typed value of an element with element-only content");
        err.setErrorCode("FOTY0012");
        err.setIsTypeError(true);
        throw err;
    }

    public static void checkTypeDerivation(ComplexType derived, SchemaType base, int block) throws SchemaException {
        boolean sameType = derived.isSameType(base);
        if (!sameType && (derived.getDerivationMethod() & block) != 0) {
            throw new SchemaException("Derivation of the requested type " + derived.getDescription() + " is blocked either by the base type " + derived.getDescription() + " or by the element declaration");
        }
        if (sameType) {
            return;
        }
        SchemaType baseTypeOfD = derived.getBaseType();
        if (baseTypeOfD == null) {
            baseTypeOfD = AnyType.getInstance();
        }
        if (base.isSameType(baseTypeOfD)) {
            return;
        }
        if (baseTypeOfD == AnyType.getInstance()) {
            throw new SchemaException("The requested type " + derived.getDescription() + " is not derived from the declared type " + base.getDescription());
        }
        if (baseTypeOfD.isComplexType()) {
            try {
                UserComplexType.checkTypeDerivation((ComplexType)baseTypeOfD, base, block);
            }
            catch (SchemaException err) {
                throw new SchemaException("The requested type " + derived.getDescription() + " is not validly derived from the declared type " + base.getDescription());
            }
        } else {
            String err = UserSimpleType.isTypeDerivationOK((SimpleType)baseTypeOfD, base, block);
            if (err != null) {
                throw new SchemaException("The requested type " + derived.getDescription() + " is not validly derived from the declared type " + base.getDescription() + ". " + err);
            }
        }
    }

    @Override
    public void elaborate(SchemaCompiler compiler) throws SchemaException {
        if (this.getValidationStatus() != 3) {
            if (this.getBaseType() instanceof UserComplexType) {
                ((UserComplexType)this.getBaseType()).elaborate(compiler);
            }
            this.xsdVersion = compiler.getLanguageVersion();
            this.extendedParticle = this.particle;
            if (this.particle != null) {
                this.particle.elaborate(compiler);
            }
            this.makeCombinedAttributeGroup(null);
            this.computeIsAllContent();
            this.extendedAttributes.buildCounterMap();
            Iterator<AttributeUse> iter = this.extendedAttributes.getAttributeUses();
            while (iter.hasNext()) {
                AttributeUse use = iter.next();
                use.elaborate(compiler);
            }
            this.makeContextDeterminedTypeMapForAttributes();
            this.makeContextDeterminedTypeMapForElements();
            this.setValidationStatus(3);
        }
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        String varietyName;
        String id = serializer.getId(this, true);
        serializer.startElement("complexType");
        serializer.emitAttribute("id", id);
        if (!this.isAnonymousType()) {
            serializer.emitAttribute("name", this.getName());
            if (this.getTargetNamespace() != null && this.getTargetNamespace().length() != 0) {
                serializer.emitAttribute("targetNamespace", this.getTargetNamespace());
            }
        }
        serializer.emitAttribute("base", serializer.getTypeLink(this.getBaseType()));
        if (this.finalProhibitions != 0) {
            String ex = "";
            if ((this.finalProhibitions & 2) != 0) {
                ex = (ex.length() == 0 ? "" : " ") + "extension";
            }
            if ((this.finalProhibitions & 1) != 0) {
                ex = ex + (ex.length() == 0 ? "" : " ") + "restriction";
            }
            serializer.emitAttribute("final", ex);
        }
        if (this.block != 0) {
            String dis = "";
            if ((this.block & 2) != 0) {
                dis = "extension";
            }
            if ((this.block & 1) != 0) {
                dis = dis + (dis.length() == 0 ? "" : " ") + "restriction";
            }
            serializer.emitAttribute("block", dis);
        }
        serializer.emitAttribute("derivationMethod", this.getDerivationMethod() == 2 ? "extension" : "restriction");
        serializer.emitAttribute("abstract", this.isAbstract() ? "true" : "false");
        switch (this.variety) {
            case 0: {
                varietyName = "empty";
                break;
            }
            case 3: {
                varietyName = "mixed";
                break;
            }
            case 1: {
                varietyName = "simple";
                break;
            }
            default: {
                varietyName = "element-only";
            }
        }
        serializer.emitAttribute("variety", varietyName);
        if (this.isSimpleContent()) {
            SimpleType st = this.getSimpleContentType();
            serializer.emitAttribute("simpleType", serializer.getTypeLink(st));
        }
        if (this.openContentWildcard != null && this.openContentMode != 0 && this.openContentMode != 1) {
            String modeName;
            switch (this.openContentMode) {
                default: {
                    throw new IllegalStateException("openContent mode must be suffix or interleave");
                }
                case 2: {
                    modeName = "interleave";
                    break;
                }
                case 3: {
                    modeName = "suffix";
                }
            }
            String openContentId = serializer.getId(this.openContentWildcard, false);
            serializer.startElement("openContent");
            serializer.emitAttribute("mode", modeName);
            serializer.emitAttribute("wildcard", openContentId);
            serializer.endElement();
        }
        this.getCombinedAttributeGroup().serializeContents(serializer);
        if (this.isComplexContent()) {
            Particle particle = this.getParticle();
            if (particle != null) {
                particle.serializeParticle(serializer);
            }
            if (this.machine.getInitialState() != null) {
                this.machine.serialize(serializer);
            }
        }
        if (this.hasAssertions()) {
            Iterator iter = this.iterateAssertions();
            while (iter.hasNext()) {
                Assertion assertion = (Assertion)iter.next();
                assertion.serialize(serializer);
            }
        }
        serializer.endElement();
    }
}

