/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.ComponentReference;
import com.saxonica.schema.SymbolSpace;
import net.sf.saxon.type.UnresolvedReferenceException;

public class UnresolvedReferenceExceptionImpl
extends UnresolvedReferenceException {
    private ComponentReference reference;

    public UnresolvedReferenceExceptionImpl(ComponentReference ref) {
        super("Unresolved reference to schema component");
        this.reference = ref;
    }

    public ComponentReference getComponentReference() {
        return this.reference;
    }

    public String getMessage() {
        try {
            String space = SymbolSpace.getSymbolSpaceName(this.reference.getSymbolSpace());
            String component = this.reference.getConfiguration().getNamePool().getClarkName(this.reference.getFingerprint());
            return "The schema contains an unresolved reference to " + space + ' ' + component + " at line " + this.reference.getLineNumber() + " in " + this.reference.getSystemId();
        }
        catch (Exception e) {
            return super.getMessage();
        }
    }
}

