/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.AttributeDecl;
import com.saxonica.schema.AttributeGroupDecl;
import com.saxonica.schema.ComponentReference;
import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.IdentityConstraint;
import com.saxonica.schema.ModelGroupDefinition;
import com.saxonica.schema.Notation;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaStructure;
import com.saxonica.schema.SymbolSpace;
import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.UserDefinedType;
import com.saxonica.schema.UserSchemaComponent;
import com.saxonica.schema.UserSimpleType;
import com.saxonica.schema.sdoc.SimpleTypeDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.expr.sort.IntIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NotationSet;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;

public class PreparedSchema
extends SchemaStructure
implements NotationSet {
    public static final int NAMESPACE_UNKNOWN = 1;
    public static final int NAMESPACE_UNDER_CONSTRUCTION = 2;
    public static final int NAMESPACE_KNOWN = 3;
    public static final int NAMESPACE_SEALED = 4;
    private EnterpriseConfiguration config;
    private Set<String> targetNamespaces = new HashSet<String>();
    private IntHashMap<AttributeDecl> attributes = null;
    private IntHashMap<AttributeGroupDecl> attributeGroups = null;
    private IntHashMap<ModelGroupDefinition> groups = null;
    private IntHashMap<SchemaType> types = null;
    private IntHashMap<SchemaType> anonymousTypes = null;
    private IntHashMap<ElementDecl> elements = null;
    private IntHashMap<IdentityConstraint> identityConstraints;
    private IntHashMap<Notation> notations;
    private NamePool namePool;
    private transient List components;
    private IntHashMap<Set<UserComplexType>> extensionsOfBuiltInTypes;
    private HashMap<StructuredQName, GlobalParam> params;

    protected PreparedSchema() {
    }

    public PreparedSchema(EnterpriseConfiguration config) {
        this.namePool = config.getNamePool();
        this.config = config;
        this.attributes = new IntHashMap(10);
        this.attributeGroups = new IntHashMap(20);
        this.groups = new IntHashMap(20);
        this.types = new IntHashMap(100);
        this.elements = new IntHashMap(100);
        this.anonymousTypes = new IntHashMap(100);
        this.params = new HashMap(20);
    }

    public void setConfiguration(EnterpriseConfiguration config) {
        this.config = config;
    }

    public EnterpriseConfiguration getConfiguration() {
        return this.config;
    }

    public void addComponent(UserSchemaComponent obj) {
        if (this.components == null) {
            this.components = new ArrayList(20);
        }
        this.components.add(obj);
    }

    private void fixupComponentReferences(SchemaCompiler compiler) throws SchemaException {
        int errors = 0;
        if (this.components != null) {
            for (int i = 0; i < this.components.size(); ++i) {
                UserSchemaComponent fixable = (UserSchemaComponent)this.components.get(i);
                try {
                    boolean b = fixable.fixup(compiler);
                    if (b) continue;
                    ++errors;
                    continue;
                }
                catch (SchemaException err) {
                    ++errors;
                    try {
                        compiler.getErrorListener().fatalError(err);
                        continue;
                    }
                    catch (TransformerException e) {
                        throw err;
                    }
                }
            }
            if (errors > 0) {
                throw new SchemaException("Errors were found in the schema");
            }
        }
    }

    public AttributeDecl getAttributeDecl(int fingerprint) {
        return this.attributes.get(fingerprint);
    }

    public Iterator iterateAttributeDeclarations() {
        return this.attributes.valueIterator();
    }

    public void addAttributeDecl(AttributeDecl attribute) {
        if (this.attributes.put(attribute.getFingerprint(), attribute) != attribute) {
            this.addComponent(attribute);
            this.targetNamespaces.add(attribute.getTargetNamespace());
        }
    }

    public AttributeGroupDecl getAttributeGroup(int fingerprint) {
        return this.attributeGroups.get(fingerprint);
    }

    public Iterator iterateAttributeGroups() {
        return this.attributeGroups.valueIterator();
    }

    public void addAttributeGroup(AttributeGroupDecl attributeGroup) {
        AttributeGroupDecl existing = this.attributeGroups.get(attributeGroup.getFingerprint());
        if (existing == null || existing.getRedefinitionLevel() <= attributeGroup.getRedefinitionLevel()) {
            this.attributeGroups.put(attributeGroup.getFingerprint(), attributeGroup);
            if (existing != attributeGroup) {
                this.addComponent(attributeGroup);
                this.targetNamespaces.add(attributeGroup.getTargetNamespace());
            }
        }
    }

    public ModelGroupDefinition getGroup(int fingerprint) {
        return this.groups.get(fingerprint);
    }

    public Iterator iterateModelGroups() {
        return this.groups.valueIterator();
    }

    public void addGroup(ModelGroupDefinition group) {
        ModelGroupDefinition existing = this.groups.get(group.getFingerprint());
        if (existing == null || existing.getRedefinitionLevel() <= group.getRedefinitionLevel()) {
            this.groups.put(group.getFingerprint(), group);
            if (existing != group) {
                this.addComponent(group);
                this.targetNamespaces.add(group.getTargetNamespace());
            }
        }
    }

    public SchemaType getSchemaType(int fingerprint) {
        if (fingerprint < 1024) {
            if (fingerprint == 532 && this.config.getXsdVersion() == 10) {
                return null;
            }
            SchemaType type = BuiltInType.getSchemaType(fingerprint);
            if (type != null) {
                return type;
            }
        }
        return this.types.get(fingerprint);
    }

    public SimpleType getSimpleType(int fingerprint) {
        SchemaType t = this.getSchemaType(fingerprint);
        if (t instanceof SimpleType) {
            return (SimpleType)t;
        }
        return null;
    }

    public Iterator iterateTypes() {
        return this.types.valueIterator();
    }

    public void addType(SchemaType type) {
        int fp = type.getFingerprint();
        SchemaType existing = this.types.get(fp);
        if (existing == null || existing.getRedefinitionLevel() <= type.getRedefinitionLevel()) {
            this.types.put(fp, type);
            if (existing != type && type instanceof UserSchemaComponent) {
                this.addComponent((UserSchemaComponent)((Object)type));
                this.targetNamespaces.add(type.getTargetNamespace());
            }
        }
    }

    public void addAnonymousType(SchemaType type) {
        this.anonymousTypes.put(type.getFingerprint(), type);
    }

    public SchemaType getType(int fingerprint) {
        SchemaType type = this.getSchemaType(fingerprint);
        if (type == null) {
            type = this.anonymousTypes.get(fingerprint);
        }
        return type;
    }

    public void registerExtensionOfBuiltInType(int fp, UserComplexType extension) {
        Set<UserComplexType> set;
        if (this.extensionsOfBuiltInTypes == null) {
            this.extensionsOfBuiltInTypes = new IntHashMap(20);
        }
        if ((set = this.extensionsOfBuiltInTypes.get(fp)) == null) {
            set = new HashSet<UserComplexType>(4);
            this.extensionsOfBuiltInTypes.put(fp, set);
        }
        set.add(extension);
    }

    public Set getExtensionsOfBuiltInType(int fp) {
        Set<UserComplexType> set = this.extensionsOfBuiltInTypes.get(fp);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public void addElementDecl(ElementDecl elementDecl) {
        ElementDecl existing = this.elements.get(elementDecl.getFingerprint());
        if (existing == null || existing.getRedefinitionLevel() <= elementDecl.getRedefinitionLevel()) {
            this.elements.put(elementDecl.getFingerprint(), elementDecl);
            if (existing != elementDecl) {
                this.addComponent(elementDecl);
                this.targetNamespaces.add(elementDecl.getTargetNamespace());
            }
        }
    }

    public ElementDecl getElementDecl(int fingerprint) {
        return this.elements.get(fingerprint);
    }

    public Iterator iterateElementDeclarations() {
        return this.elements.valueIterator();
    }

    public void addNotation(Notation notation) {
        if (this.notations == null) {
            this.notations = new IntHashMap(20);
        }
        if (this.notations.put(notation.getFingerprint(), notation) != notation) {
            this.addComponent(notation);
            this.targetNamespaces.add(notation.getTargetNamespace());
        }
    }

    public Notation getNotation(int fingerprint) {
        if (this.notations == null) {
            return null;
        }
        return this.notations.get(fingerprint);
    }

    public Iterator iterateNotations() {
        if (this.notations == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.notations.valueIterator();
    }

    public void addIdentityConstraint(IdentityConstraint constraint) {
        if (this.identityConstraints == null) {
            this.identityConstraints = new IntHashMap(20);
        }
        if (this.identityConstraints.put(constraint.getFingerprint(), constraint) != constraint) {
            this.addComponent(constraint);
            this.targetNamespaces.add(constraint.getTargetNamespace());
        }
    }

    public IdentityConstraint getIdentityConstraint(int fingerprint) {
        if (this.identityConstraints == null) {
            return null;
        }
        return this.identityConstraints.get(fingerprint);
    }

    public Iterator iterateIdentityConstraints() {
        if (this.identityConstraints == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.identityConstraints.valueIterator();
    }

    public Set getTargetNamespaces() {
        return this.targetNamespaces;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void addGlobalParam(GlobalParam param) throws SchemaException {
        GlobalParam prev = this.params.put(param.getVariableQName(), param);
        if (prev != null) {
            throw new SchemaException("Duplicate declaration of parameter " + param.getVariableQName().getClarkName());
        }
    }

    public GlobalParam getGlobalParam(StructuredQName name) {
        return this.params.get(name);
    }

    public void copyTo(PreparedSchema destination, SchemaCompiler compiler) throws SchemaException {
        this.checkConsistency(destination, compiler);
        this.copyWithoutChecking(destination);
    }

    private void copyWithoutChecking(PreparedSchema destination) {
        SchemaStructure decl;
        SchemaType type;
        IntIterator iter = this.types.keyIterator();
        while (iter.hasNext()) {
            int fp = iter.next();
            type = this.types.get(fp);
            destination.addType(type);
        }
        Iterator viter = this.anonymousTypes.valueIterator();
        while (viter.hasNext()) {
            type = (UserDefinedType)viter.next();
            destination.addAnonymousType(type);
        }
        viter = this.elements.valueIterator();
        while (viter.hasNext()) {
            decl = (ElementDecl)viter.next();
            destination.addElementDecl((ElementDecl)decl);
        }
        viter = this.attributes.valueIterator();
        while (viter.hasNext()) {
            decl = (AttributeDecl)viter.next();
            destination.addAttributeDecl((AttributeDecl)decl);
        }
        viter = this.groups.valueIterator();
        while (viter.hasNext()) {
            decl = (ModelGroupDefinition)viter.next();
            destination.addGroup((ModelGroupDefinition)decl);
        }
        viter = this.attributeGroups.valueIterator();
        while (viter.hasNext()) {
            decl = (AttributeGroupDecl)viter.next();
            destination.addAttributeGroup((AttributeGroupDecl)decl);
        }
        if (this.notations != null) {
            viter = this.notations.valueIterator();
            while (viter.hasNext()) {
                decl = (Notation)viter.next();
                destination.addNotation((Notation)decl);
            }
        }
        if (this.identityConstraints != null) {
            viter = this.identityConstraints.valueIterator();
            while (viter.hasNext()) {
                decl = (IdentityConstraint)viter.next();
                destination.addIdentityConstraint((IdentityConstraint)decl);
            }
        }
        HashSet destinationComponents = new HashSet();
        if (destination.components != null) {
            Iterator it = destination.components.iterator();
            while (it.hasNext()) {
                destinationComponents.add(it.next());
            }
        }
        if (this.components != null) {
            for (UserSchemaComponent comp : this.components) {
                if (destinationComponents.contains(comp)) continue;
                destination.addComponent(comp);
            }
        }
        if (this.extensionsOfBuiltInTypes != null) {
            IntIterator ii = this.extensionsOfBuiltInTypes.keyIterator();
            while (ii.hasNext()) {
                int fp = ii.next();
                Set types = this.getExtensionsOfBuiltInType(fp);
                for (UserComplexType type2 : types) {
                    destination.registerExtensionOfBuiltInType(fp, type2);
                }
            }
        }
        for (GlobalParam param : this.params.values()) {
            try {
                destination.addGlobalParam(param);
            }
            catch (SchemaException err) {
                throw new IllegalStateException(err);
            }
        }
    }

    private void checkConsistency(PreparedSchema destination, SchemaCompiler compiler) throws SchemaException {
        SchemaStructure decl;
        String loc;
        SchemaComponent existing;
        SchemaType type;
        boolean conflicts = false;
        IntIterator iter = this.types.keyIterator();
        while (iter.hasNext()) {
            int fp = iter.next();
            type = this.types.get(fp);
            existing = destination.getSchemaType(type.getFingerprint());
            if (existing == null || type.getRedefinitionLevel() != existing.getRedefinitionLevel() || type.isSameType((SchemaType)existing)) continue;
            loc = "";
            if (existing instanceof SourceLocator) {
                loc = this.existingLocation((SourceLocator)((Object)existing));
            }
            compiler.error("Duplicate type " + Err.wrap(type.getDisplayName()) + loc, type instanceof SourceLocator ? (SourceLocator)((Object)type) : null);
            conflicts = true;
        }
        Iterator viter = this.anonymousTypes.valueIterator();
        while (viter.hasNext()) {
            type = (UserDefinedType)viter.next();
            existing = destination.getSchemaType(((UserDefinedType)type).getFingerprint());
            if (existing == null || ((UserDefinedType)type).isSameType((SchemaType)existing)) continue;
            loc = "";
            if (existing instanceof SourceLocator) {
                loc = this.existingLocation((SourceLocator)((Object)existing));
            }
            compiler.error("Duplicate type " + Err.wrap(((UserDefinedType)type).getName()) + loc, (SourceLocator)((Object)type));
            conflicts = true;
        }
        viter = this.elements.valueIterator();
        while (viter.hasNext()) {
            decl = (ElementDecl)viter.next();
            existing = destination.getElementDecl(((ElementDecl)decl).getFingerprint());
            if (existing == null || ((ElementDecl)existing).isSameDeclaration((ElementDecl)decl)) continue;
            loc = this.existingLocation((SourceLocator)((Object)existing));
            compiler.error("Duplicate element declaration " + Err.wrap(((ElementDecl)decl).getDisplayName(), 1) + loc, decl);
            conflicts = true;
        }
        viter = this.attributes.valueIterator();
        while (viter.hasNext()) {
            decl = (AttributeDecl)viter.next();
            existing = destination.getAttributeDecl(((AttributeDecl)decl).getFingerprint());
            if (existing == null || ((AttributeDecl)existing).isSameDeclaration((AttributeDecl)decl)) continue;
            loc = this.existingLocation((SourceLocator)((Object)existing));
            compiler.error("Duplicate attribute declaration " + Err.wrap(((AttributeDecl)decl).getDisplayName()) + loc, decl);
            conflicts = true;
        }
        viter = this.groups.valueIterator();
        while (viter.hasNext()) {
            decl = (ModelGroupDefinition)viter.next();
            existing = destination.getGroup(((ModelGroupDefinition)decl).getFingerprint());
            if (existing == null || ((SchemaStructure)((Object)existing)).getRedefinitionLevel() != decl.getRedefinitionLevel() || ((ModelGroupDefinition)existing).isSameGroup((ModelGroupDefinition)decl)) continue;
            loc = this.existingLocation((SourceLocator)((Object)existing));
            compiler.error("Duplicate group declaration " + Err.wrap(((ModelGroupDefinition)decl).getName()) + loc, decl);
            conflicts = true;
        }
        viter = this.attributeGroups.valueIterator();
        while (viter.hasNext()) {
            decl = (AttributeGroupDecl)viter.next();
            existing = destination.getAttributeGroup(((AttributeGroupDecl)decl).getFingerprint());
            if (existing == null || ((SchemaStructure)((Object)existing)).getRedefinitionLevel() != decl.getRedefinitionLevel() || ((AttributeGroupDecl)existing).isSameDeclaration((AttributeGroupDecl)decl)) continue;
            loc = this.existingLocation((SourceLocator)((Object)existing));
            compiler.error("Duplicate attribute group declaration " + Err.wrap(((AttributeGroupDecl)decl).getDisplayName()) + loc, decl);
            conflicts = true;
        }
        if (this.notations != null) {
            viter = this.notations.valueIterator();
            while (viter.hasNext()) {
                decl = (Notation)viter.next();
                existing = destination.getNotation(((Notation)decl).getFingerprint());
                if (existing == null || existing == decl) continue;
                loc = this.existingLocation((SourceLocator)((Object)existing));
                compiler.error("Duplicate notation declaration " + Err.wrap(((Notation)decl).getName()) + loc, decl);
                conflicts = true;
            }
        }
        if (this.identityConstraints != null) {
            viter = this.identityConstraints.valueIterator();
            while (viter.hasNext()) {
                decl = (IdentityConstraint)viter.next();
                existing = destination.getIdentityConstraint(((IdentityConstraint)decl).getFingerprint());
                if (existing == null || existing == decl) continue;
                loc = this.existingLocation((SourceLocator)((Object)existing));
                compiler.error("Duplicate identity constraint name " + Err.wrap(((IdentityConstraint)decl).getName()) + loc, decl);
                conflicts = true;
            }
        }
        for (GlobalParam param : this.params.values()) {
            if (destination.getGlobalParam(param.getVariableQName()) == null) continue;
            compiler.error("Duplicate saxon:param declaration " + param.getVariableQName().getClarkName(), param);
            conflicts = true;
        }
        if (conflicts) {
            throw new SchemaException("Duplicated components found in schema");
        }
    }

    private String existingLocation(SourceLocator existing) {
        if (existing.getLineNumber() < 1) {
            return " - previously defined in directly imported component";
        }
        return " - previously defined on line " + existing.getLineNumber() + " of " + existing.getSystemId();
    }

    public boolean validate(SchemaCompiler compiler) throws SchemaException, ValidationException {
        boolean result = true;
        this.fixupComponentReferences(compiler);
        Iterator iter = this.elements.valueIterator();
        while (iter.hasNext()) {
            ElementDecl elementDecl = (ElementDecl)iter.next();
            elementDecl.fixupSubstitutionGroup(compiler);
        }
        if (this.components != null) {
            for (UserSchemaComponent s : this.components) {
                if (!(result &= s.validate(compiler)) || !(s instanceof SimpleTypeDefinition)) continue;
                UserSimpleType st = ((SimpleTypeDefinition)s).getSimpleType();
                int fp = st.getFingerprint();
                this.types.put(fp, st);
            }
        }
        if (result) {
            compiler.typeCheckIdentityConstraints();
        }
        this.components = null;
        if (result) {
            this.config.addSchema(this);
        }
        return result;
    }

    public static SchemaComponent validateReference(ComponentReference ref, SchemaCompiler compiler) throws SchemaException {
        ref.tryToResolve(compiler);
        if (ref.isResolved()) {
            return ref.getTarget();
        }
        String componentType = SymbolSpace.getSymbolSpaceName(ref.getSymbolSpace());
        NamePool pool = compiler.getNamePool();
        String reason = "has not been declared";
        if ("http://www.w3.org/2001/XMLSchema".equals(pool.getURI(ref.getFingerprint()))) {
            reason = "is not defined in the XML Schema namespace";
        }
        compiler.error("The " + componentType + ' ' + Err.wrap(pool.getDisplayName(ref.getFingerprint())) + " is referenced, but " + reason, ref);
        return null;
    }

    public static PreparedSchema merge(PreparedSchema ps1, PreparedSchema ps2) throws SchemaException {
        if (ps1.config != ps2.config) {
            throw new SchemaException("The two schemas to be merged must use the same EnterpriseConfiguration");
        }
        NamePool pool = ps1.config.getNamePool();
        PreparedSchema result = new PreparedSchema(ps1.config);
        result.attributes = PreparedSchema.combine(ps1.attributes, ps2.attributes, pool, "Attribute declaration");
        result.attributeGroups = PreparedSchema.combine(ps1.attributeGroups, ps2.attributeGroups, pool, "Attribute group");
        result.groups = PreparedSchema.combine(ps1.groups, ps2.groups, pool, "Model group");
        result.types = PreparedSchema.combine(ps1.types, ps2.types, pool, "Type");
        result.anonymousTypes = PreparedSchema.combine(ps1.anonymousTypes, ps2.anonymousTypes, pool, "Anonymous type");
        result.elements = PreparedSchema.combine(ps1.elements, ps2.elements, pool, "Element declaration");
        result.notations = PreparedSchema.combine(ps1.notations, ps2.notations, pool, "Notation");
        result.identityConstraints = PreparedSchema.combine(ps1.identityConstraints, ps2.identityConstraints, pool, "Identity constraint");
        if (ps1.components != null || ps2.components != null) {
            result.components = new ArrayList((ps1.components == null ? 0 : ps1.components.size()) + (ps2.components == null ? 0 : ps2.components.size()));
            if (ps1.components != null) {
                result.components.addAll(ps1.components);
            }
            if (ps2.components != null) {
                result.components.addAll(ps2.components);
            }
        }
        result.targetNamespaces.addAll(ps1.targetNamespaces);
        result.targetNamespaces.addAll(ps2.targetNamespaces);
        return result;
    }

    private static IntHashMap combine(IntHashMap m1, IntHashMap m2, NamePool pool, String kind) throws SchemaException {
        if (m1 == null) {
            return m2;
        }
        if (m2 == null) {
            return m1;
        }
        IntHashMap result = new IntHashMap(m1.size() + m2.size());
        IntIterator i1 = m1.keyIterator();
        while (i1.hasNext()) {
            int k1 = i1.next();
            Object v1 = m1.get(k1);
            Object v2 = m2.get(k1);
            if (v2 != null && v2 != v1) {
                String loc1 = v1.getClass().getName();
                if (v1 instanceof SchemaStructure) {
                    loc1 = "line " + ((SchemaStructure)v1).getLineNumber() + " of " + ((SchemaStructure)v1).getSystemId();
                }
                String loc2 = v2.getClass().getName();
                if (v2 instanceof SchemaStructure) {
                    loc2 = "line " + ((SchemaStructure)v2).getLineNumber() + " of " + ((SchemaStructure)v2).getSystemId();
                }
                if (!loc1.equals(loc2)) {
                    throw new SchemaException(kind + " " + pool.getDisplayName(k1) + " is defined in more than one schema document (" + loc1 + ", " + loc2 + ")");
                }
            }
            result.put(k1, v1);
        }
        IntIterator i2 = m2.keyIterator();
        while (i2.hasNext()) {
            int k2 = i2.next();
            result.put(k2, m2.get(k2));
        }
        return result;
    }

    public boolean isDeclaredNotation(String uri, String local) {
        int namecode = this.config.getNamePool().allocate("", uri, local);
        return this.notations.get(namecode) != null;
    }
}

