/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.ModelGroup;
import com.saxonica.schema.ModelGroupParticle;
import com.saxonica.schema.Particle;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.SerializableSchemaComponent;
import com.saxonica.schema.TypeReference;
import com.saxonica.schema.UserComplexType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.UnresolvedReferenceException;

public class ModelGroupDefinition
extends ModelGroup
implements SerializableSchemaComponent {
    private int nameCode;
    private ModelGroupDefinition redefinedModelGroupDefinition;

    public ModelGroupDefinition(EnterpriseConfiguration config, SourceLocator locator) {
        this.setLocator(locator);
        this.setConfiguration(config);
    }

    public void setRedefinedModelGroupDefinition(ModelGroupDefinition other) {
        this.redefinedModelGroupDefinition = other;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public int getFingerprint() {
        return this.nameCode & 0xFFFFF;
    }

    public void setNameCode(int nameCode) {
        this.nameCode = nameCode;
    }

    public String getName() {
        return this.getConfiguration().getNamePool().getLocalName(this.nameCode);
    }

    public String getTargetNamespace() {
        return this.getConfiguration().getNamePool().getURI(this.nameCode);
    }

    public boolean isEmptiable() throws UnresolvedReferenceException {
        Iterator<Particle> iter = this.iterateParticles();
        while (iter.hasNext()) {
            Particle p = iter.next();
            if (p.isEmptiable()) continue;
            return false;
        }
        return true;
    }

    public boolean isPointless(ModelGroup container) {
        return this.contentModel.isEmpty() || this.contentModel.size() == 1;
    }

    public void lookForCycles(Stack references, SchemaCompiler compiler) throws SchemaException, UnresolvedReferenceException {
        if (references.contains(this)) {
            String err = "The definition of group " + Err.wrap(this.getConfiguration().getNamePool().getDisplayName(this.getFingerprint())) + " is circular";
            this.contentModel = new ArrayList(20);
            throw new SchemaException(err, this);
        }
        super.lookForCycles(references, compiler);
    }

    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        boolean result = true;
        switch (this.getValidationStatus()) {
            case 3: 
            case 4: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        this.setValidationStatus(2);
        if (this.contentModel == null || this.contentModel.isEmpty()) {
            String err = "The group should contain 'all' or 'sequence' or 'choice'";
            compiler.error(err, this);
            this.setValidationStatus(4);
            return false;
        }
        if (this.redefinedModelGroupDefinition != null) {
            TypeReference ref = new TypeReference(572, this.getConfiguration(), this);
            ref.setTarget(AnyType.getInstance());
            UserComplexType r = new UserComplexType(compiler.getConfiguration(), this);
            ModelGroupParticle rp = new ModelGroupParticle(compiler.getConfiguration(), null);
            rp.setTarget(this);
            r.setParticle(rp);
            r.setVariety(2);
            r.setBaseTypeReference(ref);
            r.validate(compiler);
            UserComplexType b = new UserComplexType(compiler.getConfiguration(), this.redefinedModelGroupDefinition);
            ModelGroupParticle bp = new ModelGroupParticle(compiler.getConfiguration(), null);
            bp.setTarget(this.redefinedModelGroupDefinition);
            b.setParticle(bp);
            b.setVariety(2);
            b.setBaseTypeReference(ref);
            b.validate(compiler);
            String problem = r.isSubsumedBy(b, compiler);
            if (problem != null) {
                compiler.error("Group " + this.getName() + " is not a valid restriction of the group that it redefines. " + problem, this);
                result = false;
            }
        }
        this.setValidationStatus((result &= super.validate(compiler)) ? 3 : 4);
        return result;
    }

    public boolean isSameGroup(ModelGroupDefinition other) {
        return this == other || this.getFingerprint() == other.getFingerprint() && this.getLineNumber() == other.getLineNumber() && this.getColumnNumber() == other.getColumnNumber() && this.getSystemId().equals(other.getSystemId());
    }

    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        String id = serializer.getId(this, true);
        serializer.startElement("modelGroupDefinition");
        serializer.emitAttribute("id", id);
        serializer.emitAttribute("name", this.getName());
        if (this.getTargetNamespace() != null && this.getTargetNamespace().length() > 0) {
            serializer.emitAttribute("targetNamespace", this.getTargetNamespace());
        }
        Iterator<Particle> iter = this.iterateParticles();
        while (iter.hasNext()) {
            Particle p = iter.next();
            p.serializeParticle(serializer);
        }
        serializer.endElement();
    }

    public String getCompositorName() {
        return "modelGroupDefinition";
    }
}

