/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.Facet;
import com.saxonica.schema.MaxScaleFacet;
import com.saxonica.schema.ScaleFacet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.UserSimpleType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.PrecisionDecimalValue;

public class MinScaleFacet
extends ScaleFacet {
    public String getName() {
        return "minScale";
    }

    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
        Facet max = type.getFacet(MaxScaleFacet.class);
        if (max != null && max.toLong() < (long)this.getNumericValue()) {
            throw new SchemaException("The minScale facet exceeds the maxScale");
        }
        if (base instanceof UserSimpleType) {
            UserSimpleType ubase = (UserSimpleType)base;
            Facet baseFacet = ubase.getFacet(MinScaleFacet.class);
            if (baseFacet != null && (long)this.getNumericValue() < baseFacet.toLong()) {
                throw new SchemaException("In a type derived by restriction, the minScale facet is shorter than the minScale of the base type");
            }
            baseFacet = ubase.getFacet(MaxScaleFacet.class);
            if (baseFacet != null && (long)this.getNumericValue() > baseFacet.toLong()) {
                throw new SchemaException("In a type derived by restriction, the minScale facet is longer than the maxScale of the base type");
            }
        }
    }

    public boolean testAtomicValue(AtomicValue value) {
        return ((PrecisionDecimalValue)value).checkMinScale(this.getNumericValue());
    }
}

