/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.Facet;
import com.saxonica.schema.LengthFacet;
import com.saxonica.schema.LengthRangeFacet;
import com.saxonica.schema.MinLengthFacet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.UserSimpleType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;

public class MaxLengthFacet
extends LengthRangeFacet {
    public String getName() {
        return "maxLength";
    }

    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
        if (base instanceof UserSimpleType) {
            UserSimpleType ubase = (UserSimpleType)base;
            Facet baseFacet = ubase.getFacet(LengthFacet.class);
            if (baseFacet != null) {
                if ((long)this.requiredLength != baseFacet.toLong()) {
                    throw new SchemaException("In a type derived by restriction, the maxLength facet conflicts with the length of the base type");
                }
                SchemaType parent = base;
                boolean ok = false;
                while (parent instanceof UserSimpleType) {
                    Facet parentMaxLength = ((UserSimpleType)parent).getFacet(MaxLengthFacet.class);
                    if (parentMaxLength != null && parentMaxLength.toLong() == (long)this.requiredLength && ((UserSimpleType)parent).getFacet(LengthFacet.class) == null) {
                        ok = true;
                        break;
                    }
                    parent = parent.getBaseType();
                }
                if (!ok) {
                    throw new SchemaException("A type cannot have both a length and a maxLength facet unless it is derived from a type having the same maxLength and no length facet");
                }
            }
            if ((baseFacet = ubase.getFacet(MinLengthFacet.class)) != null && (long)this.requiredLength < baseFacet.toLong()) {
                throw new SchemaException("In a type derived by restriction, the maxLength facet is shorter than the minLength of the base type");
            }
            baseFacet = ubase.getFacet(MaxLengthFacet.class);
            if (baseFacet != null && (long)this.requiredLength > baseFacet.toLong()) {
                throw new SchemaException("In a type derived by restriction, the maxLength facet is longer than the maxLength of the base type");
            }
        }
    }

    public boolean testLength(int actualLength) {
        return actualLength <= this.requiredLength;
    }
}

