/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.MinExclusiveFacet;
import com.saxonica.schema.MinInclusiveFacet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.UserSimpleType;
import com.saxonica.schema.ValueRangeFacet;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;

public class MaxInclusiveFacet
extends ValueRangeFacet {
    public String getName() {
        return "maxInclusive";
    }

    protected boolean testComparisonOK(int comparisonResult) {
        return comparisonResult <= 0;
    }

    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
        super.checkFacetRestriction(type, base, compiler);
        ValueRangeFacet min = (ValueRangeFacet)type.getFacet(MinExclusiveFacet.class);
        if (min != null) {
            min.convertToTargetType(base, type.getConfiguration());
            if (this.requiredValue.getSchemaComparable().compareTo(min.requiredValue.getSchemaComparable()) <= 0) {
                throw new SchemaException("maxInclusive facet is less than or equal to minExclusive");
            }
        }
        if ((min = (ValueRangeFacet)type.getFacet(MinInclusiveFacet.class)) != null) {
            min.convertToTargetType(base, type.getConfiguration());
            if (this.requiredValue.getSchemaComparable().compareTo(min.requiredValue.getSchemaComparable()) < 0) {
                throw new SchemaException("maxInclusive facet is less than or equal to minInclusive");
            }
        }
    }
}

