/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.Facet;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.StringValue;

public abstract class LengthRangeFacet
extends Facet {
    int requiredLength;

    public String getValue() {
        return "" + this.requiredLength;
    }

    public long toLong() {
        return this.requiredLength;
    }

    public void setNumericValue(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("length facet < 0");
        }
        this.requiredLength = value;
    }

    public void setValue(String value) throws SchemaException {
        try {
            this.requiredLength = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new SchemaException("Value of " + this.getName() + " facet " + Err.wrap(value, 4) + " is not an integer");
        }
        if (this.requiredLength < 0) {
            throw new SchemaException("Value of " + this.getName() + " facet " + Err.wrap(value, 4) + " must be a positive integer");
        }
    }

    public boolean testAtomicValue(AtomicValue value) {
        try {
            if (value instanceof StringValue) {
                return this.testLength(((StringValue)value).getStringLength());
            }
            if (value instanceof AnyURIValue) {
                return this.testLength(((StringValue)value.convert(BuiltInAtomicType.STRING, true, null).asAtomic()).getStringLength());
            }
            if (value instanceof HexBinaryValue) {
                return this.testLength(((HexBinaryValue)value).getLengthInOctets());
            }
            if (value instanceof Base64BinaryValue) {
                return this.testLength(((Base64BinaryValue)value).getLengthInOctets());
            }
            if (value instanceof QualifiedNameValue) {
                return true;
            }
            throw new AssertionError((Object)"Length facet found on unexpected type");
        }
        catch (XPathException e) {
            return false;
        }
    }

    public abstract boolean testLength(int var1);
}

