/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.ComponentReference;
import com.saxonica.schema.IdentityConstraint;
import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.UnresolvedReferenceExceptionImpl;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.UnresolvedReferenceException;

public class KeyRef
extends IdentityConstraint
implements ComponentReference {
    private int referFingerprint;
    private IdentityConstraint target;

    public KeyRef() {
    }

    public KeyRef(int refer) {
        this.setReferFingerprint(refer);
    }

    public int getReferFingerprint() {
        return this.referFingerprint;
    }

    public void setReferFingerprint(int referFingerprint) {
        this.referFingerprint = referFingerprint;
    }

    public void setTargetKey(IdentityConstraint key) {
        this.target = key;
    }

    public void tryToResolve(SchemaCompiler compiler) {
        this.target = compiler.getPreparedSchema().getIdentityConstraint(this.referFingerprint);
        if (this.target == null) {
            this.target = compiler.getConfiguration().getSuperSchema().getIdentityConstraint(this.referFingerprint);
        }
    }

    public boolean isResolved() {
        return this.target != null;
    }

    public SchemaComponent getTarget() throws UnresolvedReferenceException {
        if (this.target == null) {
            throw new UnresolvedReferenceExceptionImpl(this);
        }
        return this.target;
    }

    public int getSymbolSpace() {
        return 807;
    }

    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        if (this.getFixupStatus() == 0) {
            this.setFixupStatus(2);
            IdentityConstraint key = (IdentityConstraint)PreparedSchema.validateReference(this, compiler);
            if (key == null) {
                this.setFixupStatus(4);
                return false;
            }
            if (key instanceof KeyRef) {
                compiler.error("The key reference " + Err.wrap(this.getConfiguration().getNamePool().getDisplayName(this.referFingerprint)) + " refers to a key reference, not to a key or unique constraint", this);
                this.target = null;
                this.setFixupStatus(4);
                return false;
            }
            key.fixup(compiler);
        }
        this.setFixupStatus(3);
        return true;
    }

    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        boolean result = super.validate(compiler);
        this.tryToResolve(compiler);
        if (this.target == null) {
            compiler.error("Identity constraint " + Err.wrap(this.getConfiguration().getNamePool().getDisplayName(this.referFingerprint)) + " is referenced, but has not been declared", this);
            result = false;
        } else if (this.target instanceof KeyRef) {
            compiler.error("The key reference " + Err.wrap(this.getConfiguration().getNamePool().getDisplayName(this.referFingerprint)) + " refers to a key reference, not to a key or unique constraint", this);
            result = false;
        } else if (this.getFields().size() != this.target.getFields().size()) {
            compiler.error("The key reference " + Err.wrap(this.getConfiguration().getNamePool().getDisplayName(this.referFingerprint)) + " has a different number of fields from the identity constraint that it references", this);
            result = false;
        }
        return result;
    }
}

