/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.ComponentReference;
import com.saxonica.schema.IdentityConstraint;
import com.saxonica.schema.Key;
import com.saxonica.schema.KeyRef;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaStructure;
import com.saxonica.schema.Unique;
import com.saxonica.schema.UnresolvedReferenceExceptionImpl;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.type.UnresolvedReferenceException;

public class IdentityConstraintReference
extends SchemaStructure
implements ComponentReference {
    private int fingerprint;
    private IdentityConstraint target;
    private int expectedKind;

    public IdentityConstraintReference() {
    }

    public IdentityConstraintReference(int fingerprint, int kind, EnterpriseConfiguration config, SourceLocator locator) {
        this.fingerprint = fingerprint;
        this.expectedKind = kind;
        if (locator != null) {
            this.setLocator(locator);
        }
        this.setConfiguration(config);
    }

    public int getExpectedKindOfConstraint() {
        return this.expectedKind;
    }

    public boolean isResolved() {
        return this.target != null;
    }

    public void setTarget(IdentityConstraint target) {
        this.target = target;
        this.fingerprint = target.getFingerprint();
        if (target instanceof Key) {
            this.expectedKind = 599;
        } else if (target instanceof Unique) {
            this.expectedKind = 625;
        } else if (target instanceof KeyRef) {
            this.expectedKind = 600;
        }
    }

    public int getFingerprint() {
        return this.fingerprint;
    }

    public int getSymbolSpace() {
        return 807;
    }

    public IdentityConstraint getTarget() throws UnresolvedReferenceException {
        if (this.target == null) {
            throw new UnresolvedReferenceExceptionImpl(this);
        }
        return this.target;
    }

    public void tryToResolve(SchemaCompiler compiler) {
        if (this.target == null) {
            this.target = compiler.getPreparedSchema().getIdentityConstraint(this.getFingerprint());
        }
        if (this.target == null) {
            this.target = this.getConfiguration().getSuperSchema().getIdentityConstraint(this.getFingerprint());
        }
    }
}

