/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.IdentityField;
import com.saxonica.schema.IdentitySelector;
import com.saxonica.schema.Key;
import com.saxonica.schema.KeyRef;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.SchemaStructure;
import com.saxonica.schema.SerializableSchemaComponent;
import com.saxonica.schema.Unique;
import com.saxonica.schema.UserSchemaComponent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sxpath.DedicatedStaticContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Cardinality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IdentityConstraint
extends SchemaStructure
implements UserSchemaComponent,
SerializableSchemaComponent {
    private IdentitySelector selector = null;
    private List<IdentityField> fields = new ArrayList<IdentityField>(3);
    private int nameCode;

    protected IdentityConstraint() {
    }

    public void addField(IdentityField field) {
        if (field != null) {
            this.fields.add(field);
        }
    }

    public Iterator<IdentityField> iterateFields() {
        return this.fields.iterator();
    }

    public List<IdentityField> getFields() {
        return this.fields;
    }

    public String getName() {
        return this.getConfiguration().getNamePool().getLocalName(this.nameCode);
    }

    public String getTargetNamespace() {
        return this.getConfiguration().getNamePool().getURI(this.nameCode);
    }

    public IdentitySelector getSelector() {
        return this.selector;
    }

    public void setSelector(IdentitySelector selector) throws SchemaException {
        this.selector = selector;
    }

    public void setNameCode(int nc) {
        this.nameCode = nc;
    }

    public int getFingerprint() {
        return this.nameCode & 0xFFFFF;
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        this.setFixupStatus(3);
        return true;
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        String err = null;
        if (!compiler.getConfiguration().getNameChecker().isValidNCName(this.getName())) {
            err = "The name of an IdentityConstraint must be an NCName.";
        } else if (this.selector == null) {
            err = "Selector for IdentityConstraint cannot be null.";
        } else if (this.fields.size() < 1) {
            err = "There must be at least one field in an identity constraint.";
        }
        if (err != null) {
            compiler.error(err, this);
            return false;
        }
        return true;
    }

    public void typeCheck(final SchemaCompiler compiler, SchemaType contextType) throws XPathException {
        EnterpriseConfiguration config = compiler.getConfiguration();
        DedicatedStaticContext env = new DedicatedStaticContext(config){

            public void issueWarning(String s, SourceLocator locator) {
                compiler.warning(s, IdentityConstraint.this);
            }
        };
        ExpressionVisitor visitor = ExpressionVisitor.make(env, env.getExecutable());
        ContentTypeTest contextItemType = new ContentTypeTest(1, contextType, config);
        this.selector.getSelection().analyze(visitor, contextItemType);
        NodeTest selectorType = this.selector.getSelection().getNodeTest();
        for (int i = 0; i < this.fields.size(); ++i) {
            IdentityField field = this.fields.get(i);
            field.getSelection().analyze(visitor, selectorType);
            int card = field.getCardinality(visitor, selectorType);
            if (Cardinality.allowsMany(card)) {
                compiler.warning("The field expression may select multiple nodes, which would make the instance document invalid", field);
                continue;
            }
            if (this instanceof Key && Cardinality.allowsZero(card)) {
                compiler.warning("The field expression may select no nodes, which would make the instance document invalid", field);
                continue;
            }
            NodeTest fieldType = field.getSelection().getNodeTest();
            SchemaType contentType = fieldType.getContentType();
            if (contentType == AnyType.getInstance() || contentType.isSimpleType() || contentType.isComplexType() && ((ComplexType)contentType).isSimpleContent()) continue;
            compiler.warning("The node selected by the field expression must have a simple type, or a complex type with simple content", field);
        }
    }

    @Override
    public void elaborate(SchemaCompiler compiler) throws SchemaException {
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        serializer.setIsSerialized(this);
        String kind = null;
        if (this instanceof Key) {
            kind = "key";
        } else if (this instanceof Unique) {
            kind = "unique";
        } else if (this instanceof KeyRef) {
            kind = "keyref";
        }
        serializer.startElement(kind);
        serializer.emitAttribute("id", serializer.getId(this, false));
        serializer.emitAttribute("name", this.getName());
        if (this.getTargetNamespace() != null) {
            serializer.emitAttribute("targetNamespace", this.getTargetNamespace());
        }
        if (this instanceof KeyRef) {
            IdentityConstraint target = (IdentityConstraint)((KeyRef)this).getTarget();
            serializer.emitAttribute("key", serializer.getId(target, false));
        }
        serializer.startElement("selector");
        serializer.emitNamespaceContext(this.selector.getNamespaceContext());
        serializer.emitAttribute("xpath", this.selector.getXPath());
        serializer.emitAttribute("defaultNamespace", this.selector.getXPathDefaultNamespace());
        serializer.endElement();
        for (int i = 0; i < this.fields.size(); ++i) {
            IdentityField f = this.fields.get(i);
            serializer.startElement("field");
            serializer.emitNamespaceContext(f.getNamespaceContext());
            serializer.emitAttribute("xpath", f.getXPath());
            serializer.emitAttribute("defaultNamespace", f.getXPathDefaultNamespace());
            serializer.endElement();
        }
        serializer.endElement();
    }
}

