/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.Facet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.UserAtomicType;
import com.saxonica.schema.UserSimpleType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;

public class ExplicitTimezoneFacet
extends Facet {
    public static final int OPTIONAL = 0;
    public static final int REQUIRED = 1;
    public static final int PROHIBITED = 2;
    int facetValue;

    public String getName() {
        return "explicitTimezone";
    }

    public String getValue() {
        switch (this.facetValue) {
            case 1: {
                return "required";
            }
            case 0: {
                return "optional";
            }
        }
        return "prohibited";
    }

    public void setValue(String value) throws SchemaException {
        if (value.equals("required")) {
            this.facetValue = 1;
        } else if (value.equals("optional")) {
            this.facetValue = 0;
        } else if (value.equals("prohibited")) {
            this.facetValue = 2;
        } else {
            throw new SchemaException("Value of explicitTimezone facet must be required, optional, or prohibited");
        }
    }

    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException {
        if (base instanceof UserAtomicType) {
            UserAtomicType ubase = (UserAtomicType)base;
            ExplicitTimezoneFacet baseFacet = (ExplicitTimezoneFacet)ubase.getFacet(ExplicitTimezoneFacet.class);
            if (baseFacet != null) {
                if (baseFacet.isFixed() && this.facetValue != baseFacet.facetValue) {
                    throw new SchemaException("The explicitTimezone facet is fixed in the base type and cannot be varied");
                }
                if (baseFacet.facetValue == 2 && this.facetValue != 2) {
                    throw new SchemaException("The explicitTimezone is prohibited in the base type so it must be prohibited in the derived type");
                }
                if (baseFacet.facetValue == 1 && this.facetValue != 1) {
                    throw new SchemaException("The explicitTimezone is required in the base type so it must be required in the derived type");
                }
            }
        } else if (base.getFingerprint() == 565 && this.facetValue != 1) {
            throw new SchemaException("The explicitTimezone is required in the base type so it must be required in the derived type");
        }
    }

    public boolean testAtomicValue(AtomicValue value) {
        if (this.facetValue != 0) {
            if (value instanceof CalendarValue) {
                boolean hasTimezone = ((CalendarValue)value).hasTimezone();
                return this.facetValue == 1 ? hasTimezone : !hasTimezone;
            }
            return false;
        }
        return true;
    }
}

