/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.schema.Facet;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.UserSimpleType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.Value;

public class EnumerationFacetSet
extends Facet {
    HashSet<Comparable> allowedValues = new HashSet(20);
    List<Value> allowedTypedValues = new ArrayList<Value>(20);
    List<String> stringValues = new ArrayList<String>(20);

    public String getName() {
        return "enumeration";
    }

    public void addEnumerationValue(Value val, String stringValue) {
        this.allowedTypedValues.add(val);
        this.allowedValues.add(val.getSchemaComparable());
        this.stringValues.add(stringValue);
    }

    public String getValue() {
        FastStringBuffer sb = new FastStringBuffer(64);
        for (Value v : this.allowedTypedValues) {
            try {
                sb.append(v.getStringValue());
            }
            catch (XPathException e) {
                sb.append("**ERROR-VALUE**");
            }
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException {
    }

    public boolean testAtomicValue(AtomicValue value) {
        return this.allowedValues.contains(value.getSchemaComparable());
    }

    public boolean testListValue(Value value) {
        return this.allowedValues.contains(value.getSchemaComparable());
    }

    public String getSharedInstance(String value) {
        for (String s : this.stringValues) {
            if (!s.equals(value)) continue;
            return s;
        }
        return value;
    }

    public void serializeFacet(SchemaModelSerializer serializer) throws XPathException {
        for (Value v : this.allowedTypedValues) {
            AtomicValue av;
            serializer.startElement("enumeration");
            boolean namespaceSensitive = false;
            SequenceIterator iter = v.iterate();
            while ((av = (AtomicValue)iter.next()) != null) {
                if (!(av instanceof QualifiedNameValue)) continue;
                String prefix = ((QualifiedNameValue)av).getPrefix();
                String uri = ((QualifiedNameValue)av).getNamespaceURI();
                serializer.declareNamespace(prefix, uri);
                namespaceSensitive = true;
            }
            serializer.emitAttribute("value", v.getStringValue());
            if (namespaceSensitive) {
                serializer.emitAttribute("namespaceSensitive", "true");
            }
            serializer.endElement();
        }
    }
}

