/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.ElementDecl;
import com.saxonica.schema.ModelGroup;
import com.saxonica.schema.Particle;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.Term;
import com.saxonica.schema.Wildcard;
import net.sf.saxon.expr.sort.IntHashSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UnresolvedReferenceException;

public class ElementWildcard
extends Particle {
    private Wildcard wildcard;

    public ElementWildcard(EnterpriseConfiguration config) {
        this.wildcard = new Wildcard();
        this.wildcard.setConfiguration(config);
        this.setConfiguration(config);
    }

    public ElementWildcard copy() {
        ElementWildcard e = new ElementWildcard(this.getConfiguration());
        e.wildcard = this.wildcard;
        e.setMinOccurs(this.getMinOccurs());
        e.setMaxOccurs(this.getMaxOccurs());
        return e;
    }

    public ElementWildcard(Wildcard wc) {
        this.wildcard = wc;
    }

    public void setWildcard(Wildcard wildcard) {
        this.wildcard = wildcard;
    }

    public Wildcard getWildcard() {
        return this.wildcard;
    }

    public boolean isEmptiable() {
        return this.getMinOccurs() == 0;
    }

    public boolean isPointless(ModelGroup container) {
        return false;
    }

    public Term getTerm() {
        return this.wildcard;
    }

    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        this.setFixupStatus(3);
        return true;
    }

    public void compile(SchemaCompiler compiler) throws SchemaException {
    }

    public SchemaType getElementParticleType(int fingerprint) {
        EnterpriseConfiguration config = this.getConfiguration();
        if (this.wildcard.matches(fingerprint, true, config, null)) {
            if (this.wildcard.getProcessContents().equals("skip")) {
                return AnyType.getInstance();
            }
            if (this.wildcard.getProcessContents().equals("strict")) {
                ElementDecl decl = this.getConfiguration().getSuperSchema().getElementDecl(fingerprint);
                if (decl == null) {
                    return null;
                }
                try {
                    return decl.getType();
                }
                catch (UnresolvedReferenceException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            ElementDecl decl = this.getConfiguration().getSuperSchema().getElementDecl(fingerprint);
            if (decl == null) {
                return AnyType.getInstance();
            }
            try {
                return decl.getType();
            }
            catch (UnresolvedReferenceException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        return null;
    }

    public int getElementParticleCardinality(int fingerprint) {
        EnterpriseConfiguration config = this.getConfiguration();
        if (this.wildcard.matches(fingerprint, true, config, null)) {
            return Particle.computeParticleCardinality(this.getMinOccurs(), this.getMaxOccurs());
        }
        return 8192;
    }

    public boolean containsElementWildcard() {
        return true;
    }

    public void gatherAllPermittedElements(IntHashSet result, boolean ignoreWildcards) throws SchemaException {
        if (!ignoreWildcards) {
            result.add(-1);
        }
    }

    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        return this.wildcard.validate(compiler);
    }

    public void serializeParticle(SchemaModelSerializer serializer) throws XPathException {
        String id = serializer.getId(this.wildcard, false);
        serializer.startElement("elementWildcard");
        serializer.emitAttribute("minOccurs", "" + this.getMinOccurs());
        serializer.emitAttribute("maxOccurs", this.getMaxOccurs() < 0 ? "unbounded" : "" + this.getMaxOccurs());
        serializer.emitAttribute("ref", id);
        serializer.endElement();
    }
}

