/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.IdentityConstraint;
import com.saxonica.schema.IdentityConstraintReference;
import com.saxonica.schema.Key;
import com.saxonica.schema.KeyRef;
import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.SchemaStructure;
import com.saxonica.schema.SerializableSchemaComponent;
import com.saxonica.schema.SimpleComponentReference;
import com.saxonica.schema.Term;
import com.saxonica.schema.TypeAlternative;
import com.saxonica.schema.TypeReference;
import com.saxonica.schema.Unique;
import com.saxonica.schema.UserComplexType;
import com.saxonica.schema.UserDefinedType;
import com.saxonica.schema.UserSchemaComponent;
import com.saxonica.schema.UserSimpleType;
import com.saxonica.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.validate.SchemaElementTest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementDecl
extends SchemaStructure
implements UserSchemaComponent,
SerializableSchemaComponent,
SchemaDeclaration,
Term {
    private int block = 0;
    private UserComplexType containingComplexType = null;
    private List<IdentityConstraintReference> constraintRefs = null;
    private String defaultValue = null;
    private int finalProhibitions = 0;
    private Value fixed = null;
    private String fixedLexicalRepresentation = null;
    private Comparable fixedValueComparable = null;
    private boolean global;
    private boolean isAbstract = false;
    private int nameCode = -1;
    private NamespaceResolver namespaceResolver;
    private boolean nillable = false;
    private List<SimpleComponentReference> substitutionGroupOwners = null;
    private Set<ElementDecl> substitutionGroupMembers = new HashSet<ElementDecl>(10);
    private String targetNamespace;
    private TypeReference typeReference = null;
    private HashSet<UserComplexType> complexTypesUsingThisElement = new HashSet(20);
    private List<TypeAlternative> typeAlternatives = null;

    public ElementDecl(EnterpriseConfiguration config, boolean global, SourceLocator locator) {
        this.setLocator(locator);
        this.global = global;
        this.setConfiguration(config);
        this.constraintRefs = new ArrayList<IdentityConstraintReference>(3);
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.namespaceResolver = resolver;
    }

    public void addIdentityConstraint(IdentityConstraintReference constraint) {
        if (constraint == null) {
            return;
        }
        this.constraintRefs.add(constraint);
    }

    public void setContainingComplexType(UserComplexType type) {
        this.containingComplexType = type;
    }

    public int getBlock() {
        return this.block;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public int getSubstitutionGroupExclusions() {
        return this.finalProhibitions;
    }

    public boolean allowsDerivation(int derivation) {
        return (this.finalProhibitions & derivation) == 0;
    }

    public UserComplexType getContainingComplexType() {
        return this.containingComplexType;
    }

    public Value getFixedValue() {
        return this.fixed;
    }

    public String getFixedValueLexicalRepresentation() {
        return this.fixedLexicalRepresentation;
    }

    public Comparable getFixedValueComparable() {
        return this.fixedValueComparable;
    }

    public Iterator<IdentityConstraintReference> getIdentityConstraints() {
        return this.constraintRefs.iterator();
    }

    public String getDisplayName() {
        return this.getConfiguration().getNamePool().getClarkName(this.nameCode);
    }

    public String getName() {
        if (this.nameCode == -1) {
            return null;
        }
        return this.getConfiguration().getNamePool().getLocalName(this.nameCode);
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getNamespaceURI() {
        return this.targetNamespace;
    }

    public int getTypeFingerprint() {
        if (this.typeReference != null) {
            return this.typeReference.getFingerprint();
        }
        return -1;
    }

    @Override
    public SchemaType getType() throws UnresolvedReferenceException {
        if (this.typeReference == null) {
            return AnyType.getInstance();
        }
        SchemaType schemaType = (SchemaType)this.typeReference.getTarget();
        if (schemaType instanceof SimpleTypeDefinition) {
            schemaType = ((SimpleTypeDefinition)schemaType).getSimpleType();
            this.typeReference.setTarget(schemaType);
        }
        return schemaType;
    }

    public Set<ElementDecl> getSubstitutionGroupOwners() throws UnresolvedReferenceException {
        if (this.substitutionGroupOwners != null) {
            HashSet<ElementDecl> heads = new HashSet<ElementDecl>(this.substitutionGroupOwners.size());
            for (SimpleComponentReference headRef : this.substitutionGroupOwners) {
                heads.add((ElementDecl)headRef.getTarget());
            }
            return heads;
        }
        return null;
    }

    public void gatherSubstititionGroupOwnersTransitively(Set<ElementDecl> headSet) {
        if (!headSet.contains(this)) {
            headSet.add(this);
            if (this.substitutionGroupOwners != null) {
                for (SimpleComponentReference headRef : this.substitutionGroupOwners) {
                    ((ElementDecl)headRef.getTarget()).gatherSubstititionGroupOwnersTransitively(headSet);
                }
            }
        }
    }

    public Set<ElementDecl> getSubstitutionGroupMembers() {
        return this.substitutionGroupMembers;
    }

    public synchronized void addSubstitutionGroupMember(ElementDecl member, SchemaCompiler compiler) throws SchemaException {
        if (!this.substitutionGroupMembers.contains(member)) {
            EnterpriseConfiguration config = this.getConfiguration();
            if (member != this) {
                member.fixup(compiler);
                String reason = member.isValidlySubstitutable(this);
                if (reason != null) {
                    String msg;
                    block9: {
                        String memberName = compiler.getNamePool().getDisplayName(member.getNameCode());
                        msg = "Element " + Err.wrap(memberName, 1) + " cannot participate in the substitution group of element " + Err.wrap(this.getName(), 1) + ": " + reason;
                        try {
                            Set<ElementDecl> grandFathers = this.getSubstitutionGroupOwners();
                            if (grandFathers == null) break block9;
                            for (ElementDecl grandFather : grandFathers) {
                                if (member.isValidlySubstitutable(grandFather) != null) continue;
                                msg = msg + ". However, element " + Err.wrap(memberName, 1) + " can substitute for element " + Err.wrap(compiler.getNamePool().getDisplayName(grandFather.getNameCode()), 1);
                                break;
                            }
                        }
                        catch (UnresolvedReferenceException err) {
                            // empty catch block
                        }
                    }
                    compiler.warning(msg, member);
                    return;
                }
            }
            if (member != this && config.isSealedNamespace(this.getTargetNamespace())) {
                String msg = "It is not possible to add to the substitution group of element " + this.getName() + " in namespace '" + this.getTargetNamespace() + "', because the schema for that namespace has already been used for validating instance documents," + " or for compiling queries or stylesheets";
                SchemaException err = new SchemaException(msg);
                err.setLocator(member);
                throw err;
            }
            this.substitutionGroupMembers.add(member);
            if (member != this) {
                for (UserComplexType type : this.complexTypesUsingThisElement) {
                    type.recompile(compiler);
                }
            }
        }
    }

    public synchronized void registerComplexTypeUsingThisElement(UserComplexType type) {
        this.complexTypesUsingThisElement.add(type);
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isNillable() {
        return this.nillable;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setBlock(int block) {
        this.block = block;
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    public void setFinalProhibitions(int finalValue) {
        this.finalProhibitions = finalValue;
    }

    public void setFixedValue(Value value) {
        this.fixed = value;
        if (value != null) {
            this.fixedLexicalRepresentation = ((Object)value.getCanonicalLexicalRepresentation()).toString();
            this.fixedValueComparable = value.getSchemaComparable();
        }
    }

    public void setNillable(boolean nillable) {
        this.nillable = nillable;
    }

    public void setNameCode(int nameCode) {
        this.nameCode = nameCode;
        this.targetNamespace = this.getConfiguration().getNamePool().getURI(nameCode);
        this.substitutionGroupMembers.add(this);
    }

    @Override
    public int getFingerprint() {
        return this.nameCode & 0xFFFFF;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public void addSubstitutionGroupHead(int nameCode) {
        if (this.substitutionGroupOwners == null) {
            this.substitutionGroupOwners = new ArrayList<SimpleComponentReference>(2);
        }
        SimpleComponentReference headRef = new SimpleComponentReference(801, nameCode, this.getConfiguration());
        headRef.setLocator(this);
        this.substitutionGroupOwners.add(headRef);
    }

    public Iterator<ElementDecl> iterateSubstitutionGroup() {
        return this.substitutionGroupMembers.iterator();
    }

    public void setTypeReference(TypeReference type) {
        this.typeReference = type;
    }

    public void addTypeAlternative(TypeAlternative alternative) {
        if (this.typeAlternatives == null) {
            this.typeAlternatives = new ArrayList<TypeAlternative>(5);
        }
        this.typeAlternatives.add(alternative);
    }

    public boolean hasTypeAlternatives() {
        return this.typeAlternatives != null;
    }

    public Iterator<TypeAlternative> iterateTypeAlternatives() {
        return this.typeAlternatives.iterator();
    }

    @Override
    public void lookForCycles(Stack references, SchemaCompiler compiler) throws SchemaException, UnresolvedReferenceException {
        for (int i = 0; i < references.size(); ++i) {
            ElementDecl member = (ElementDecl)references.get(i);
            if (member == this) {
                compiler.error("Element declaration " + this.getDisplayName() + " participates in a substitution group whose definition is circular", this);
                throw new SchemaException("Circular definition found");
            }
            this.addSubstitutionGroupMember(member, compiler);
        }
        if (this.substitutionGroupOwners != null) {
            references.push(this);
            for (SimpleComponentReference headRef : this.substitutionGroupOwners) {
                headRef.tryToResolve(compiler);
                if (!headRef.isResolved()) continue;
                ElementDecl head = (ElementDecl)headRef.getTarget();
                head.lookForCycles(references, compiler);
            }
            references.pop();
        }
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException, UnresolvedReferenceException {
        boolean result = true;
        if (this.getFixupStatus() == 0) {
            this.setFixupStatus(2);
            if (this.substitutionGroupOwners != null) {
                for (SimpleComponentReference headRef : this.substitutionGroupOwners) {
                    ElementDecl decl = (ElementDecl)PreparedSchema.validateReference(headRef, compiler);
                    if (decl == null) {
                        this.setFixupStatus(4);
                        return false;
                    }
                    result = decl.fixup(compiler);
                }
            }
            if (this.typeReference != null) {
                SchemaType type = (SchemaType)PreparedSchema.validateReference(this.typeReference, compiler);
                if (type == null) {
                    this.setFixupStatus(4);
                    return false;
                }
                if (type instanceof UserSchemaComponent) {
                    result &= ((UserSchemaComponent)((Object)type)).fixup(compiler);
                }
            }
            if (this.hasTypeAlternatives()) {
                Iterator<TypeAlternative> alt = this.iterateTypeAlternatives();
                while (alt.hasNext()) {
                    TypeAlternative ta = alt.next();
                    result &= ta.fixup(compiler);
                }
            }
            for (IdentityConstraintReference icr : this.constraintRefs) {
                icr.tryToResolve(compiler);
            }
        }
        this.setFixupStatus(result ? 3 : 4);
        return result;
    }

    @Override
    public NodeTest makeSchemaNodeTest() {
        return new SchemaElementTest(this);
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        SchemaType type;
        switch (this.getValidationStatus()) {
            case 3: 
            case 4: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        this.setValidationStatus(2);
        boolean result = true;
        boolean checkFirstSubstitutionGroup = true;
        if (this.typeReference != null) {
            this.typeReference.tryToResolve(compiler);
        } else if (this.substitutionGroupOwners != null) {
            ElementDecl head = (ElementDecl)PreparedSchema.validateReference(this.substitutionGroupOwners.get(0), compiler);
            SchemaType headType = head.getType();
            this.typeReference = new TypeReference(headType.getFingerprint(), this.getConfiguration(), this);
            this.typeReference.setTarget(headType);
            checkFirstSubstitutionGroup = false;
        }
        if (this.typeReference != null) {
            PreparedSchema.validateReference(this.typeReference, compiler);
            if (!this.typeReference.isResolved()) {
                this.setValidationStatus(4);
                return false;
            }
        }
        if ((type = this.getType()) != null) {
            if (type.isComplexType()) {
                if (type instanceof UserComplexType) {
                    result = ((UserComplexType)type).validate(compiler);
                }
            } else if (type.isSimpleType()) {
                SimpleType simpleType = (SimpleType)type;
                if (simpleType instanceof UserSimpleType) {
                    result = ((UserSimpleType)simpleType).validate(compiler);
                }
                if (result && compiler.getLanguageVersion() == 10 && (this.getFixedValue() != null || this.getDefaultValue() != null) && simpleType.getBuiltInBaseType().getFingerprint() == 560) {
                    compiler.error("An element of type xs:ID must have no fixed or default value", this);
                    result = false;
                }
            }
            if (this.getFixedValue() != null) {
                try {
                    result &= this.validateSimpleValue(type, "fixed", compiler);
                }
                catch (ValidationException err) {
                    throw new SchemaException(err);
                }
            }
            if (this.getDefaultValue() != null) {
                try {
                    result &= this.validateSimpleValue(type, "default", compiler);
                }
                catch (ValidationException err) {
                    throw new SchemaException(err);
                }
            }
            boolean first = true;
            if (this.substitutionGroupOwners != null && checkFirstSubstitutionGroup) {
                for (SimpleComponentReference headRef : this.substitutionGroupOwners) {
                    if (checkFirstSubstitutionGroup || !first) {
                        ElementDecl head = (ElementDecl)PreparedSchema.validateReference(headRef, compiler);
                        SchemaType headType = head.getType();
                        try {
                            compiler.getConfiguration().checkTypeDerivationIsOK(type, headType, head.finalProhibitions);
                        }
                        catch (SchemaException err) {
                            compiler.error("Element " + this.getDisplayName() + " cannot be in the substitution group of " + head.getDisplayName() + ". " + err.getMessage(), this);
                            result = false;
                        }
                    }
                    if (compiler.getLanguageVersion() == 10 && !first) {
                        compiler.error("In XML Schema 1.0, an element can participate in one substitution group only", this);
                    }
                    first = false;
                }
            }
            for (int i = 0; i < this.constraintRefs.size(); ++i) {
                compiler.addPendingTypeCheck(this.constraintRefs.get(i), type);
            }
        }
        if (this.hasTypeAlternatives()) {
            Iterator<TypeAlternative> alt = this.iterateTypeAlternatives();
            while (alt.hasNext()) {
                TypeAlternative ta = alt.next();
                SchemaType altType = ta.getSchemaType();
                if (altType instanceof UserDefinedType) {
                    result &= ((UserSchemaComponent)((Object)altType)).validate(compiler);
                }
                if (altType == ErrorType.getInstance()) continue;
                try {
                    compiler.getConfiguration().checkTypeDerivationIsOK(altType, type, this.finalProhibitions);
                }
                catch (SchemaException err) {
                    compiler.error("Invalid alternative type. " + err.getMessage(), ta);
                    result = false;
                }
            }
        }
        for (IdentityConstraintReference icr : this.constraintRefs) {
            icr.tryToResolve(compiler);
            if (!icr.isResolved()) {
                compiler.error("Cannot resolve integrity constraint reference " + compiler.getNamePool().getDisplayName(icr.getFingerprint()), this);
                return false;
            }
            IdentityConstraint ic = icr.getTarget();
            switch (icr.getExpectedKindOfConstraint()) {
                case 625: {
                    if (ic instanceof Unique) break;
                    compiler.error("Target of xs:unique reference must be an xs:unique element", icr);
                    result = false;
                    break;
                }
                case 599: {
                    if (ic instanceof Key) break;
                    compiler.error("Target of xs:key reference must be an xs:key element", icr);
                    result = false;
                    break;
                }
                case 600: {
                    if (ic instanceof KeyRef) break;
                    compiler.error("Target of xs:keyref reference must be an xs:keyref element", icr);
                    result = false;
                }
            }
        }
        this.setValidationStatus(result ? 3 : 4);
        return result;
    }

    private String isValidlySubstitutable(ElementDecl other) {
        int block = other.getBlock();
        if (this == other) {
            return null;
        }
        if ((block & 0x10) != 0) {
            return "substitution has been blocked";
        }
        boolean found = false;
        HashSet<ElementDecl> unsearched = new HashSet<ElementDecl>(4);
        unsearched.add(this);
        while (!unsearched.isEmpty()) {
            if (unsearched.contains(other)) {
                found = true;
                break;
            }
            ElementDecl first = (ElementDecl)unsearched.iterator().next();
            unsearched.remove(first);
            unsearched.addAll(first.getSubstitutionGroupOwners());
        }
        if (!found) {
            return "element declaration is not a member of the substitution group";
        }
        int actualDerivations = 0;
        int prohibitedDerivations = block;
        SchemaType t = this.getType();
        while (t != null && t != AnyType.getInstance() && !t.isSameType(other.getType())) {
            actualDerivations |= t.getDerivationMethod();
            t = t.getBaseType();
            prohibitedDerivations |= t.getBlock();
        }
        if ((actualDerivations & prohibitedDerivations) != 0) {
            return "required type derivation method (extension or restriction) has been blocked";
        }
        return null;
    }

    private boolean validateSimpleValue(SchemaType type, String property, SchemaCompiler compiler) throws SchemaException, ValidationException {
        String val;
        SimpleType simpleType;
        if (type.isSimpleType()) {
            simpleType = (SimpleType)type;
        } else if (((ComplexType)type).isSimpleContent()) {
            simpleType = ((ComplexType)type).getSimpleContentType();
        } else if (((ComplexType)type).isMixedContent()) {
            if (!((ComplexType)type).isEmptiable()) {
                compiler.error("An element with mixed content may have a " + property + " value only if its type is emptiable", this);
                return false;
            }
            simpleType = BuiltInAtomicType.STRING;
        } else {
            compiler.error("An element with a " + property + " value must have simple or mixed content", this);
            return false;
        }
        if (property.equals("fixed")) {
            try {
                val = this.getFixedValue().getStringValue();
            }
            catch (XPathException e) {
                throw new IllegalStateException();
            }
        } else {
            val = this.getDefaultValue();
        }
        try {
            if (simpleType instanceof SimpleTypeDefinition) {
                boolean result = ((SimpleTypeDefinition)simpleType).validate(compiler);
                if (!result) {
                    return false;
                }
                simpleType = ((SimpleTypeDefinition)simpleType).getSimpleType();
            }
            if (property.equals("fixed")) {
                if (!this.makeFixedValueTyped(val, simpleType, compiler)) {
                    return false;
                }
            } else {
                String nval = ((Object)Whitespace.applyWhitespaceNormalization(simpleType.getWhitespaceAction(), val)).toString();
                ValidationFailure err = simpleType.validateContent(val, this.namespaceResolver, compiler.getConfiguration().getConversionRules());
                if (err != null) {
                    compiler.error("The " + Err.wrap(property, 2) + " value " + Err.wrap(val, 4) + " does not not conform to the element's content type: " + err.getMessage(), this);
                    return false;
                }
                this.setDefaultValue(nval);
            }
        }
        catch (ValidationException err) {
            compiler.error("The " + Err.wrap(property, 2) + " value " + Err.wrap(val, 4) + " does not not conform to the element's content type", this);
            return false;
        }
        return true;
    }

    private boolean makeFixedValueTyped(String val, SimpleType simpleType, SchemaCompiler compiler) throws SchemaException, ValidationException {
        ConversionRules rules = this.getConfiguration().getConversionRules();
        String nval = ((Object)Whitespace.applyWhitespaceNormalization(simpleType.getWhitespaceAction(), val)).toString();
        ValidationFailure err = simpleType.validateContent(val, this.namespaceResolver, rules);
        if (err != null) {
            compiler.error("The fixed value " + Err.wrap(val, 4) + " does not not conform to the element's content type: " + err.getMessage(), this);
            return false;
        }
        SequenceIterator iter = simpleType.getTypedValue(nval, this.namespaceResolver, rules);
        try {
            if (simpleType.isAtomicType()) {
                this.setFixedValue((AtomicValue)iter.next());
            } else {
                this.setFixedValue((Value)SequenceExtent.makeSequenceExtent(iter));
            }
        }
        catch (XPathException e) {
            throw new IllegalStateException("Internal error while evaluating fixed value");
        }
        return true;
    }

    protected void fixupSubstitutionGroup(SchemaCompiler compiler) throws SchemaException, ValidationException {
        if (this.substitutionGroupOwners != null) {
            for (SimpleComponentReference headRef : this.substitutionGroupOwners) {
                ElementDecl head = (ElementDecl)PreparedSchema.validateReference(headRef, compiler);
                if (head != null) continue;
                String err = "Element " + Err.wrap(compiler.getNamePool().getDisplayName(headRef.getFingerprint()), 1) + " is referenced as head of a substitution group for " + Err.wrap(this.getDisplayName()) + ", but is not declared in the schema";
                throw new SchemaException(err);
            }
            this.lookForCycles(new Stack(), compiler);
        }
    }

    public boolean isSameDeclaration(ElementDecl other) {
        return this == other || this.getFingerprint() == other.getFingerprint() && this.isGlobal() == other.isGlobal() && this.getContainingComplexType() == other.getContainingComplexType() && this.getLineNumber() == other.getLineNumber() && this.getColumnNumber() == other.getColumnNumber() && this.getSystemId().equals(other.getSystemId());
    }

    public boolean hasSameTypeTable(ElementDecl other) {
        if (this.isSameDeclaration(other)) {
            return true;
        }
        if (this.typeAlternatives == null && other.typeAlternatives == null) {
            return true;
        }
        if (this.typeAlternatives == null || other.typeAlternatives == null) {
            return false;
        }
        if (this.typeAlternatives.size() != other.typeAlternatives.size()) {
            return false;
        }
        if (!this.getType().isSameType(other.getType())) {
            return false;
        }
        for (int i = 0; i < this.typeAlternatives.size(); ++i) {
            TypeAlternative a0 = this.typeAlternatives.get(i);
            TypeAlternative a1 = other.typeAlternatives.get(i);
            if (!a0.getCondition().getInternalExpression().equals(a1.getCondition().getInternalExpression())) {
                return false;
            }
            if (!a0.getDefaultElementNamespace().equals(a1.getDefaultElementNamespace())) {
                return false;
            }
            if (!a0.getBaseURI().equals(a1.getBaseURI())) {
                return false;
            }
            if (!a0.getSchemaType().isSameType(a1.getSchemaType())) {
                return false;
            }
            HashSet<String> prefixes0 = new HashSet<String>();
            Iterator<String> it = a0.getNamespaceContext().iteratePrefixes();
            while (it.hasNext()) {
                prefixes0.add(it.next());
            }
            it = a1.getNamespaceContext().iteratePrefixes();
            while (it.hasNext()) {
                String prefix = it.next();
                if (prefixes0.contains(prefix)) continue;
                return false;
            }
            for (String p : prefixes0) {
                if (a0.getNamespaceContext().getURIForPrefix(p, false).equals(a1.getNamespaceContext().getURIForPrefix(p, false))) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "ElementDeclaration " + this.getName();
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        String id = serializer.getId(this, true);
        serializer.startElement("element");
        serializer.emitAttribute("id", id);
        if (this.getName() != null) {
            serializer.emitAttribute("name", this.getName());
            if (this.getTargetNamespace() != null && this.getTargetNamespace().length() > 0) {
                serializer.emitAttribute("targetNamespace", this.getTargetNamespace());
            }
        }
        serializer.emitAttribute("type", serializer.getTypeLink(this.getType()));
        serializer.emitAttribute("global", this.isGlobal() ? "true" : "false");
        if (!this.isGlobal() && this.getContainingComplexType() != null) {
            serializer.emitAttribute("containingComplexType", serializer.getId(this.getContainingComplexType(), false));
        }
        if (this.getDefaultValue() != null) {
            serializer.emitAttribute("default", this.getDefaultValue());
        }
        serializer.emitAttribute("nillable", this.isNillable() ? "true" : "false");
        if (this.finalProhibitions != 0) {
            String ex = "";
            if ((this.finalProhibitions & 2) != 0) {
                ex = "extension";
            }
            if ((this.finalProhibitions & 1) != 0) {
                ex = ex + (ex.length() == 0 ? "" : " ") + "restriction";
            }
            serializer.emitAttribute("final", ex);
        }
        if (this.block != 0) {
            String dis = "";
            if ((this.block & 2) != 0) {
                dis = "extension";
            }
            if ((this.block & 1) != 0) {
                dis = dis + (dis.length() == 0 ? "" : " ") + "restriction";
            }
            if ((this.block & 0x10) != 0) {
                dis = dis + (dis.length() == 0 ? "" : " ") + "substitution";
            }
            serializer.emitAttribute("block", dis);
        }
        serializer.emitAttribute("abstract", this.isAbstract ? "true" : "false");
        if (this.substitutionGroupOwners != null) {
            for (SimpleComponentReference headRef : this.substitutionGroupOwners) {
                serializer.startElement("substitutionGroupAffiliation");
                serializer.emitAttribute("ref", serializer.getId(headRef.getTarget(), false));
                serializer.endElement();
            }
        }
        if (this.hasTypeAlternatives()) {
            Iterator<TypeAlternative> iter = this.iterateTypeAlternatives();
            while (iter.hasNext()) {
                TypeAlternative alt = iter.next();
                alt.serialize(serializer);
            }
        }
        Iterator<IdentityConstraintReference> idConstraints = this.getIdentityConstraints();
        while (idConstraints.hasNext()) {
            IdentityConstraintReference icr = idConstraints.next();
            serializer.startElement("identityConstraint");
            serializer.emitAttribute("ref", serializer.getId(icr.getTarget(), false));
            serializer.endElement();
        }
        if (this.getFixedValue() != null) {
            serializer.startElement("fixed");
            serializer.emitTypedValue(this.getFixedValue());
            serializer.endElement();
        }
        serializer.endElement();
    }
}

