/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.AttributeDecl;
import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.SimpleComponentReference;
import com.saxonica.schema.UserSchemaComponent;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public final class AttributeUse
extends SimpleComponentReference
implements UserSchemaComponent {
    private short useFlag = (short)3;
    private Value fixedValue = null;
    private String defaultValue = null;
    private NamespaceResolver namespaceResolver;
    private int inheritable = -1;
    public static final short OPTIONAL = 3;
    public static final short PROHIBITED = 4;
    public static final short REQUIRED = 5;

    public AttributeUse(EnterpriseConfiguration config) {
        this.setConfiguration(config);
        this.symbolSpace = 802;
    }

    public AttributeDecl getAttributeDeclaration() throws UnresolvedReferenceException {
        return (AttributeDecl)this.getTarget();
    }

    public String getDisplayName() {
        return this.getConfiguration().getNamePool().getDisplayName(this.getFingerprint());
    }

    public String getUse() {
        switch (this.useFlag) {
            case 4: {
                return "prohibited";
            }
            case 5: {
                return "required";
            }
        }
        return "optional";
    }

    public int getCardinality() {
        switch (this.useFlag) {
            case 4: {
                return 8192;
            }
            case 5: {
                return 16384;
            }
        }
        return 24576;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getUnderlyingDefaultValue() {
        if (this.defaultValue == null) {
            AttributeDecl declaration = (AttributeDecl)this.getTarget();
            if (declaration != null) {
                return declaration.getDefaultValue();
            }
            return null;
        }
        return this.defaultValue;
    }

    public Value getFixedValue() {
        return this.fixedValue;
    }

    public Value getUnderlyingFixedValue() {
        if (this.fixedValue == null) {
            AttributeDecl declaration = (AttributeDecl)this.getTarget();
            if (declaration != null) {
                return declaration.getFixedValue();
            }
            return null;
        }
        return this.fixedValue;
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.namespaceResolver = resolver;
    }

    public boolean testFixedValue(CharSequence value, NamespaceResolver resolver) throws ValidationException {
        AttributeDecl decl = (AttributeDecl)this.getTarget();
        Value fix = this.fixedValue;
        if (this.fixedValue == null && (fix = decl.getFixedValue()) == null) {
            return true;
        }
        EnterpriseConfiguration config = this.getConfiguration();
        SequenceIterator actual = decl.getSimpleType().getTypedValue(value, resolver, config.getConversionRules());
        try {
            return DeepEqual.deepEquals(fix.iterate(), actual, new GenericAtomicComparer(CodepointCollator.getInstance(), config.getConversionContext()), (Configuration)config, 0);
        }
        catch (XPathException err) {
            throw new AssertionError((Object)err);
        }
    }

    public boolean isOptional() {
        return this.useFlag == 3;
    }

    public boolean isProhibited() {
        return this.useFlag == 4;
    }

    public boolean isRequired() {
        return this.useFlag == 5;
    }

    public void setUse(short value) {
        this.useFlag = value;
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    public void setFixedValue(Value value) {
        this.fixedValue = value;
    }

    public void setInheritable(int inherit) {
        this.inheritable = inherit;
    }

    public boolean isInheritable() {
        switch (this.inheritable) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return ((AttributeDecl)this.getTarget()).isInheritable();
    }

    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        PreparedSchema.validateReference(this, compiler);
        this.setValidationStatus(3);
        return true;
    }

    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        Value fixedVal;
        this.tryToResolve(compiler);
        if (!this.isResolved()) {
            return false;
        }
        AttributeDecl declaration = (AttributeDecl)this.getTarget();
        boolean result = declaration.validate(compiler);
        if (!result) {
            return false;
        }
        SimpleType stype = declaration.getType();
        EnterpriseConfiguration config = compiler.getConfiguration();
        if (result && compiler.getLanguageVersion() == 10 && (this.getFixedValue() != null || this.getDefaultValue() != null) && stype.getBuiltInBaseType().getFingerprint() == 560) {
            compiler.error("An attribute of type xs:ID must have no fixed or default value", this);
            result = false;
            return result;
        }
        if (this.getFixedValue() != null) {
            result = this.makeFixedValueTyped(compiler, stype);
        }
        if (this.getDefaultValue() != null) {
            this.setDefaultValue(((Object)Whitespace.applyWhitespaceNormalization(stype.getWhitespaceAction(), this.getDefaultValue())).toString());
            ValidationFailure err = stype.validateContent(this.getDefaultValue(), this.namespaceResolver, config.getConversionRules());
            if (err != null) {
                compiler.error("Default value " + Err.wrap(this.getDefaultValue(), 4) + " does not not conform to the attribute's type: " + err.getMessage(), this);
                result = false;
            }
        }
        if (result && (fixedVal = declaration.getFixedValue()) != null) {
            if (this.getDefaultValue() != null) {
                String err = "An attribute reference " + Err.wrap(this.getDisplayName(), 2) + " cannot have a default value if the attribute declaration has a fixed value";
                compiler.error(err, this);
                return false;
            }
            Value thisFixedValue = this.getFixedValue();
            if (thisFixedValue != null && !thisFixedValue.getSchemaComparable().equals(fixedVal.getSchemaComparable())) {
                String err = "The attribute reference " + Err.wrap(this.getDisplayName(), 2) + " and the corresponding declaration have different fixed values";
                compiler.error(err, this);
                return false;
            }
        }
        return result;
    }

    private boolean makeFixedValueTyped(SchemaCompiler compiler, SimpleType stype) throws SchemaException {
        boolean result = true;
        EnterpriseConfiguration config = this.getConfiguration();
        ConversionRules rules = config.getConversionRules();
        ValidationFailure err = stype.validateContent(this.getFixedValue().getCanonicalLexicalRepresentation(), this.namespaceResolver, rules);
        if (err != null) {
            String val = Err.wrap(this.getFixedValue().getCanonicalLexicalRepresentation(), 4);
            compiler.error("Fixed value " + val + " does not not conform to the attribute's type: " + err.getMessage(), this);
            result = false;
        }
        if (result) {
            try {
                if (stype.isNamespaceSensitive()) {
                    this.setFixedValue((Value)SequenceExtent.makeSequenceExtent(stype.getTypedValue(this.getFixedValue().getStringValue(), this.namespaceResolver, rules)));
                } else if (stype.isAtomicType()) {
                    AtomicValue fv = ((AtomicValue)this.getFixedValue()).convert((AtomicType)stype, false, rules).asAtomic();
                    this.setFixedValue(fv);
                } else if (stype instanceof AnySimpleType) {
                    this.setFixedValue(new UntypedAtomicValue(this.getFixedValue().getStringValue()));
                } else if (this.getFixedValue() instanceof AtomicValue) {
                    this.setFixedValue((Value)SequenceExtent.makeSequenceExtent(stype.getTypedValue(this.getFixedValue().getStringValue(), null, rules)));
                }
            }
            catch (XPathException e) {
                compiler.error(e.getMessage(), this);
                result = false;
            }
        }
        return result;
    }

    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        if (!this.isProhibited()) {
            serializer.startElement("attributeUse");
            serializer.emitAttribute("required", this.isRequired() ? "true" : "false");
            serializer.emitAttribute("inheritable", this.isInheritable() ? "true" : "false");
            serializer.emitAttribute("ref", serializer.getId(this.getAttributeDeclaration(), false));
            if (this.getDefaultValue() != null) {
                serializer.emitAttribute("default", this.getDefaultValue());
            }
            if (this.getFixedValue() != null) {
                serializer.startElement("fixed");
                serializer.emitTypedValue(this.getFixedValue());
                serializer.endElement();
            }
            serializer.endElement();
        }
    }
}

