/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.AttributeGroupDecl;
import com.saxonica.schema.AttributeWildcard;
import com.saxonica.schema.ComponentReference;
import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaStructure;
import com.saxonica.schema.UnresolvedReferenceExceptionImpl;
import com.saxonica.schema.UserSchemaComponent;
import java.util.Stack;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.UnresolvedReferenceException;

public final class AttributeGroupReference
extends SchemaStructure
implements ComponentReference,
UserSchemaComponent {
    private int fingerprint;
    private AttributeGroupDecl target;

    public AttributeGroupReference(EnterpriseConfiguration config, int fingerprint) {
        this.setConfiguration(config);
        this.setFingerprint(fingerprint);
    }

    public boolean isResolved() {
        return this.target != null;
    }

    public int getSymbolSpace() {
        return 805;
    }

    public void setFingerprint(int fingerprint) {
        this.fingerprint = fingerprint;
    }

    public int getFingerprint() {
        return this.fingerprint;
    }

    public AttributeWildcard getAttributeWildcard(SchemaCompiler compiler) throws UnresolvedReferenceException {
        this.tryToResolve(compiler);
        if (this.target == null) {
            throw new UnresolvedReferenceExceptionImpl(this);
        }
        return this.target.getAttributeWildcard(compiler);
    }

    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        AttributeGroupDecl decl = (AttributeGroupDecl)PreparedSchema.validateReference(this, compiler);
        if (decl == null) {
            this.setFixupStatus(4);
            return false;
        }
        this.lookForCycles(new Stack(), compiler);
        this.setFixupStatus(3);
        this.setValidationStatus(3);
        return true;
    }

    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        if (this.getFixupStatus() == 0) {
            boolean b = this.fixup(compiler);
            if (b) {
                this.setFixupStatus(3);
                this.setValidationStatus(3);
                return true;
            }
            this.setFixupStatus(4);
            this.setValidationStatus(4);
            return false;
        }
        if (this.getFixupStatus() == 4) {
            this.setValidationStatus(4);
            return false;
        }
        this.setValidationStatus(3);
        return true;
    }

    public void lookForCycles(Stack references, SchemaCompiler compiler) throws SchemaException {
        try {
            if (references.contains(this)) {
                throw new SchemaException("The definition of attribute group " + Err.wrap(compiler.getNamePool().getDisplayName(this.getFingerprint())) + " is circular");
            }
            int fp = this.getFingerprint();
            if (fp == -1) {
                return;
            }
            AttributeGroupDecl group = compiler.getPreparedSchema().getAttributeGroup(fp);
            if (group != null) {
                references.push(this);
                group.lookForCycles(references, compiler);
                references.pop();
            }
        }
        catch (SchemaException err) {
            this.setFingerprint(-1);
            throw err;
        }
    }

    public void tryToResolve(SchemaCompiler compiler) {
        if (compiler != null) {
            PreparedSchema schema = compiler.getPreparedSchema();
            if (this.target == null) {
                this.target = schema.getAttributeGroup(this.getFingerprint());
            }
        }
        if (this.target == null) {
            this.target = this.getConfiguration().getSuperSchema().getAttributeGroup(this.getFingerprint());
        }
    }

    public SchemaComponent getTarget() {
        if (this.target == null) {
            throw new UnresolvedReferenceExceptionImpl(this);
        }
        return this.target;
    }

    public void elaborate(SchemaCompiler compiler) throws SchemaException {
    }
}

