/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.schema.AttributeDecl;
import com.saxonica.schema.AttributeGroupReference;
import com.saxonica.schema.AttributeUse;
import com.saxonica.schema.AttributeWildcard;
import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.SchemaCompiler;
import com.saxonica.schema.SchemaModelSerializer;
import com.saxonica.schema.SchemaStructure;
import com.saxonica.schema.SerializableSchemaComponent;
import com.saxonica.schema.UserSchemaComponent;
import com.saxonica.schema.UserSimpleType;
import com.saxonica.schema.Wildcard;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.expr.sort.IntHashSet;
import net.sf.saxon.expr.sort.IntToIntArrayMap;
import net.sf.saxon.expr.sort.IntToIntHashMap;
import net.sf.saxon.expr.sort.IntToIntMap;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeGroupDecl
extends SchemaStructure
implements UserSchemaComponent,
SerializableSchemaComponent {
    private List<AttributeUse> attributes;
    private List<AttributeGroupReference> references;
    private AttributeWildcard anyAttribute = null;
    private int nameCode = -1;
    private IntHashMap<AttributeUse> declaredAttributes = null;
    private IntToIntMap counterMap;
    private AttributeGroupDecl redefinedAttributeGroup;

    public AttributeGroupDecl(EnterpriseConfiguration config) {
        this.setConfiguration(config);
        this.attributes = new ArrayList<AttributeUse>(10);
        this.references = new ArrayList<AttributeGroupReference>(10);
    }

    public String getName() {
        return this.getConfiguration().getNamePool().getLocalName(this.nameCode);
    }

    public String getTargetNamespace() {
        return this.getConfiguration().getNamePool().getURI(this.nameCode);
    }

    public void addAttributeUse(AttributeUse use) {
        if (use == null) {
            return;
        }
        this.attributes.add(use);
    }

    public void addAttributeGroupReference(AttributeGroupReference attrGroup) {
        if (attrGroup == null) {
            return;
        }
        this.references.add(attrGroup);
    }

    public void setRedefinedAttributeGroupDecl(AttributeGroupDecl other) {
        this.redefinedAttributeGroup = other;
    }

    public Iterator getLocalAttributes() {
        return this.attributes.iterator();
    }

    public Iterator getLocalAttributeGroupReferences() {
        return this.references.iterator();
    }

    @Override
    public void lookForCycles(Stack references, SchemaCompiler compiler) throws SchemaException {
        if (references.contains(this)) {
            throw new SchemaException("The definition of attribute group " + Err.wrap(compiler.getNamePool().getDisplayName(this.getFingerprint())) + " is circular", this);
        }
        Iterator iter = this.getLocalAttributeGroupReferences();
        references.push(this);
        while (iter.hasNext()) {
            AttributeGroupReference group = (AttributeGroupReference)iter.next();
            group.lookForCycles(references, compiler);
        }
        references.pop();
    }

    public AttributeWildcard getLocalAttributeWildcard() {
        return this.anyAttribute;
    }

    public AttributeWildcard getAttributeWildcard(SchemaCompiler compiler) throws UnresolvedReferenceException {
        AttributeWildcard awc = this.getLocalAttributeWildcard();
        Wildcard wat = awc == null ? null : awc.getWildcard();
        Iterator groups = this.getLocalAttributeGroupReferences();
        while (groups.hasNext()) {
            AttributeWildcard gawc = ((AttributeGroupReference)groups.next()).getAttributeWildcard(compiler);
            Wildcard gat = gawc == null ? null : gawc.getWildcard();
            if (gat == null) continue;
            if (wat == null) {
                wat = gat;
                continue;
            }
            wat = Wildcard.makeIntersection(wat, gat, this.getConfiguration().getNamePool());
        }
        return wat == null ? null : new AttributeWildcard(wat);
    }

    public Iterator<AttributeUse> getAttributeUses() {
        ArrayList<AttributeUse> list = new ArrayList<AttributeUse>(20);
        this.gatherAttributeUses(list);
        return list.iterator();
    }

    public void gatherAttributeUses(List<AttributeUse> list) {
        for (AttributeUse a : this.attributes) {
            list.add(a);
        }
        for (int i = 0; i < this.references.size(); ++i) {
            AttributeGroupDecl decl = (AttributeGroupDecl)this.references.get(i).getTarget();
            decl.gatherAttributeUses(list);
        }
    }

    public IntToIntMap getCounterMap() {
        return this.counterMap;
    }

    public String getDisplayName() {
        return this.getConfiguration().getNamePool().getDisplayName(this.nameCode);
    }

    public void setAnyAttribute(AttributeWildcard wildcard) {
        this.anyAttribute = wildcard;
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        if (this.getFixupStatus() == 0) {
            this.setFixupStatus(2);
            for (AttributeUse use : this.attributes) {
                AttributeDecl decl = (AttributeDecl)PreparedSchema.validateReference(use, compiler);
                if (decl == null) {
                    this.setFixupStatus(4);
                    continue;
                }
                boolean b = decl.fixup(compiler);
                if (b) continue;
                this.setFixupStatus(4);
            }
            for (AttributeGroupReference ref : this.references) {
                AttributeGroupDecl decl = (AttributeGroupDecl)PreparedSchema.validateReference(ref, compiler);
                if (decl == null) {
                    ref.setFixupStatus(4);
                    this.setFixupStatus(4);
                    continue;
                }
                boolean b = decl.fixup(compiler);
                if (b) continue;
                this.setFixupStatus(4);
            }
            if (this.getFixupStatus() == 4) {
                return false;
            }
            this.lookForCycles(new Stack(), compiler);
        }
        this.setFixupStatus(3);
        return true;
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        boolean result = true;
        if (this.getFixupStatus() == 0) {
            result = this.fixup(compiler);
        }
        if (this.getFixupStatus() == 4) {
            this.setValidationStatus(4);
            return false;
        }
        switch (this.getValidationStatus()) {
            case 3: 
            case 4: {
                return true;
            }
            case 2: {
                compiler.error("The definition of attribute group " + Err.wrap(compiler.getNamePool().getDisplayName(this.getFingerprint())) + " is circular", this);
                return false;
            }
        }
        this.setValidationStatus(2);
        for (AttributeUse obj : this.attributes) {
            UserSchemaComponent structure = obj;
            result &= structure.validate(compiler);
        }
        for (AttributeGroupReference ref : this.references) {
            result &= ref.validate(compiler);
        }
        if (!result) {
            this.setValidationStatus(4);
            return false;
        }
        AttributeWildcard wild = this.getAttributeWildcard(compiler);
        if (wild != null) {
            result = wild.validate(compiler);
        }
        if (result) {
            String foundID = null;
            ArrayList<AttributeUse> attributeList = new ArrayList<AttributeUse>();
            this.gatherAttributeUses(attributeList);
            Iterator agi = attributeList.iterator();
            IntHashSet fingerprintSet = new IntHashSet(attributeList.size() * 2);
            TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
            while (agi.hasNext()) {
                int key;
                AttributeUse att = (AttributeUse)agi.next();
                if (!(result &= att.validate(compiler))) continue;
                AttributeDecl decl = (AttributeDecl)att.getTarget();
                SimpleType stype = decl.getSimpleType();
                if (stype.isAtomicType() && stype.getFingerprint() != 573 && th.isSubType((AtomicType)stype, BuiltInAtomicType.ID)) {
                    if (foundID != null && compiler.getLanguageVersion() == 10) {
                        compiler.error("Attribute group contains more than one ID attribute (" + foundID + ", " + att.getDisplayName() + ')', this);
                        result = false;
                    }
                    foundID = att.getDisplayName();
                }
                if (fingerprintSet.contains(key = att.getFingerprint())) {
                    compiler.error("Attribute " + Err.wrap(att.getDisplayName(), 2) + " appears more than once in attribute group", this);
                    result = false;
                }
                fingerprintSet.add(key);
            }
            this.buildCounterMap();
        }
        if (this.redefinedAttributeGroup != null) {
            result &= this.isValidRestriction(this.redefinedAttributeGroup, compiler);
        }
        this.getDeclaredAttributes();
        this.setValidationStatus(3);
        return result;
    }

    public void buildCounterMap() {
        ArrayList<AttributeUse> attributeList = new ArrayList<AttributeUse>();
        this.gatherAttributeUses(attributeList);
        int size = attributeList.size();
        this.counterMap = size < 8 ? new IntToIntArrayMap(size + 2) : new IntToIntHashMap(size + 2);
        int counterIndex = 0;
        for (AttributeUse att : attributeList) {
            int key = att.getFingerprint();
            this.counterMap.put(key, counterIndex++);
        }
    }

    public boolean isValidRestriction(AttributeGroupDecl base, SchemaCompiler compiler) throws SchemaException {
        boolean result = true;
        Iterator<AttributeUse> attributes = this.getAttributeUses();
        while (attributes.hasNext()) {
            Value attFixed;
            Value baseFixed;
            AttributeUse att = attributes.next();
            if (att.isProhibited()) continue;
            int fp = att.getFingerprint();
            AttributeUse baseAtt = base.getAttributeUse(fp);
            if (baseAtt == null || baseAtt.isProhibited()) {
                AttributeWildcard wild = base.getAttributeWildcard(compiler);
                if (wild == null) {
                    compiler.error("Invalid restriction: attribute " + Err.wrap(att.getDisplayName(), 2) + " is " + (baseAtt == null ? "not defined" : "prohibited") + " in the base type", this);
                    result = false;
                    continue;
                }
                if (wild.getWildcard().matches(fp, false, this.getConfiguration(), null)) continue;
                compiler.error("Invalid restriction: attribute " + Err.wrap(att.getDisplayName(), 2) + " is " + (baseAtt == null ? "not defined" : "prohibited") + " in the base type", this);
                result = false;
                continue;
            }
            if (baseAtt.isRequired() && !att.isRequired()) {
                compiler.error("Invalid restriction: attribute " + Err.wrap(att.getDisplayName(), 2) + " is optional but the base attribute is required", this);
                result = false;
            }
            if (baseAtt.isInheritable() != att.isInheritable()) {
                if (att.isInheritable()) {
                    compiler.error("Invalid restriction: attribute " + Err.wrap(att.getDisplayName(), 2) + " is inheritable, but the corresponding attribute in the base type is not", this);
                } else {
                    compiler.error("Invalid restriction: attribute " + Err.wrap(att.getDisplayName(), 2) + " is not inheritable, but the corresponding attribute in the base type is", this);
                }
                result = false;
            }
            AttributeDecl decl = (AttributeDecl)att.getTarget();
            AttributeDecl baseDecl = (AttributeDecl)baseAtt.getTarget();
            String reason = UserSimpleType.isTypeDerivationOK(decl.getSimpleType(), baseDecl.getSimpleType(), 0);
            if (reason != null) {
                compiler.error("Invalid restriction: attribute " + Err.wrap(att.getDisplayName(), 2) + " is inconsistent with the base type. " + reason, this);
                result = false;
            }
            if ((baseFixed = baseAtt.getFixedValue()) == null) {
                baseFixed = baseDecl.getFixedValue();
            }
            if (baseFixed == null) continue;
            if (att.getUnderlyingDefaultValue() != null) {
                compiler.error("Invalid restriction: attribute " + Err.wrap(att.getDisplayName(), 2) + " has a default value but the base attribute is fixed", this);
                result = false;
            }
            if ((attFixed = att.getUnderlyingFixedValue()) != null && !attFixed.getSchemaComparable().equals(baseFixed.getSchemaComparable())) {
                compiler.error("Invalid restriction: attribute " + Err.wrap(att.getDisplayName(), 2) + " has a fixed value different from that of the base attribute", this);
                result = false;
                continue;
            }
            if (attFixed != null) continue;
            compiler.error("Invalid restriction: attribute " + Err.wrap(att.getDisplayName(), 2) + " must have the same fixed value as the base attribute", this);
            result = false;
        }
        Iterator<AttributeUse> baseAttributes = base.getAttributeUses();
        while (baseAttributes.hasNext()) {
            AttributeUse thisAtt;
            AttributeUse baseAtt = baseAttributes.next();
            if (!baseAtt.isRequired() || (thisAtt = this.getAttributeUse(baseAtt.getFingerprint())) != null) continue;
            compiler.error("Invalid restriction: base type has a required attribute " + Err.wrap(baseAtt.getDisplayName(), 2), this);
            result = false;
        }
        AttributeWildcard wild = this.getAttributeWildcard(compiler);
        if (wild != null) {
            AttributeWildcard baseWild = base.getAttributeWildcard(compiler);
            if (baseWild == null) {
                compiler.error("Invalid restriction: this type has an <xs:anyAttribute> but the base type does not", this);
                return false;
            }
            if (!wild.getWildcard().isSubset(baseWild.getWildcard(), compiler.getNamePool())) {
                compiler.error("Invalid restriction: this type has an <anyAttribute> wildcard which allows attribute names that are not permitted by the <anyAttribute> on the base type", this);
                return false;
            }
            if (baseWild.getWildcard().compareStrength(wild.getWildcard()) > 0) {
                compiler.error("Invalid <anyAttribute> restriction: this type has a weaker processContents than the base type", this);
                return false;
            }
        }
        return result;
    }

    public boolean isSameDeclaration(AttributeGroupDecl other) {
        return this == other || this.getFingerprint() == other.getFingerprint() && this.getLineNumber() == other.getLineNumber() && this.getColumnNumber() == other.getColumnNumber() && this.getSystemId().equals(other.getSystemId());
    }

    public int getFingerprint() {
        return this.nameCode & 0xFFFFF;
    }

    public void setNameCode(int nameCode) {
        this.nameCode = nameCode;
    }

    public IntHashMap<AttributeUse> getDeclaredAttributes() {
        if (this.declaredAttributes == null) {
            IntHashMap<AttributeUse> map = new IntHashMap<AttributeUse>(10);
            Iterator<AttributeUse> iter = this.getAttributeUses();
            while (iter.hasNext()) {
                AttributeUse decl = iter.next();
                map.put(decl.getFingerprint(), decl);
            }
            this.declaredAttributes = map;
        }
        return this.declaredAttributes;
    }

    public final AttributeUse getAttributeUse(int fingerprint) {
        Iterator<AttributeUse> iter = this.getAttributeUses();
        while (iter.hasNext()) {
            AttributeUse att = iter.next();
            if (att.getFingerprint() != fingerprint) continue;
            return att;
        }
        return null;
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        String id = serializer.getId(this, true);
        serializer.startElement("attributeGroup");
        serializer.emitAttribute("id", id);
        serializer.emitAttribute("name", this.getName());
        if (this.getTargetNamespace() != null && this.getTargetNamespace().length() > 0) {
            serializer.emitAttribute("targetNamespace", this.getTargetNamespace());
        }
        this.serializeContents(serializer);
        serializer.endElement();
    }

    public void serializeContents(SchemaModelSerializer serializer) throws XPathException {
        Iterator<AttributeUse> uses = this.getAttributeUses();
        while (uses.hasNext()) {
            AttributeUse use = uses.next();
            use.serialize(serializer);
        }
        if (this.getAttributeWildcard(null) != null) {
            this.getAttributeWildcard(null).serialize(serializer);
        }
    }

    @Override
    public void elaborate(SchemaCompiler compiler) throws SchemaException {
        this.buildCounterMap();
    }
}

