/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ptree;

import com.saxonica.ptree.PTreeSource;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.StandardURIResolver;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;

public class PTreeURIResolver
extends StandardURIResolver {
    public PTreeURIResolver() {
        this(null);
        this.recognizeQueryParameters = true;
    }

    public PTreeURIResolver(Configuration config) {
        super(config);
        this.recognizeQueryParameters = true;
    }

    protected Source getPTreeSource(String href, String base) throws XPathException {
        URI url;
        try {
            url = ResolveURI.makeAbsolute(href, base);
        }
        catch (URISyntaxException err) {
            String expandedBase = ResolveURI.tryToExpand(base);
            if (!expandedBase.equals(base)) {
                return this.resolve(href, expandedBase);
            }
            throw new XPathException("Invalid URI " + Err.wrap(href) + " - base " + Err.wrap(base), err);
        }
        PTreeSource ps = new PTreeSource();
        ps.setSystemId(url.toString());
        return ps;
    }
}

