/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ptree;

import com.saxonica.ptree.PTreeWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;

public class PTreeEmitter
extends Emitter {
    private TinyBuilder builder = new TinyBuilder();

    public void setPipelineConfiguration(PipelineConfiguration config) {
        this.builder.setPipelineConfiguration(config);
        super.setPipelineConfiguration(config);
    }

    public void setStreamResult(StreamResult result) throws XPathException {
        super.setStreamResult(result);
        this.makeWriter();
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        this.builder.attribute(nameCode, typeCode, value, locationId, properties);
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        this.builder.characters(chars, locationId, properties);
    }

    public void close() throws XPathException {
        TinyDocumentImpl doc = (TinyDocumentImpl)this.builder.getCurrentRoot();
        PTreeWriter out = new PTreeWriter();
        try {
            out.writeTree(doc.getTree(), new DataOutputStream(this.getOutputStream()));
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
        this.builder = null;
        super.close();
    }

    public void comment(CharSequence content, int locationId, int properties) throws XPathException {
        this.builder.comment(content, locationId, properties);
    }

    public void endDocument() throws XPathException {
        this.builder.endDocument();
    }

    public void endElement() throws XPathException {
        this.builder.endElement();
    }

    public void namespace(int namespaceCode, int properties) throws XPathException {
        this.builder.namespace(namespaceCode, properties);
    }

    public void open() throws XPathException {
        this.builder.open();
    }

    public void processingInstruction(String name, CharSequence data, int locationId, int properties) throws XPathException {
        this.builder.processingInstruction(name, data, locationId, properties);
    }

    public void startContent() throws XPathException {
        this.builder.startContent();
    }

    public void startDocument(int properties) throws XPathException {
        this.open();
        this.builder.startDocument(properties);
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.builder.startElement(nameCode, typeCode, locationId, properties);
    }

    public boolean usesTypeAnnotations() {
        return true;
    }
}

