/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.jaxp;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.jaxp.URIResourceResolver;
import com.saxonica.schema.PreparedSchema;
import com.saxonica.schema.sdoc.LSSchemaResolver;
import java.io.IOException;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.validation.Validator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.Sink;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SerializerFactory;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class ValidatorImpl
extends Validator {
    private PipelineConfiguration pipe;

    public ValidatorImpl(PipelineConfiguration pipe, PreparedSchema schema) {
        try {
            this.pipe = pipe;
            EnterpriseConfiguration config = (EnterpriseConfiguration)pipe.getConfiguration();
            config.addSchema(schema);
        }
        catch (TransformerConfigurationException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
    }

    public void reset() {
    }

    public void validate(Source source, Result result) throws SAXException, IOException {
        try {
            Receiver out;
            if (result == null) {
                out = new Sink();
            } else {
                SerializerFactory sf = this.pipe.getConfiguration().getSerializerFactory();
                out = sf.getReceiver(result, this.pipe, new Properties());
            }
            ParseOptions options = new ParseOptions();
            options.setSchemaValidationMode(65537);
            options.setContinueAfterValidationErrors(true);
            out.setPipelineConfiguration(this.pipe);
            Sender.send(source, out, options);
        }
        catch (TransformerException e) {
            if (e.getException() instanceof SAXException) {
                throw (SAXException)e.getException();
            }
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            throw new SAXException(e);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.pipe.setErrorListener(new ErrorListenerWrappingErrorHandler(errorHandler));
    }

    public ErrorHandler getErrorHandler() {
        ErrorListener listener = this.pipe.getErrorListener();
        if (listener instanceof ErrorListenerWrappingErrorHandler) {
            return ((ErrorListenerWrappingErrorHandler)listener).getErrorHandler();
        }
        return null;
    }

    public void setResourceResolver(LSResourceResolver resourceResolver) {
        this.pipe.setURIResolver(new URIResourceResolver(resourceResolver));
        this.pipe.setSchemaURIResolver(new LSSchemaResolver(resourceResolver, this.pipe.getConfiguration()));
    }

    public LSResourceResolver getResourceResolver() {
        URIResolver u = this.pipe.getURIResolver();
        if (u instanceof URIResourceResolver) {
            return ((URIResourceResolver)u).getLSResourceResolver();
        }
        return null;
    }

    public Configuration getConfiguration() {
        return this.pipe.getConfiguration();
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            return this.pipe.getConfiguration().getConfigurationProperty(name);
        }
        catch (IllegalArgumentException err) {
            throw new SAXNotSupportedException(err.getMessage());
        }
    }

    public void setProperty(String name, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            this.pipe.getConfiguration().setConfigurationProperty(name, object);
        }
        catch (IllegalArgumentException err) {
            throw new SAXNotSupportedException(err.getMessage());
        }
    }

    public static class ErrorListenerWrappingErrorHandler
    implements ErrorListener {
        private ErrorHandler handler;

        public ErrorListenerWrappingErrorHandler(ErrorHandler handler) {
            this.handler = handler;
        }

        public void warning(TransformerException exception) throws TransformerException {
            try {
                this.handler.warning(this.toSAXException(exception));
            }
            catch (SAXException e) {
                throw this.toJAXPException(e);
            }
        }

        public void error(TransformerException exception) throws TransformerException {
            try {
                this.handler.error(this.toSAXException(exception));
            }
            catch (SAXException e) {
                throw this.toJAXPException(e);
            }
        }

        public void fatalError(TransformerException exception) throws TransformerException {
            try {
                this.handler.fatalError(this.toSAXException(exception));
            }
            catch (SAXException e) {
                throw this.toJAXPException(e);
            }
        }

        private SAXParseException toSAXException(TransformerException err) {
            if (err.getException() instanceof SAXParseException) {
                return (SAXParseException)err.getException();
            }
            SourceLocator loc = err.getLocator();
            if (loc != null && !(loc instanceof Locator)) {
                loc = new ExpressionLocation(loc);
            }
            return new SAXParseException(err.getMessage(), (Locator)((Object)loc), err);
        }

        private TransformerException toJAXPException(SAXException err) {
            if (err.getException() instanceof TransformerException) {
                return (TransformerException)err.getException();
            }
            return new TransformerException(err);
        }

        public ErrorHandler getErrorHandler() {
            return this.handler;
        }
    }
}

