/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.jaxp;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.jaxp.TypedContentHandler;
import com.saxonica.jaxp.URIResourceResolver;
import com.saxonica.jaxp.ValidatorImpl;
import com.saxonica.schema.sdoc.LSSchemaResolver;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import javax.xml.validation.TypeInfoProvider;
import javax.xml.validation.ValidatorHandler;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ReceivingContentHandler;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;

public class ValidatorHandlerImpl
extends ValidatorHandler
implements ContentHandler,
LexicalHandler,
DTDHandler {
    ReceivingContentHandler next;
    TypedContentHandler finalProxy;
    LSResourceResolver resourceResolver;
    ErrorHandler errorHandler;
    PipelineConfiguration pipe;

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    public void setReceivingContentHandler(ReceivingContentHandler rch) {
        this.next = rch;
    }

    public void setFinalProxy(TypedContentHandler proxy) {
        this.finalProxy = proxy;
    }

    public void setContentHandler(ContentHandler receiver) {
        this.finalProxy.setUnderlyingContentHandler(receiver);
    }

    public ContentHandler getContentHandler() {
        return this.finalProxy.getUnderlyingContentHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        ValidatorImpl.ErrorListenerWrappingErrorHandler el = new ValidatorImpl.ErrorListenerWrappingErrorHandler(errorHandler);
        this.pipe.setErrorListener(el);
    }

    public ErrorHandler getErrorHandler() {
        ErrorListener el = this.pipe.getErrorListener();
        if (el instanceof ValidatorImpl.ErrorListenerWrappingErrorHandler) {
            return ((ValidatorImpl.ErrorListenerWrappingErrorHandler)el).getErrorHandler();
        }
        return null;
    }

    public void setResourceResolver(LSResourceResolver resourceResolver) {
        this.pipe.setURIResolver(new URIResourceResolver(resourceResolver));
        this.pipe.setSchemaURIResolver(new LSSchemaResolver(resourceResolver, this.pipe.getConfiguration()));
    }

    public LSResourceResolver getResourceResolver() {
        URIResolver u = this.pipe.getURIResolver();
        if (u instanceof URIResourceResolver) {
            return ((URIResourceResolver)u).getLSResourceResolver();
        }
        return null;
    }

    public TypeInfoProvider getTypeInfoProvider() {
        return this.finalProxy.getTypeInfoProvider();
    }

    public void setDocumentLocator(Locator locator) {
        this.next.setDocumentLocator(locator);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            return this.pipe.getConfiguration().getConfigurationProperty(name);
        }
        catch (IllegalArgumentException err) {
            throw new SAXNotSupportedException(err.getMessage());
        }
    }

    public void setProperty(String name, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            this.pipe.getConfiguration().setConfigurationProperty(name, object);
        }
        catch (IllegalArgumentException err) {
            throw new SAXNotSupportedException(err.getMessage());
        }
    }

    public EnterpriseConfiguration getConfiguration() {
        return (EnterpriseConfiguration)this.pipe.getConfiguration();
    }

    public void startDocument() throws SAXException {
        this.next.startDocument();
    }

    public void endDocument() throws SAXException {
        this.next.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.next.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.next.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.next.startElement(uri, localName, qName, atts);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.next.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.next.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.next.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.next.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.next.skippedEntity(name);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.next.startDTD(name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        this.next.endDTD();
    }

    public void startEntity(String name) throws SAXException {
        this.next.startEntity(name);
    }

    public void endEntity(String name) throws SAXException {
        this.next.endEntity(name);
    }

    public void startCDATA() throws SAXException {
        this.next.startCDATA();
    }

    public void endCDATA() throws SAXException {
        this.next.endCDATA();
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.next.comment(ch, start, length);
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        this.next.notationDecl(name, publicId, systemId);
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        this.next.unparsedEntityDecl(name, publicId, systemId, notationName);
    }
}

