/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.jaxp;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.jaxp.ValidatorImpl;
import java.io.IOException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.event.Sink;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.type.SchemaException;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class ValidatingReader
implements XMLReader {
    private EnterpriseConfiguration config;
    private XMLReader parser;
    private ContentHandler contentHandler;

    public ValidatingReader() {
        this(new EnterpriseConfiguration());
        this.config.getParseOptions().setContinueAfterValidationErrors(true);
    }

    public ValidatingReader(EnterpriseConfiguration config) {
        this(config, config.getSourceParser());
    }

    public ValidatingReader(EnterpriseConfiguration config, XMLReader parser) {
        this.config = config;
        this.parser = parser;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.startsWith("http://saxon.sf.net/")) {
            try {
                Object result = this.config.getConfigurationProperty(name);
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                throw new SAXNotRecognizedException("Feature name " + name + " is recognized, but is not boolean");
            }
            catch (IllegalArgumentException e) {
                throw new SAXNotRecognizedException(e.getMessage());
            }
        }
        return this.parser.getFeature(name);
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.startsWith("http://saxon.sf.net/")) {
            try {
                this.config.setConfigurationProperty(name, value);
            }
            catch (IllegalArgumentException err) {
                throw new SAXNotRecognizedException(err.getMessage());
            }
        } else if (!(name.equals("http://xml.org/sax/features/validation") || name.equals("http://apache.org/xml/features/validation/schema") || name.equals("http://apache.org/xml/features/validation/schema-full-checking") || name.equals("http://apache.org/xml/features/disallow-doctype-decl"))) {
            this.parser.setFeature(name, value);
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.startsWith("http://saxon.sf.net/")) {
            try {
                return this.config.getConfigurationProperty(name);
            }
            catch (IllegalArgumentException err) {
                throw new SAXNotRecognizedException(err.getMessage());
            }
        }
        return this.parser.getProperty(name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.startsWith("http://saxon.sf.net/")) {
            try {
                this.config.setConfigurationProperty(name, value);
            }
            catch (IllegalArgumentException err) {
                throw new SAXNotRecognizedException(err.getMessage());
            }
        } else if (name.equals("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation")) {
            try {
                this.config.addSchemaSource(new StreamSource((String)value));
            }
            catch (SchemaException err) {
                throw new SAXNotSupportedException("Error in no-namespace schema document: " + err.getMessage());
            }
        } else if (name.equals("http://apache.org/xml/properties/schema/external-schemaLocation")) {
            int space = value.toString().indexOf(32);
            if (space <= 0) {
                throw new SAXNotSupportedException("Value of property " + name + " contains no space. " + "Value should contain namespace URI and schema location URI, space-separated.");
            }
            String locationURI = value.toString().substring(space + 1);
            try {
                this.config.addSchemaSource(new StreamSource(locationURI));
            }
            catch (SchemaException err) {
                throw new SAXNotSupportedException("Error in schema document: " + err.getMessage());
            }
        } else {
            this.parser.setProperty(name, value);
        }
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.parser.setEntityResolver(resolver);
    }

    public EntityResolver getEntityResolver() {
        return this.parser.getEntityResolver();
    }

    public void setDTDHandler(DTDHandler handler) {
        this.parser.setDTDHandler(handler);
    }

    public DTDHandler getDTDHandler() {
        return this.parser.getDTDHandler();
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.parser.setErrorHandler(handler);
    }

    public ErrorHandler getErrorHandler() {
        return this.parser.getErrorHandler();
    }

    public void parse(InputSource input) throws IOException, SAXException {
        this.setValidator(input.getSystemId());
        this.parser.parse(input);
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.setValidator(systemId);
        this.parser.parse(systemId);
    }

    private void setValidator(String systemId) {
        StructuredQName topLevelElement;
        Receiver output;
        if (this.contentHandler == null) {
            output = new Sink();
        } else {
            ContentHandlerProxy chp = new ContentHandlerProxy();
            chp.setUnderlyingContentHandler(this.contentHandler);
            output = chp;
        }
        PipelineConfiguration pipe = this.config.makePipelineConfiguration();
        pipe.setErrorListener(new ValidatorImpl.ErrorListenerWrappingErrorHandler(this.parser.getErrorHandler()));
        pipe.getParseOptions().setCheckEntityReferences(true);
        output.setPipelineConfiguration(pipe);
        int validationMode = 1;
        if (this.config.getSchemaValidationMode() == 2) {
            validationMode = 2;
        }
        int top = (topLevelElement = this.config.getParseOptions().getTopLevelElement()) == null ? -1 : this.config.getNamePool().getFingerprint(topLevelElement.getNamespaceURI(), topLevelElement.getLocalName());
        Receiver receiver = this.config.getDocumentValidator(output, systemId, validationMode, 0, this.config.getParseOptions().getTopLevelType(), top);
        ReceivingContentHandler rch = new ReceivingContentHandler();
        rch.setPipelineConfiguration(output.getPipelineConfiguration());
        rch.setReceiver(receiver);
        this.parser.setContentHandler(rch);
    }
}

