/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.jaxp;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.jaxp.TypedContentHandler;
import com.saxonica.jaxp.ValidatorHandlerImpl;
import com.saxonica.jaxp.ValidatorImpl;
import com.saxonica.schema.PreparedSchema;
import java.io.Serializable;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.validation.ValidatorHandler;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class SchemaReference
extends Schema
implements Serializable {
    private PreparedSchema schema;

    public SchemaReference(PreparedSchema schema) {
        this.schema = schema;
    }

    public PreparedSchema getPreparedSchema() {
        return this.schema;
    }

    public Validator newValidator() {
        PipelineConfiguration pipe = this.schema.getConfiguration().makePipelineConfiguration();
        pipe.setRecoverFromValidationErrors(true);
        return new ValidatorImpl(pipe, this.schema);
    }

    public ValidatorHandler newValidatorHandler() {
        EnterpriseConfiguration config = this.schema.getConfiguration();
        PipelineConfiguration pipe = config.makePipelineConfiguration();
        TypedContentHandler proxy = new TypedContentHandler();
        proxy.setPipelineConfiguration(pipe);
        proxy.setUnderlyingContentHandler(new XMLFilterImpl());
        Receiver realValidator = config.getDocumentValidator(proxy, this.schema.getSystemId(), 65537, 0, null, -1);
        pipe.getParseOptions().setContinueAfterValidationErrors(true);
        pipe.getParseOptions().setCheckEntityReferences(true);
        ReceivingContentHandler rch = new ReceivingContentHandler();
        rch.setReceiver(realValidator);
        rch.setPipelineConfiguration(pipe);
        ValidatorHandlerImpl val = new ValidatorHandlerImpl();
        val.setPipelineConfiguration(pipe);
        val.setReceivingContentHandler(rch);
        val.setFinalProxy(proxy);
        return val;
    }
}

