/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.jaxp;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.jaxp.SchemaReference;
import com.saxonica.jaxp.URIResourceResolver;
import com.saxonica.jaxp.ValidatorImpl;
import com.saxonica.schema.sdoc.LSSchemaResolver;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.sf.saxon.type.SchemaException;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SchemaFactoryImpl
extends SchemaFactory {
    EnterpriseConfiguration config;

    public SchemaFactoryImpl() {
        this.config = new EnterpriseConfiguration();
        this.config.setProcessor(this);
        if (!this.config.isLicensedFeature(1)) {
            throw new UnsupportedOperationException("This operation needs a license for Saxon-EE");
        }
    }

    public SchemaFactoryImpl(EnterpriseConfiguration config) {
        this.config = config;
        if (!config.isLicensedFeature(1)) {
            throw new UnsupportedOperationException("This operation needs a license for Saxon-EE");
        }
    }

    public boolean isSchemaLanguageSupported(String language) {
        return language.equals("http://www.w3.org/2001/XMLSchema");
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.config.setErrorListener(new ValidatorImpl.ErrorListenerWrappingErrorHandler(errorHandler));
    }

    public ErrorHandler getErrorHandler() {
        if (this.config.getErrorListener() instanceof ValidatorImpl.ErrorListenerWrappingErrorHandler) {
            return ((ValidatorImpl.ErrorListenerWrappingErrorHandler)this.config.getErrorListener()).getErrorHandler();
        }
        return null;
    }

    public void setResourceResolver(LSResourceResolver lsResourceResolver) {
        this.config.setURIResolver(new URIResourceResolver(lsResourceResolver));
        this.config.setSchemaURIResolver(new LSSchemaResolver(lsResourceResolver, this.config));
    }

    public LSResourceResolver getResourceResolver() {
        URIResolver resolver = this.config.getURIResolver();
        if (resolver instanceof URIResourceResolver) {
            return ((URIResourceResolver)resolver).getLSResourceResolver();
        }
        return null;
    }

    public Schema newSchema(Source[] sources) throws SAXException {
        ErrorListener listener = this.config.getErrorListener();
        try {
            for (int i = 0; i < sources.length; ++i) {
                this.config.addSchemaSource(sources[i], listener);
            }
        }
        catch (SchemaException e) {
            throw new SAXException(e);
        }
        return new SchemaReference(this.config.getSuperSchema());
    }

    public Schema newSchema() {
        return new SchemaReference(this.config.getSuperSchema());
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            return this.config.getConfigurationProperty(name);
        }
        catch (IllegalArgumentException err) {
            throw new SAXNotSupportedException(err.getMessage());
        }
    }

    public void setProperty(String name, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            this.config.setConfigurationProperty(name, object);
        }
        catch (IllegalArgumentException err) {
            throw new SAXNotSupportedException(err.getMessage());
        }
    }

    public EnterpriseConfiguration getConfiguration() {
        return this.config;
    }
}

