/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.xpath3;

import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.number.Alphanumeric;
import net.sf.saxon.expr.number.IrregularGroupFormatter;
import net.sf.saxon.expr.number.NumericGroupFormatter;
import net.sf.saxon.expr.number.RegularGroupFormatter;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;

public class FormatInteger
extends SystemFunction {
    private Numberer numberer = null;
    private String pic;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Item evaluateItem(XPathContext context) throws XPathException {
        Configuration config = context.getConfiguration();
        ConversionRules rules = config.getConversionRules();
        IntegerValue num = (IntegerValue)this.argument[0].evaluateItem(context);
        if (num == null) {
            return new StringValue("");
        }
        String languageVal = null;
        languageVal = this.argument.length > 2 ? this.argument[2].evaluateItem(context).getStringValue() : config.getDefaultLanguage();
        boolean hasSign = false;
        if (num.signum() == -1.0) {
            hasSign = true;
        }
        num = (IntegerValue)num.abs();
        this.pic = this.argument[1].evaluateItem(context).getStringValue();
        if (this.pic.isEmpty()) {
            throw new XPathException("The picture cannot be empty", "XTDE0030");
        }
        String ordinal = "";
        String letterValue = "alphabetic";
        if (this.pic.matches(".*o\\(*.*\\)*$")) {
            String[] picParts = this.pic.split("o", 2);
            this.pic = picParts[0];
            if (picParts[1].length() == 0) {
                if (picParts[0].matches(".*t$")) {
                    throw new XPathException("The format modifier is not valid", "XTDE0030");
                }
                ordinal = "yes";
            } else {
                if (!picParts[1].matches("\\(.+[^\\(\\)]\\)")) throw new XPathException("The format modifier is not valid", "XTDE0030");
                ordinal = picParts[1].substring(1, picParts[1].length() - 1);
            }
        } else if (this.pic.matches(".*t$")) {
            letterValue = "traditional";
            this.pic = this.pic.substring(0, this.pic.length() - 1);
        } else if (this.pic.matches(".*(i|I).*")) {
            letterValue = "traditional";
        }
        Numberer numb = this.numberer;
        if (numb == null) {
            ConversionResult v = StringValue.convertStringToBuiltInType(languageVal, BuiltInAtomicType.LANGUAGE, rules);
            if (v instanceof ValidationFailure) {
                throw new XPathException("The lang attribute of xsl:number must be a valid language code", "XTDE0030");
            }
            numb = config.makeNumberer(languageVal, null);
        }
        NumericGroupFormatter picGroupFormat = this.getPicSeparators();
        String str = numb.format(num.longValue(), this.pic, picGroupFormat, letterValue, ordinal);
        return hasSign ? new StringValue("-" + str) : new StringValue(str);
    }

    private NumericGroupFormatter getPicSeparators() throws XPathException {
        int[] picExpanded = StringValue.expand(this.pic);
        ArrayList<Integer> positionList = new ArrayList<Integer>();
        ArrayList<Integer> separatorList = new ArrayList<Integer>();
        int singleSeparator = 0;
        int iPos = 0;
        boolean regularCheck = true;
        int digitValue = -1;
        if (this.pic.matches("((\\d+|\\w+)#+.*)|(#+\\w+)")) {
            XPathException err = new XPathException("format-integer() picture is not valid");
            err.setErrorCode("XTDE0030");
            throw err;
        }
        int j = 0;
        block7: for (int i = picExpanded.length - 1; i >= 0; --i) {
            switch (Character.getType(picExpanded[i])) {
                case 9: {
                    if (digitValue == -1) {
                        digitValue = Alphanumeric.getDigitFamily(Alphanumeric.getDigitFamily(picExpanded[i]));
                        continue block7;
                    }
                    if (digitValue != Alphanumeric.getDigitFamily(Alphanumeric.getDigitFamily(picExpanded[i]))) {
                        XPathException err = new XPathException("format-integer() picture contains digits from different digit family.");
                        err.setErrorCode("XTDE0030");
                        throw err;
                    }
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 10: 
                case 11: {
                    continue block7;
                }
                default: {
                    if (i == picExpanded.length - 1) {
                        XPathException err = new XPathException("format-integer() picture cannot end with a separator.");
                        err.setErrorCode("XTDE0030");
                        throw err;
                    }
                    if ((char)picExpanded[i] == '#') {
                        if (i != 0) {
                            switch (Character.getType(picExpanded[i - 1])) {
                                case 1: 
                                case 2: 
                                case 4: 
                                case 5: 
                                case 9: 
                                case 10: 
                                case 11: {
                                    XPathException err = new XPathException("format-integer() picture cannot contain alphnumeric character(s) before character '#'");
                                    err.setErrorCode("XTDE0030");
                                    throw err;
                                }
                            }
                        }
                        picExpanded = picExpanded[i + 1] == singleSeparator ? this.subString(picExpanded, i + 3) : this.subString(picExpanded, i + 2);
                        i = 0;
                        continue block7;
                    }
                    iPos = picExpanded.length - i - positionList.size() - 1;
                    positionList.add(iPos);
                    separatorList.add(picExpanded[i]);
                    if (j > 0) {
                        int jPos = (Integer)positionList.get(j - 1);
                        if (jPos == iPos) {
                            XPathException err = new XPathException("format-integer() picture contains consecutive separators.");
                            err.setErrorCode("XTDE0030");
                            throw err;
                        }
                        if (jPos * (j + 1) != iPos || singleSeparator != picExpanded[i]) {
                            regularCheck = false;
                        }
                    }
                    if (i == 0) {
                        XPathException err = new XPathException("format-integer() picture cannot begin with a separator.");
                        err.setErrorCode("XTDE0030");
                        throw err;
                    }
                    singleSeparator = picExpanded[i];
                    ++j;
                }
            }
        }
        if (positionList.size() == 0) {
            return new RegularGroupFormatter(0, "");
        }
        int[] pos = new int[positionList.size()];
        int[] sep = new int[separatorList.size()];
        Integer[] posIntegerArr = positionList.toArray(new Integer[0]);
        Integer[] sepIntegerArr = separatorList.toArray(new Integer[0]);
        pos[0] = posIntegerArr[0];
        sep[0] = sepIntegerArr[0];
        for (int i = 1; i < positionList.size(); ++i) {
            pos[i] = posIntegerArr[i];
            sep[i] = sepIntegerArr[i];
        }
        this.pic = ((Object)StringValue.contract(this.extractSeparators(picExpanded, pos), picExpanded.length - pos.length)).toString();
        return regularCheck ? new RegularGroupFormatter(pos[0], "" + (char)sep[0]) : new IrregularGroupFormatter(pos, sep);
    }

    private int[] subString(int[] arr, int index) {
        int[] temp = new int[arr.length - index + 1];
        int i = index - 1;
        int j = 0;
        while (i < arr.length) {
            temp[j] = arr[i];
            ++i;
            ++j;
        }
        return temp;
    }

    private int[] extractSeparators(int[] arr, int[] excludePositions) {
        if (arr.length - 1 < excludePositions[0]) {
            return arr;
        }
        int[] temp = new int[arr.length - excludePositions.length];
        int j = 0;
        int z = 0;
        for (int i = 0; i < arr.length && z < excludePositions.length; ++i) {
            if (excludePositions[z] != i) {
                temp[j] = arr[i];
                ++j;
                continue;
            }
            ++z;
        }
        return temp;
    }
}

