/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.map;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableMap<K, V> {
    private static final int INITIAL = 20;
    public static final String NAMESPACE = "http://ns.saxonica.com/map";
    public static final SequenceType TYPE = SequenceType.makeSequenceType(new ExternalObjectType(ImmutableMap.class), 16384);
    private LinkedList<HashMap<K, V>> list;

    public ImmutableMap() {
        this.list = new LinkedList();
        this.list.add(new HashMap(20));
    }

    public ImmutableMap(LinkedList<HashMap<K, V>> existing) {
        this.list = existing;
    }

    public ImmutableMap<K, V> put(K key, V value) {
        HashMap<K, V> first = this.list.getFirst();
        if (first.size() < 20 || this.list.size() > 1 && first.size() * 2 < this.list.get(1).size()) {
            LinkedList<HashMap<K, V>> list2 = new LinkedList<HashMap<K, V>>(this.list);
            HashMap<K, V> first2 = new HashMap<K, V>(first);
            list2.removeFirst();
            list2.add(0, first2);
            first2.put(key, value);
            if (list2.size() > 1) {
                list2 = this.consolidate(list2);
            }
            return new ImmutableMap<K, V>(list2);
        }
        LinkedList<HashMap<K, V>> list2 = new LinkedList<HashMap<K, V>>(this.list);
        HashMap<K, V> first2 = new HashMap<K, V>();
        list2.add(0, first2);
        first2.put(key, value);
        return new ImmutableMap<K, V>(list2);
    }

    /*
     * WARNING - void declaration
     */
    private LinkedList<HashMap<K, V>> consolidate(LinkedList<HashMap<K, V>> list) {
        int totalSize = 0;
        int position = 0;
        for (HashMap hashMap : list) {
            if (position > 0 && totalSize < hashMap.size()) break;
            ++position;
            totalSize += hashMap.size();
        }
        if (position > 1) {
            void var5_7;
            HashMap newFirst = new HashMap();
            int n = position - 1;
            while (var5_7 >= 0) {
                newFirst.putAll(list.get((int)var5_7));
                --var5_7;
            }
            LinkedList<HashMap<K, V>> linkedList = new LinkedList<HashMap<K, V>>();
            linkedList.add(newFirst);
            for (int i = position; i < list.size(); ++i) {
                linkedList.add(list.get(i));
            }
            return linkedList;
        }
        return list;
    }

    public V get(K key) {
        for (HashMap hashMap : this.list) {
            Object value = hashMap.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public Set<K> keySet() {
        HashSet keys = new HashSet();
        for (HashMap hashMap : this.list) {
            keys.addAll(hashMap.keySet());
        }
        return keys;
    }
}

