/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.hof;

import com.saxonica.functions.hof.AbstractFunctionItem;
import com.saxonica.functions.hof.FunctionType;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.SequenceType;

public class UserFunctionItem
extends AbstractFunctionItem {
    protected UserFunctionCall target;
    private FunctionItemType functionType;

    public UserFunctionItem(UserFunctionCall target) {
        this.target = target;
    }

    public int getArity() {
        return this.target.getFunction().getNumberOfArguments();
    }

    public StructuredQName getFunctionName() {
        return this.target.getFunctionName();
    }

    public FunctionItemType getFunctionItemType() {
        if (this.functionType == null) {
            UserFunction uf = this.target.getFunction();
            if (this.target.getFunction() == null) {
                return AnyFunctionType.getInstance();
            }
            int arity = uf.getNumberOfArguments();
            SequenceType[] argTypes = new SequenceType[arity];
            for (int i = 0; i < arity; ++i) {
                argTypes[i] = uf.getArgumentType(i);
            }
            this.functionType = new FunctionType(argTypes, uf.getDeclaredResultType());
        }
        return this.functionType;
    }

    public void simplify(ExpressionVisitor visitor) throws XPathException {
        Expression exp = this.target.simplify(visitor);
        if (exp instanceof UserFunctionCall) {
            this.target = (UserFunctionCall)exp;
        }
        if (this.target.getFunctionName() == null) {
            UserFunction uf = this.target.getFunction();
            uf.setBody(uf.getBody().simplify(visitor));
        }
    }

    public void typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression exp = this.target.typeCheck(visitor, contextItemType);
        if (exp instanceof UserFunctionCall) {
            this.target = (UserFunctionCall)exp;
        }
        if (this.target.getFunctionName() == null) {
            UserFunction uf = this.target.getFunction();
            uf.setBody(uf.getBody().typeCheck(visitor, null));
        }
    }

    public SequenceIterator invoke(SequenceIterator[] args, XPathContext context) throws XPathException {
        XPathContextMajor c2 = context.newCleanContext();
        c2.setOrigin(this.target);
        c2.setCaller(context);
        c2.openStackFrame(args.length);
        for (int i = 0; i < args.length; ++i) {
            c2.setLocalVariable(i, Closure.makeIteratorClosure(args[i]));
        }
        return this.target.iterate(c2);
    }

    public void explain(ExpressionPresenter out) {
        this.target.explain(out);
    }
}

