/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.hof;

import com.saxonica.functions.hof.FunctionType;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.Value;

public class MapPairsFn
extends SystemFunction {
    public ItemType getItemType(TypeHierarchy th) {
        return ((FunctionType)this.getArguments()[0].getItemType(th)).getResultType().getPrimaryType();
    }

    public SequenceIterator iterate(final XPathContext context) throws XPathException {
        final FunctionItem function = (FunctionItem)this.getArguments()[0].evaluateItem(context);
        SequenceIterator seq0 = this.getArguments()[1].iterate(context);
        SequenceIterator seq1 = this.getArguments()[2].iterate(context);
        PairedSequenceIterator pairs = new PairedSequenceIterator(seq0, seq1);
        MappingFunction map = new MappingFunction(){

            public SequenceIterator map(Item item) throws XPathException {
                ValueRepresentation[] pair = (ValueRepresentation[])((ObjectValue)item).getObject();
                SequenceIterator[] args = new SequenceIterator[]{Value.asIterator(pair[0]), Value.asIterator(pair[1])};
                return function.invoke(args, context);
            }
        };
        return new MappingIterator(pairs, map);
    }

    private static class PairedSequenceIterator
    implements SequenceIterator {
        private SequenceIterator seq0;
        private SequenceIterator seq1;
        private int position = 0;
        private Item current = null;
        private ValueRepresentation[] args = new ValueRepresentation[2];

        public PairedSequenceIterator(SequenceIterator seq0, SequenceIterator seq1) {
            this.seq0 = seq0;
            this.seq1 = seq1;
        }

        public Item next() throws XPathException {
            Item i0 = this.seq0.next();
            if (i0 == null) {
                this.close();
                this.current = null;
                this.position = -1;
                return null;
            }
            Item i1 = this.seq1.next();
            if (i1 == null) {
                this.close();
                this.current = null;
                this.position = -1;
                return null;
            }
            this.args[0] = i0;
            this.args[1] = i1;
            this.current = new ObjectValue(this.args);
            return this.current;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public void close() {
            this.seq0.close();
            this.seq1.close();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new PairedSequenceIterator(this.seq0.getAnother(), this.seq1.getAnother());
        }

        public int getProperties() {
            return 0;
        }
    }
}

