/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.hof;

import com.saxonica.functions.hof.CoercedFunction;
import com.saxonica.functions.hof.FunctionType;
import net.sf.saxon.TypeCheckerEnvironment;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public final class FunctionSequenceCoercer
extends UnaryExpression {
    private FunctionType requiredItemType;
    private RoleLocator role;
    private TypeCheckerEnvironment visitor;

    public FunctionSequenceCoercer(Expression sequence, FunctionType requiredItemType, RoleLocator role, TypeCheckerEnvironment visitor) {
        super(sequence);
        this.requiredItemType = requiredItemType;
        this.role = role;
        this.visitor = visitor;
        ExpressionTool.copyLocationInfo(sequence, this);
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand = visitor.simplify(this.operand);
        if (this.operand instanceof Literal) {
            ValueRepresentation val = SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()));
            return Literal.makeLiteral(Value.asValue(val));
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (th.isSubType(this.operand.getItemType(th), this.requiredItemType)) {
            return this.operand;
        }
        return this;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public Expression copy() {
        return new FunctionSequenceCoercer(this.getBaseExpression().copy(), this.requiredItemType, this.role, this.visitor);
    }

    public SequenceIterator iterate(final XPathContext context) throws XPathException {
        SequenceIterator base = this.operand.iterate(context);
        ItemMappingFunction converter = new ItemMappingFunction(){

            public Item mapItem(Item item) throws XPathException {
                try {
                    return CoercedFunction.coerce((FunctionItem)item, FunctionSequenceCoercer.this.requiredItemType, FunctionSequenceCoercer.this.role, FunctionSequenceCoercer.this.visitor);
                }
                catch (XPathException e) {
                    e.maybeSetLocation(FunctionSequenceCoercer.this);
                    e.maybeSetContext(context);
                    throw e;
                }
            }
        };
        return new ItemMappingIterator(base, converter, true);
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Item item = this.operand.evaluateItem(context);
        if (item == null) {
            return null;
        }
        return CoercedFunction.coerce((FunctionItem)item, this.requiredItemType, this.role, this.visitor);
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.requiredItemType;
    }

    public int computeCardinality() {
        return this.operand.getCardinality();
    }

    public boolean equals(Object other) {
        return super.equals(other) && this.requiredItemType.equals(((FunctionSequenceCoercer)other).requiredItemType);
    }

    public int hashCode() {
        return super.hashCode() ^ this.requiredItemType.hashCode();
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("convertFunctionSequence");
        destination.emitAttribute("to", this.requiredItemType.toString(destination.getNamePool()));
        this.operand.explain(destination);
        destination.endElement();
    }
}

