/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.hof;

import com.saxonica.functions.hof.AbstractFunctionItem;
import com.saxonica.functions.hof.FunctionType;
import java.io.Serializable;
import net.sf.saxon.TypeCheckerEnvironment;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public class CoercedFunction
extends AbstractFunctionItem {
    private FunctionItem targetFunction;
    private Expression[] argumentConverters;
    private Expression resultConverter;
    private SlotManager stackFrame;
    private FunctionItemType functionType;

    public CoercedFunction(FunctionItem targetFunction) {
        this.targetFunction = targetFunction;
        this.argumentConverters = new Expression[targetFunction.getArity()];
    }

    public void setArgumentConverter(int arg, Expression converter) {
        this.argumentConverters[arg] = converter;
    }

    public void setResultConverter(Expression converter) {
        this.resultConverter = converter;
    }

    public void setStackFrameMap(SlotManager stackFrame) {
        this.stackFrame = stackFrame;
    }

    private void setFunctionItemType(FunctionItemType type) {
        this.functionType = type;
    }

    public FunctionItemType getFunctionItemType() {
        return this.functionType;
    }

    public StructuredQName getFunctionName() {
        return null;
    }

    public int getArity() {
        return this.targetFunction.getArity();
    }

    public SequenceIterator invoke(SequenceIterator[] args, XPathContext context) throws XPathException {
        XPathContextMajor c2 = context.newContext();
        ValueRepresentation[] argValues = new ValueRepresentation[args.length];
        for (int i = 0; i < args.length; ++i) {
            argValues[i] = SequenceExtent.makeSequenceExtent(args[i]);
        }
        c2.setStackFrame(this.stackFrame, argValues);
        SequenceIterator[] targetArgs = new SequenceIterator[args.length];
        for (int i = 0; i < args.length; ++i) {
            targetArgs[i] = this.argumentConverters[i] == null ? Value.asIterator(argValues[i]) : this.argumentConverters[i].iterate(c2);
        }
        SequenceIterator rawResult = this.targetFunction.invoke(targetArgs, context);
        if (this.resultConverter == null) {
            return rawResult;
        }
        SlotManager sm2 = this.stackFrame;
        if (sm2.getNumberOfVariables() == 0) {
            sm2 = context.getConfiguration().makeSlotManager();
            sm2.allocateSlotNumber(new StructuredQName("", "", "function-result"));
            c2.setStackFrame(sm2, argValues);
        }
        c2.setLocalVariable(0, SequenceExtent.makeSequenceExtent(rawResult));
        return this.resultConverter.iterate(c2);
    }

    public static CoercedFunction coerce(FunctionItem suppliedFunction, FunctionType requiredType, RoleLocator role, TypeCheckerEnvironment visitor) throws XPathException {
        Expression convertedResult;
        RoleLocator role2;
        int arity = requiredType.getArity();
        if (suppliedFunction.getArity() != arity) {
            String msg = role.composeErrorMessage(requiredType, suppliedFunction.getFunctionItemType(), visitor.getConfiguration().getNamePool());
            msg = msg + ". The supplied function has the wrong number of arguments";
            throw new XPathException(msg, "XPTY0004");
        }
        SlotManager stackFrame = visitor.getConfiguration().makeSlotManager();
        stackFrame.setNumberOfVariables(arity);
        CoercedFunction cf = new CoercedFunction(suppliedFunction);
        cf.setFunctionItemType(requiredType);
        cf.setStackFrameMap(stackFrame);
        for (int i = 0; i < arity; ++i) {
            SuppliedParameterReference param = new SuppliedParameterReference(i);
            param.setSuppliedType(((FunctionType)suppliedFunction.getFunctionItemType()).getArgumentTypes()[i]);
            role2 = new RoleLocator(0, (Serializable)((Object)""), i);
            Expression convertedParam = null;
            try {
                convertedParam = TypeChecker.staticTypeCheck(param, requiredType.getArgumentTypes()[i], false, role2, visitor);
            }
            catch (XPathException e) {
                String msg = role.composeErrorMessage(requiredType, suppliedFunction.getFunctionItemType(), visitor.getConfiguration().getNamePool());
                msg = msg + ". These are incompatible: " + e.getMessage();
                throw new XPathException(msg, "XPTY0004");
            }
            if (convertedParam == param) continue;
            cf.setArgumentConverter(i, convertedParam);
        }
        SuppliedParameterReference result = new SuppliedParameterReference(0);
        result.setSuppliedType(((FunctionType)suppliedFunction.getFunctionItemType()).getResultType());
        role2 = new RoleLocator(5, (Serializable)((Object)""), 0);
        try {
            convertedResult = TypeChecker.staticTypeCheck(result, requiredType.getResultType(), false, role2, visitor);
        }
        catch (XPathException e) {
            String msg = role.composeErrorMessage(requiredType, suppliedFunction.getFunctionItemType(), visitor.getConfiguration().getNamePool());
            msg = msg + ". These are incompatible: " + e.getMessage();
            throw new XPathException(msg, "XPTY0004");
        }
        if (convertedResult != result) {
            cf.setResultConverter(convertedResult);
        }
        return cf;
    }
}

