/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.hof;

import com.saxonica.functions.hof.CurriedFunction;
import com.saxonica.functions.hof.FirstClassFunction;
import com.saxonica.functions.hof.FunctionType;
import com.saxonica.functions.hof.UserFunctionItem;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

public abstract class AbstractFunctionItem
implements FunctionItem {
    public String getStringValue() {
        throw new UnsupportedOperationException("The string value of a function item is not defined");
    }

    public CharSequence getStringValueCS() {
        throw new UnsupportedOperationException("The string value of a function item is not defined");
    }

    public SequenceIterator getTypedValue() throws XPathException {
        throw new XPathException("The typed value of a function item is not defined", "FOTY0013");
    }

    public void simplify(ExpressionVisitor visitor) throws XPathException {
    }

    public void typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
    }

    public void optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
    }

    public FunctionItem curry(int arg, ValueRepresentation value) throws XPathException {
        return new CurriedFunction(this, arg, value);
    }

    public static AbstractFunctionItem bind(StructuredQName functionName, int arity, StaticContext env, Container container) throws XPathException {
        FunctionLibrary lib = env.getFunctionLibrary();
        Expression[] dummyArgs = new Expression[arity];
        for (int i = 0; i < arity; ++i) {
            dummyArgs[i] = new SuppliedParameterReference(i);
        }
        Expression exp = lib.bind(functionName, dummyArgs, env, container);
        if (exp instanceof UserFunctionCall) {
            return new UserFunctionItem((UserFunctionCall)exp);
        }
        ExpressionVisitor visitor = ExpressionVisitor.make(env, exp.getExecutable());
        exp = exp.simplify(visitor);
        exp = exp.typeCheck(visitor, AnyItemType.getInstance());
        SequenceType[] sig = lib.getFunctionSignature(functionName, arity);
        if (sig != null && sig.length > 0) {
            SequenceType[] args = new SequenceType[arity];
            System.arraycopy(sig, 1, args, 0, arity);
            FunctionType ft = new FunctionType(args, sig[0]);
            return new FirstClassFunction(exp, functionName, arity, ft);
        }
        return new FirstClassFunction(exp, functionName, arity, AnyFunctionType.ANY_FUNCTION);
    }

    public void explain(ExpressionPresenter out) {
    }
}

