/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import com.saxonica.functions.extfn.CompileStylesheet;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class TransformFn
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "transform");
    private static SequenceType[] argumentTypes = new SequenceType[]{CompileStylesheet.compiledStylesheetType, SequenceType.OPTIONAL_NODE, SequenceType.NODE_SEQUENCE};

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public int getMaximumNumberOfArguments() {
        return 3;
    }

    public SequenceType[] getArgumentTypes() {
        return argumentTypes;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.OPTIONAL_NODE;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new TransformFnCall();
    }

    private static class TransformFnCall
    extends ExtensionFunctionCall {
        private TransformFnCall() {
        }

        public void supplyStaticContext(StaticContext context, int locationId, Expression[] arguments) throws XPathException {
            if (!context.getConfiguration().isLicensedFeature(64)) {
                throw new XPathException("saxon:transform() is not licensed in this Configuration");
            }
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            try {
                ObjectValue templatesObject = (ObjectValue)arguments[0].next();
                if (templatesObject == null) {
                    return null;
                }
                Templates templates = (Templates)templatesObject.getObject();
                NodeInfo source = (NodeInfo)arguments[1].next();
                if (source == null) {
                    return null;
                }
                Transformer transformer = templates.newTransformer();
                if (arguments.length == 3) {
                    Item param;
                    while ((param = arguments[2].next()) != null) {
                        if (param instanceof NodeInfo) {
                            switch (((NodeInfo)param).getNodeKind()) {
                                case 1: 
                                case 2: {
                                    TransformFnCall.setTransformerParameter(param, transformer, source);
                                    break;
                                }
                                case 9: {
                                    NodeInfo kid;
                                    AxisIterator kids = ((NodeInfo)param).iterateAxis((byte)3, NodeKindTest.ELEMENT);
                                    while ((kid = (NodeInfo)kids.next()) != null) {
                                        TransformFnCall.setTransformerParameter(kid, transformer, source);
                                    }
                                    break;
                                }
                                default: {
                                    throw new XPathException("Parameters passed to saxon:transform() must be element, attribute, or document nodes");
                                }
                            }
                            continue;
                        }
                        throw new XPathException("Parameters passed to saxon:transform() must be nodes");
                    }
                }
                TinyBuilder builder = new TinyBuilder();
                builder.setPipelineConfiguration(context.getController().makePipelineConfiguration());
                transformer.transform(source, builder);
                return SingletonIterator.makeIterator(builder.getCurrentRoot());
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }

        private static void setTransformerParameter(Item param, Transformer transformer, NodeInfo source) throws XPathException {
            int fp = ((NodeInfo)param).getFingerprint();
            if (fp != -1) {
                Value val = ((NodeInfo)param).atomize();
                ((Controller)transformer).setParameter(new StructuredQName(source.getNamePool(), fp), val);
            }
        }
    }
}

