/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class Serialize
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "serialize");
    private static SequenceType[] argumentTypes = new SequenceType[]{SequenceType.OPTIONAL_NODE, SequenceType.SINGLE_ITEM};

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public SequenceType[] getArgumentTypes() {
        return argumentTypes;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_STRING;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new SerializeCall();
    }

    private static class SerializeCall
    extends ExtensionFunctionCall {
        Properties outputProperties;
        int locationId = 0;

        private SerializeCall() {
        }

        public void supplyStaticContext(StaticContext env, int locationId, Expression[] arguments) throws XPathException {
            if (!env.getConfiguration().isLicensedFeature(64)) {
                throw new XPathException("saxon:serialize is not licensed in this Configuration");
            }
            this.locationId = locationId;
            if (this.outputProperties == null && arguments[1] instanceof StringLiteral) {
                if (env instanceof ExpressionContext) {
                    String formatString = ((StringLiteral)arguments[1]).getStringValue();
                    StructuredQName formatQName = null;
                    if (formatString.length() != 0) {
                        formatQName = ((ExpressionContext)env).getStructuredQName(formatString, false);
                    }
                    this.outputProperties = ((ExpressionContext)env).getStyleElement().getPrincipalStylesheetModule().gatherOutputProperties(formatQName);
                } else {
                    this.outputProperties = new Properties();
                    this.outputProperties.setProperty("method", ((StringLiteral)arguments[1]).getStringValue());
                }
            }
        }

        public void copyLocalData(ExtensionFunctionCall destination) {
            ((SerializeCall)destination).outputProperties = this.outputProperties;
            ((SerializeCall)destination).locationId = this.locationId;
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            NodeInfo node = (NodeInfo)arguments[0].next();
            if (node == null) {
                return SingletonIterator.makeIterator(StringValue.EMPTY_STRING);
            }
            Properties props = this.outputProperties;
            if (props == null) {
                Item secondArg = arguments[1].next();
                if (!(secondArg instanceof NodeInfo) || ((NodeInfo)secondArg).getNodeKind() != 1 || ((NodeInfo)secondArg).getFingerprint() != 183) {
                    XPathException err = new XPathException("The second argument of saxon:serialize must either be a string literal, or an xsl:output element");
                    err.setXPathContext(context);
                    throw err;
                }
                props = new Properties();
                ResultDocument.processXslOutputElement((NodeInfo)secondArg, props, context);
            }
            StringWriter result = new StringWriter();
            XPathContextMinor c2 = context.newMinorContext();
            c2.setOriginatingConstructType(2053);
            SerializerFactory sf = context.getConfiguration().getSerializerFactory();
            PipelineConfiguration pipe = context.getController().makePipelineConfiguration();
            Receiver receiver = sf.getReceiver(new StreamResult(result), pipe, props);
            c2.changeOutputDestination(receiver, false, 3, null);
            SequenceReceiver out = c2.getReceiver();
            out.open();
            node.copy(out, 6, this.locationId);
            out.close();
            return SingletonIterator.makeIterator(new StringValue(result.toString()));
        }
    }
}

