/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import com.saxonica.functions.extfn.GeneralFilterFunction;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;

public class Leading
extends GeneralFilterFunction {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "leading");

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new LeadingCall();
    }

    private static class LeadingIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private FunctionItem function;
        private XPathContext context;
        private boolean exhausted = false;
        private SequenceIterator[] args = new SequenceIterator[1];

        public LeadingIterator(SequenceIterator base, FunctionItem function, XPathContext context) {
            this.base = base;
            this.function = function;
            this.context = context;
        }

        public Item next() throws XPathException {
            if (this.exhausted) {
                return null;
            }
            Item next = this.base.next();
            if (next == null) {
                return null;
            }
            this.args[0] = SingletonIterator.makeIterator(next);
            boolean matches = ExpressionTool.effectiveBooleanValue(this.function.invoke(this.args, this.context));
            if (matches) {
                return next;
            }
            this.exhausted = true;
            this.base.close();
            return null;
        }

        public Item current() {
            return this.exhausted ? null : this.base.current();
        }

        public int position() {
            return this.exhausted ? -1 : this.base.position();
        }

        public void close() {
            this.base.close();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new LeadingIterator(this.base.getAnother(), this.function, this.context);
        }

        public int getProperties() {
            return 0;
        }
    }

    private static class LeadingCall
    extends GeneralFilterFunction.GeneralFilterFunctionCall {
        private LeadingCall() {
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            XPathContextMajor c2 = context.newCleanContext();
            FunctionItem function = arguments.length == 2 ? (FunctionItem)arguments[1].next() : this.atomizer;
            return new LeadingIterator(arguments[0], function, c2);
        }
    }
}

