/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.SequenceType;

public class LastModified
extends ExtensionFunctionDefinition {
    private static StructuredQName functionName = new StructuredQName("", "http://saxon.sf.net/", "last-modified");

    public StructuredQName getFunctionQName() {
        return functionName;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.OPTIONAL_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.OPTIONAL_DATE_TIME;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new LastModifiedCall();
    }

    private static class LastModifiedCall
    extends ExtensionFunctionCall {
        private String staticBaseURI = null;

        private LastModifiedCall() {
        }

        public void supplyStaticContext(StaticContext context, int locationId, Expression[] arguments) throws XPathException {
            this.staticBaseURI = context.getBaseURI();
        }

        public void copyLocalData(ExtensionFunctionCall destination) {
            ((LastModifiedCall)destination).staticBaseURI = this.staticBaseURI;
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            long lastMod;
            URL absoluteURL;
            URI absoluteURI;
            Item item = arguments[0].next();
            if (item == null) {
                return EmptyIterator.getInstance();
            }
            String suppliedURI = item.getStringValue();
            try {
                absoluteURI = ResolveURI.makeAbsolute(suppliedURI, this.staticBaseURI);
            }
            catch (URISyntaxException e) {
                XPathException err = new XPathException("Invalid URI passed to saxon:last-modified(). Base='" + this.staticBaseURI + " Relative='" + suppliedURI, e);
                err.setErrorCode("FODC0005");
                throw err;
            }
            EscapeURI.checkPercentEncoding(absoluteURI.toString());
            try {
                absoluteURL = absoluteURI.toURL();
            }
            catch (MalformedURLException e) {
                XPathException err = new XPathException("Invalid URL passed to saxon:last-modified(). Base='" + this.staticBaseURI + " Relative='" + suppliedURI, e);
                err.setErrorCode("FODC0005");
                throw err;
            }
            try {
                URLConnection connection = absoluteURL.openConnection();
                connection.setRequestProperty("Accept-Encoding", "gzip");
                connection.connect();
                lastMod = connection.getLastModified();
            }
            catch (IOException e) {
                XPathException err = new XPathException("Cannot read from URI supplied to saxon:last-modified(). Base='" + this.staticBaseURI + " Relative='" + suppliedURI, e);
                err.setErrorCode("FODC0002");
                throw err;
            }
            if (lastMod == 0L) {
                return EmptyIterator.getInstance();
            }
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(lastMod);
            return SingletonIterator.makeIterator(new DateTimeValue(c, true));
        }
    }
}

