/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import com.saxonica.expr.IndexedSequence;
import com.saxonica.expr.IndexedValue;
import com.saxonica.functions.extfn.Evaluate;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;

public class Index
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "index");

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public int getMaximumNumberOfArguments() {
        return 3;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.ANY_SEQUENCE, SequenceType.SINGLE_ATOMIC, SequenceType.SINGLE_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_ITEM;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new IndexCall();
    }

    private static class IndexCall
    extends ExtensionFunctionCall {
        private String baseURI;
        private StringCollator stringCollator;

        private IndexCall() {
        }

        public void supplyStaticContext(StaticContext env, int locationId, Expression[] arguments) throws XPathException {
            this.baseURI = env.getBaseURI();
            if (arguments.length == 2) {
                String uri = env.getDefaultCollationName();
                this.stringCollator = env.getCollation(uri);
            } else if (arguments[2] instanceof Literal) {
                String collationName = this.getCollationName(((Literal)arguments[2]).getValue().getStringValue());
                this.stringCollator = env.getCollation(collationName);
            }
        }

        public Expression rewrite(StaticContext context, Expression[] arguments) throws XPathException {
            if (!context.getConfiguration().isLicensed()) {
                throw new XPathException("saxon:index() requires a Saxon-EE license");
            }
            return super.rewrite(context, arguments);
        }

        public void copyLocalData(ExtensionFunctionCall destination) {
            ((IndexCall)destination).baseURI = this.baseURI;
            ((IndexCall)destination).stringCollator = this.stringCollator;
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            AtomicValue arg1;
            StringCollator collator = this.stringCollator;
            if (collator == null && arguments.length > 2) {
                String collationName = this.getCollationName(arguments[2].next().getStringValue());
                collator = context.getCollation(collationName);
            }
            if (collator != null) {
                Platform platform = Configuration.getPlatform();
                if (!platform.canReturnCollationKeys(collator)) {
                    throw new XPathException("Collation used for saxon:index() must support generation of collation keys");
                }
            } else {
                collator = CodepointCollator.getInstance();
            }
            if ((arg1 = (AtomicValue)arguments[1].next()) instanceof ObjectValue && ((ObjectValue)arg1).getObject() instanceof Evaluate.PreparedExpression) {
                Expression use = ((Evaluate.PreparedExpression)((ObjectValue)arg1).getObject()).expression;
                Atomizer atomizedUse = new Atomizer(use);
                IndexedValue val = new IndexedValue(arguments[0]);
                IndexedSequence xseq = new IndexedSequence(val, atomizedUse, collator);
                ObjectValue obj = new ObjectValue(xseq);
                return SingletonIterator.makeIterator(obj);
            }
            XPathException err = new XPathException("Second argument of saxon:index must be an expression, as returned by saxon:expression");
            err.setXPathContext(context);
            throw err;
        }

        private String getCollationName(String in) throws XPathException {
            try {
                URI collationURI = new URI(in);
                if (!collationURI.isAbsolute()) {
                    if (this.baseURI == null) {
                        XPathException err = new XPathException("The collation name is a relative URI, but the base URI is unknown");
                        err.setErrorCode("XPST0001");
                        err.setIsStaticError(true);
                        throw err;
                    }
                    URI base = new URI(this.baseURI);
                    collationURI = base.resolve(collationURI);
                }
                return collationURI.toString();
            }
            catch (URISyntaxException e) {
                XPathException err = new XPathException("Collation name '" + in + "' is not a valid URI");
                err.setErrorCode("FOCH0002");
                err.setIsStaticError(true);
                throw err;
            }
        }
    }
}

